/*
 * Decompiled with CFR 0.152.
 */
package bpm.sqldesigner.query.services;

import bpm.gateway.core.DocumentGateway;
import bpm.gateway.core.exception.JdbcException;
import bpm.gateway.core.exception.ServerException;
import bpm.gateway.core.server.database.DataBaseConnection;
import bpm.sqldesigner.query.model.Column;
import bpm.sqldesigner.query.model.Table;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;

public abstract class AbstractDatabaseService {
    protected DataBaseConnection dbc = null;

    public AbstractDatabaseService(DataBaseConnection dbc) {
        this.dbc = dbc;
    }

    public AbstractDatabaseService(String host, String port, String login, String password, String dataBaseName, String driverName, String driversPath, String driversXMLFile) {
        this.dbc = new DataBaseConnection();
        this.dbc.setHost(host);
        this.dbc.setPort(port);
        this.dbc.setLogin(login);
        this.dbc.setPassword(password);
        this.dbc.setDataBaseName(dataBaseName);
        this.dbc.setDriverName(driverName);
    }

    public DataBaseConnection connect(DocumentGateway document) throws ServerException {
        if (!this.dbc.isOpened()) {
            this.dbc.connect(document);
        }
        return this.dbc;
    }

    public abstract List<Table> extractTables();

    public abstract List<Column> extractColumns(String var1);

    public boolean disconnect() {
        boolean b;
        try {
            this.dbc.disconnect();
            b = true;
        }
        catch (JdbcException e) {
            b = false;
            e.printStackTrace();
        }
        return b;
    }

    public boolean isConnected() {
        if (this.dbc != null) {
            return this.dbc.isOpened();
        }
        return false;
    }

    public boolean testQuery(String query) {
        Statement stmt = null;
        try {
            stmt = this.dbc.getSocket(null).createStatement();
            stmt.setMaxRows(1);
            stmt.execute(query);
        }
        catch (SQLException sQLException) {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e1) {
                    e1.printStackTrace();
                }
            }
            return false;
        }
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException e1) {
                e1.printStackTrace();
            }
        }
        return true;
    }
}

