/*
 * Decompiled with CFR 0.152.
 */
package bpm.sqldesigner.query.part;

import bpm.sqldesigner.query.model.Column;
import bpm.sqldesigner.query.model.Schema;
import bpm.sqldesigner.query.model.Table;
import bpm.sqldesigner.query.model.connection.JoinConnection;
import bpm.sqldesigner.query.output.SqlOutputManager;
import bpm.sqldesigner.query.part.ColumnPart;
import bpm.sqldesigner.query.part.ConnectionPart;
import bpm.sqldesigner.query.part.SchemaPart;
import bpm.sqldesigner.query.part.TablePart;
import java.beans.PropertyChangeListener;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPartListener;

public class AppEditPartFactory
implements EditPartFactory {
    private EditPartListener outputQueryListener = null;

    public EditPart createEditPart(EditPart context, Object model) {
        PropertyChangeListener part = null;
        if (model instanceof Schema) {
            part = new SchemaPart();
        } else if (model instanceof Column) {
            part = new ColumnPart();
            part.addEditPartListener(this.outputQueryListener);
        } else if (model instanceof Table) {
            if (this.outputQueryListener == null) {
                this.outputQueryListener = SqlOutputManager.getInstanceIfExists();
            }
            part = new TablePart();
            part.addEditPartListener(this.outputQueryListener);
        } else if (model instanceof JoinConnection) {
            part = new ConnectionPart();
            part.addEditPartListener(this.outputQueryListener);
        }
        part.setModel(model);
        return part;
    }
}

