/*
 * Decompiled with CFR 0.152.
 */
package bpm.sqldesigner.query.palette;

import bpm.gateway.core.DocumentGateway;
import bpm.gateway.core.exception.ServerException;
import bpm.gateway.core.server.database.DataBaseConnection;
import bpm.sqldesigner.query.commands.creation.NodeCreationFactory;
import bpm.sqldesigner.query.model.Column;
import bpm.sqldesigner.query.model.Node;
import bpm.sqldesigner.query.model.Schema;
import bpm.sqldesigner.query.model.Table;
import bpm.sqldesigner.query.services.AbstractDatabaseService;
import bpm.sqldesigner.query.services.FactoryDatabaseService;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.gef.palette.CreationToolEntry;
import org.eclipse.gef.palette.MarqueeToolEntry;
import org.eclipse.gef.palette.PaletteDrawer;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteGroup;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.palette.PaletteSeparator;
import org.eclipse.gef.palette.SelectionToolEntry;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.gef.ui.palette.PaletteViewer;

public class SQLDesignerPalette
extends PaletteViewer {
    private PaletteDrawer tablesGroup;
    private PaletteRoot paletteRoot;
    private DataBaseConnection dbc;
    private List<CreationToolEntry> hiddenToolEntries = new ArrayList<CreationToolEntry>();
    private DocumentGateway document;

    public SQLDesignerPalette(DataBaseConnection dbc, DocumentGateway document) {
        this.document = document;
        this.initalizePaletteRoot();
        this.getDBcontents(dbc);
        this.dbc = dbc;
        this.setPaletteRoot(this.paletteRoot);
    }

    public SQLDesignerPalette(Schema schema, DocumentGateway document) {
        this.document = document;
        this.initalizePaletteRoot();
        for (Node node : schema.getChildren()) {
            Table table = (Table)node;
            this.createPanelTable(table);
        }
        this.setPaletteRoot(this.paletteRoot);
    }

    protected void initalizePaletteRoot() {
        this.paletteRoot = new PaletteRoot();
        PaletteGroup manipGroup = new PaletteGroup("Objects utils");
        this.paletteRoot.add((PaletteEntry)manipGroup);
        SelectionToolEntry selectionToolEntry = new SelectionToolEntry();
        manipGroup.add((PaletteEntry)selectionToolEntry);
        manipGroup.add((PaletteEntry)new MarqueeToolEntry());
        this.paletteRoot.add((PaletteEntry)new PaletteSeparator());
        this.tablesGroup = new PaletteDrawer("Tables");
        this.paletteRoot.add((PaletteEntry)this.tablesGroup);
        this.paletteRoot.setDefaultEntry((ToolEntry)selectionToolEntry);
    }

    public void loadColumns(Table table) {
        AbstractDatabaseService dS = FactoryDatabaseService.getDataBaseService(this.dbc);
        try {
            dS.connect(this.document);
            List<Column> columns = dS.extractColumns(table.getName());
            Iterator<Column> it2 = columns.iterator();
            while (it2.hasNext()) {
                table.addChild(it2.next());
            }
            dS.disconnect();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void getDBcontents(DataBaseConnection dbc) {
        AbstractDatabaseService dS = FactoryDatabaseService.getDataBaseService(dbc);
        try {
            dS.connect(this.document);
        }
        catch (ServerException e) {
            e.printStackTrace();
        }
        if (dS.isConnected()) {
            List<Table> tables = dS.extractTables();
            for (Table table : tables) {
                this.createPanelTable(table);
            }
            dS.disconnect();
        }
    }

    protected void createPanelTable(Table table) {
        NodeCreationFactory creationFactory = new NodeCreationFactory(table);
        CreationToolEntry cte = new CreationToolEntry(table.getName(), "Creation of " + table.getName(), (CreationFactory)creationFactory, null, null);
        CreationEntryListener listener = new CreationEntryListener(cte);
        table.addPropertyChangeListener(listener);
        this.tablesGroup.add((PaletteEntry)cte);
    }

    public void filterOnName(String tableName) {
        for (Object o : this.tablesGroup.getChildren()) {
            CreationToolEntry cte;
            if (!(o instanceof CreationToolEntry)) continue;
            cte.setVisible(!this.hiddenToolEntries.contains(cte = (CreationToolEntry)o) && cte.getLabel().startsWith(tableName));
        }
    }

    public PaletteRoot getPaletteRoot() {
        return this.paletteRoot;
    }

    class CreationEntryListener
    implements PropertyChangeListener {
        private CreationToolEntry cte;

        public CreationEntryListener(CreationToolEntry cte) {
            this.cte = cte;
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            if (event.getPropertyName().equals("Table cte visible")) {
                this.cte.setVisible(true);
                SQLDesignerPalette.this.hiddenToolEntries.remove(this.cte);
            } else if (event.getPropertyName().equals("Table cte no visible")) {
                this.cte.setVisible(false);
                SQLDesignerPalette.this.hiddenToolEntries.add(this.cte);
            }
        }
    }
}

