/*
 * Decompiled with CFR 0.152.
 */
package bpm.sqldesigner.query.output;

import bpm.sqldesigner.query.SQLDesignerComposite;
import bpm.sqldesigner.query.figure.constants.Fonts;
import bpm.sqldesigner.query.model.Column;
import bpm.sqldesigner.query.model.Table;
import bpm.sqldesigner.query.model.connection.ConnectionsManager;
import bpm.sqldesigner.query.model.connection.JoinConnection;
import bpm.sqldesigner.query.model.selected.SelectedColumnsManager;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartListener;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Composite;

public class SqlOutput
extends StyledText
implements EditPartListener {
    private SQLDesignerComposite viewer;
    private String filter;

    public SqlOutput(Composite parent, int style) {
        super(parent, style);
        this.viewer = (SQLDesignerComposite)parent.getParent();
        this.setText("SQL Query\n\n\n\n");
        this.setEditable(false);
        this.setFont(Fonts.bigSimple);
        this.computeTrim(2, 2, 200, 40);
    }

    public void refreshQuery() {
        ArrayList<String> fromTables = new ArrayList<String>();
        String select = "";
        this.setText("SELECT");
        Iterator<Column> itColumns = SelectedColumnsManager.getInstance().getColumns().iterator();
        boolean first = true;
        while (itColumns.hasNext()) {
            if (!first) {
                select = String.valueOf(select) + ",";
            } else {
                first = false;
            }
            Column c = itColumns.next();
            Table t = (Table)c.getParent();
            if (!fromTables.contains(t.getName())) {
                fromTables.add(t.getName());
            }
            select = String.valueOf(select) + " ";
            select = String.valueOf(select) + t.getName() + "." + c.getName();
        }
        String where = "";
        Iterator<JoinConnection> itConnections = ConnectionsManager.getInstance().getConnections().iterator();
        first = true;
        while (itConnections.hasNext()) {
            if (!first) {
                where = String.valueOf(where) + " AND";
            } else {
                where = String.valueOf(where) + '\n' + "WHERE";
                first = false;
            }
            JoinConnection link = itConnections.next();
            Column cSource = (Column)link.getSource();
            Column cTarget = (Column)link.getTarget();
            Table tSource = (Table)cSource.getParent();
            Table tTarget = (Table)cTarget.getParent();
            if (!fromTables.contains(tSource.getName())) {
                fromTables.add(tSource.getName());
            }
            if (!fromTables.contains(tTarget.getName())) {
                fromTables.add(tTarget.getName());
            }
            where = String.valueOf(where) + " ";
            where = String.valueOf(where) + tSource.getName() + "." + cSource.getName();
            where = String.valueOf(where) + "=";
            where = String.valueOf(where) + tTarget.getName() + "." + cTarget.getName();
        }
        if (this.filter != null && !this.filter.equals("")) {
            where = where.equals("") ? String.valueOf(where) + '\n' + "WHERE" : String.valueOf(where) + " AND";
            where = String.valueOf(where) + " ( " + this.filter + " )";
        }
        String from = "";
        Iterator itTables = fromTables.iterator();
        first = true;
        from = String.valueOf(from) + '\n' + "FROM";
        while (itTables.hasNext()) {
            if (!first) {
                from = String.valueOf(from) + ",";
            } else if (first) {
                first = false;
            }
            String t = (String)itTables.next();
            from = String.valueOf(from) + " ";
            from = String.valueOf(from) + t;
        }
        this.append(select);
        this.append(from);
        this.append(where);
        this.viewer.setImageTestQueryVisible(false);
        this.redraw();
    }

    public void childAdded(EditPart child, int index) {
    }

    public void partActivated(EditPart editpart) {
    }

    public void partDeactivated(EditPart editpart) {
    }

    public void removingChild(EditPart child, int index) {
    }

    public void selectedStateChanged(EditPart editpart) {
        this.refreshQuery();
    }

    public void setFilter(String text) {
        this.filter = text;
        this.refreshQuery();
    }
}

