/*
 * Decompiled with CFR 0.152.
 */
package bpm.sqldesigner.query.model.filter;

import bpm.sqldesigner.query.model.Column;
import bpm.sqldesigner.query.model.filter.ColumnFilter;
import bpm.sqldesigner.query.model.filter.ColumnFilterWithOperation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class ColumnFilters {
    private HashMap<Column, List<ColumnFilterWithOperation>> filters = new HashMap();
    private List<ColumnFilter> predefinedFilters;

    public List<ColumnFilterWithOperation> getFilters(Column c) {
        List<ColumnFilterWithOperation> list = this.filters.get(c);
        if (list == null) {
            return new ArrayList<ColumnFilterWithOperation>();
        }
        return list;
    }

    public void putFilter(Column c, ColumnFilterWithOperation s) {
        List<ColumnFilterWithOperation> newList = this.getFilters(c);
        if (newList == null) {
            newList = new ArrayList<ColumnFilterWithOperation>();
        }
        this.findAndRemove(c, newList, s.getName());
        newList.add(s);
        this.filters.put(c, newList);
        c.setFiltred(true);
    }

    private boolean findAndRemove(Column c, List<ColumnFilterWithOperation> newList, String s) {
        Iterator<ColumnFilterWithOperation> it = newList.iterator();
        boolean found = false;
        while (it.hasNext() && !found) {
            ColumnFilterWithOperation f = it.next();
            found = f.getName().equals(s);
            if (!found) continue;
            newList.remove(f);
            if (newList.size() != 0) continue;
            c.setFiltred(false);
        }
        return found;
    }

    public Column findColumn(String columnName) {
        Column c = null;
        Set<Column> keySet = this.filters.keySet();
        Iterator<Column> itKey = keySet.iterator();
        boolean found = false;
        while (itKey.hasNext() && !found) {
            c = itKey.next();
            found = c.getName().equals(columnName);
        }
        if (found) {
            return c;
        }
        return null;
    }

    public ColumnFilterWithOperation findFilter(Column c, String filterName) {
        ColumnFilterWithOperation cFilter = null;
        if (c != null) {
            List<ColumnFilterWithOperation> listFilters = this.getFilters(c);
            Iterator<ColumnFilterWithOperation> it = listFilters.iterator();
            boolean found = false;
            while (it.hasNext() && !found) {
                cFilter = it.next();
                found = cFilter.getName().equals(filterName);
            }
        }
        return cFilter;
    }

    public void remove(Column column, ColumnFilterWithOperation columnFilterWithOperation) {
        this.findAndRemove(column, this.getFilters(column), columnFilterWithOperation.getName());
    }

    public HashMap<Column, List<ColumnFilterWithOperation>> getAllFilters() {
        return this.filters;
    }

    public List<ColumnFilter> getPredefinedFilters() {
        return this.predefinedFilters;
    }

    public void setPredefinedFilters(List<ColumnFilter> predefinedFilters) {
        this.predefinedFilters = predefinedFilters;
    }

    public void removeAll() {
    }

    public void removeForColumn(Column c) {
        this.filters.remove(c);
    }
}

