/*
 * Decompiled with CFR 0.152.
 */
package bpm.sqldesigner.query.model;

import bpm.sqldesigner.query.model.connection.ConnectionsManager;
import bpm.sqldesigner.query.model.connection.JoinConnection;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.geometry.Rectangle;

public class Node {
    private String name;
    private Rectangle layout;
    private List<Node> children;
    private Node parent = null;
    private PropertyChangeSupport listeners;
    public static final String PROPERTY_LAYOUT = "NodeLayout";
    public static final String PROPERTY_ADD = "NodeAddChild";
    public static final String PROPERTY_REMOVE = "NodeRemoveChild";
    public static final String SOURCE_CONNECTIONS_PROP = "nodeSourceLink";
    public static final String TARGET_CONNECTIONS_PROP = "nodeTargetLink";
    public static final String CONNECTIONS_PROP = "Nodelinks";
    public static final String REMOVE = "NodeRemove";
    private List<JoinConnection> sourceConnections = new ArrayList<JoinConnection>();
    private List<JoinConnection> targetConnections = new ArrayList<JoinConnection>();

    public Node() {
        this.layout = new Rectangle(10, 10, 100, 100);
        this.children = new ArrayList<Node>();
        this.listeners = new PropertyChangeSupport(this);
    }

    public void setLayout(Rectangle newLayout) {
        Rectangle oldLayout = this.layout;
        this.layout = newLayout;
        this.getListeners().firePropertyChange(PROPERTY_LAYOUT, oldLayout, newLayout);
    }

    public Rectangle getLayout() {
        return this.layout;
    }

    public boolean addChild(Node child) {
        for (Node n : this.children) {
            if (!n.getName().equals(child.getName())) continue;
            return false;
        }
        boolean b = this.children.add(child);
        if (b) {
            child.setParent(this);
            this.getListeners().firePropertyChange(PROPERTY_ADD, null, child);
        }
        return b;
    }

    public boolean removeChild(Node child) {
        boolean b = this.children.remove(child);
        if (b) {
            this.getListeners().firePropertyChange(PROPERTY_REMOVE, child, null);
        }
        return b;
    }

    public List<Node> getChildrenArray() {
        return this.children;
    }

    public void setParent(Node parent) {
        this.parent = parent;
    }

    public Node getParent() {
        return this.parent;
    }

    public List<Node> getChildren() {
        return this.children;
    }

    public int getChildrenNumber() {
        return this.children.size() + 1;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.addPropertyChangeListener(listener);
    }

    public PropertyChangeSupport getListeners() {
        return this.listeners;
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.removePropertyChangeListener(listener);
    }

    public boolean contains(Node child) {
        return this.children.contains(child);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void addConnection(JoinConnection conn) {
        if (conn == null || conn.getSource() == conn.getTarget()) {
            throw new IllegalArgumentException();
        }
        if (conn.getSource() == this) {
            this.sourceConnections.add(conn);
            this.getListeners().firePropertyChange(SOURCE_CONNECTIONS_PROP, null, conn);
        } else if (conn.getTarget() == this) {
            this.targetConnections.add(conn);
            this.getListeners().firePropertyChange(TARGET_CONNECTIONS_PROP, null, conn);
        }
    }

    public void removeConnection(JoinConnection conn) {
        if (conn == null) {
            throw new IllegalArgumentException();
        }
        if (conn.getSource() == this) {
            this.sourceConnections.remove(conn);
            this.getListeners().firePropertyChange(SOURCE_CONNECTIONS_PROP, null, conn);
        } else if (conn.getTarget() == this) {
            this.targetConnections.remove(conn);
            this.getListeners().firePropertyChange(TARGET_CONNECTIONS_PROP, null, conn);
        }
    }

    public List<JoinConnection> getSourceConnections() {
        return new ArrayList<JoinConnection>(this.sourceConnections);
    }

    public List<JoinConnection> getAllConnections() {
        ArrayList<JoinConnection> list = new ArrayList<JoinConnection>();
        return list;
    }

    public List<JoinConnection> getTargetConnections() {
        return new ArrayList<JoinConnection>(this.targetConnections);
    }

    public void removeAllConnection() {
        for (JoinConnection j : this.sourceConnections) {
            j.getTarget().removeConnection(j);
            this.getListeners().firePropertyChange(SOURCE_CONNECTIONS_PROP, null, j);
            ConnectionsManager.getInstance().removeConnection(j);
        }
        this.sourceConnections.clear();
        for (JoinConnection j : this.targetConnections) {
            j.getSource().removeConnection(j);
            this.getListeners().firePropertyChange(TARGET_CONNECTIONS_PROP, null, j);
            ConnectionsManager.getInstance().removeConnection(j);
        }
        this.targetConnections.clear();
    }

    public void fireRemoveOrAdd() {
        this.getListeners().firePropertyChange(REMOVE, null, null);
    }
}

