/*
 * Decompiled with CFR 0.152.
 */
package bpm.sqldesigner.query.editpolicies;

import bpm.sqldesigner.query.SQLDesignerComposite;
import bpm.sqldesigner.query.commands.AbstractLayoutCommand;
import bpm.sqldesigner.query.commands.TableChangeLayoutCommand;
import bpm.sqldesigner.query.commands.creation.TableCreateCommand;
import bpm.sqldesigner.query.model.Column;
import bpm.sqldesigner.query.model.Node;
import bpm.sqldesigner.query.model.Table;
import bpm.sqldesigner.query.part.SchemaPart;
import bpm.sqldesigner.query.part.TablePart;
import java.util.Iterator;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.XYLayoutEditPolicy;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.swt.widgets.Composite;

public class AppEditLayoutPolicy
extends XYLayoutEditPolicy {
    protected Command createChangeConstraintCommand(EditPart child, Object constraint) {
        TableChangeLayoutCommand command = null;
        if (child instanceof TablePart) {
            command = new TableChangeLayoutCommand();
        }
        ((AbstractLayoutCommand)command).setModel(child.getModel());
        Rectangle constraintRect = (Rectangle)constraint;
        Rectangle rect = ((SchemaPart)this.getHost()).getFigure().getBounds();
        constraintRect.x = constraintRect.x < 0 ? 0 : constraintRect.x;
        constraintRect.y = constraintRect.y < 0 ? 0 : constraintRect.y;
        constraintRect.x = constraintRect.x > rect.width ? rect.width - 50 : constraintRect.x;
        constraintRect.y = constraintRect.y > rect.height ? rect.height - 50 : constraintRect.y;
        ((AbstractLayoutCommand)command).setConstraint(constraintRect);
        return command;
    }

    protected Command getCreateCommand(CreateRequest request) {
        if (request.getType() == "create child" && this.getHost() instanceof SchemaPart) {
            TableCreateCommand cmd = new TableCreateCommand();
            cmd.setSchema(this.getHost().getModel());
            Composite cmp = this.getHost().getViewer().getControl().getParent();
            while (!((cmp = cmp.getParent()) instanceof SQLDesignerComposite)) {
                if (cmp == null) break;
            }
            Table table = (Table)request.getNewObject();
            cmd.setTable(table, ((SQLDesignerComposite)cmp).getPalette());
            Rectangle constraint = (Rectangle)this.getConstraintFor(request);
            constraint.x = constraint.x < 0 ? 0 : constraint.x;
            constraint.y = constraint.y < 0 ? 0 : constraint.y;
            Iterator<Node> it = table.getChildren().iterator();
            int lMax = 0;
            int l = 0;
            while (it.hasNext()) {
                Column c = (Column)it.next();
                l = (String.valueOf(c.getName()) + "---" + c.getType()).length();
                if (c.isKey()) {
                    l += 4;
                }
                if (l <= lMax) continue;
                lMax = l;
            }
            constraint.width = 9 * lMax + 65;
            constraint.height = 19 * table.getChildrenNumber();
            cmd.setLayout(constraint);
            return cmd;
        }
        return null;
    }
}

