/*
 * Decompiled with CFR 0.152.
 */
package bpm.sqldesigner.query.editor.filter;

import bpm.sqldesigner.query.Activator;
import bpm.sqldesigner.query.SQLDesignerComposite;
import bpm.sqldesigner.query.model.Column;
import bpm.sqldesigner.query.model.filter.ColumnFilterWithOperation;
import bpm.sqldesigner.query.model.filter.ColumnFiltersManager;
import bpm.sqldesigner.query.output.SqlOutputManager;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class FiltersManagerComposite
extends Composite {
    private StyledText filtersManagerText;
    private HashMap<MenuItem, String> filtersValues = new HashMap();
    private ToolItem applyFilterItem;
    private Menu menu;
    static String filtersSave = "";

    public FiltersManagerComposite(Composite parent, int style, SQLDesignerComposite designerComposite) {
        super(parent, style);
        this.createWidgets(this);
    }

    private void createWidgets(Composite parent) {
        final ToolBar toolBar = new ToolBar((Composite)this, 0x800100);
        toolBar.setLayoutData((Object)new GridData(768));
        toolBar.setLayout((Layout)new GridLayout(4, false));
        ToolItem item1 = new ToolItem(toolBar, 8);
        item1.setText("AND");
        item1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (FiltersManagerComposite.this.filtersManagerText.getText().equals("\n\n")) {
                    FiltersManagerComposite.this.filtersManagerText.setText("");
                }
                FiltersManagerComposite.this.filtersManagerText.insert(" AND");
                FiltersManagerComposite.this.filtersManagerText.setCaretOffset(FiltersManagerComposite.this.filtersManagerText.getText().length());
            }
        });
        ToolItem item2 = new ToolItem(toolBar, 8);
        item2.setText("OR");
        item2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (FiltersManagerComposite.this.filtersManagerText.getText().equals("\n\n")) {
                    FiltersManagerComposite.this.filtersManagerText.setText("");
                }
                FiltersManagerComposite.this.filtersManagerText.insert(" OR");
                FiltersManagerComposite.this.filtersManagerText.setCaretOffset(FiltersManagerComposite.this.filtersManagerText.getText().length());
            }
        });
        ToolItem item3 = new ToolItem(toolBar, 8);
        item3.setText("(");
        item3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (FiltersManagerComposite.this.filtersManagerText.getText().equals("\n\n")) {
                    FiltersManagerComposite.this.filtersManagerText.setText("");
                }
                FiltersManagerComposite.this.filtersManagerText.insert(" (");
                FiltersManagerComposite.this.filtersManagerText.setCaretOffset(FiltersManagerComposite.this.filtersManagerText.getText().length());
            }
        });
        ToolItem item4 = new ToolItem(toolBar, 8);
        item4.setText(")");
        item4.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (FiltersManagerComposite.this.filtersManagerText.getText().equals("\n\n")) {
                    FiltersManagerComposite.this.filtersManagerText.setText("");
                }
                FiltersManagerComposite.this.filtersManagerText.insert(" )");
                FiltersManagerComposite.this.filtersManagerText.setCaretOffset(FiltersManagerComposite.this.filtersManagerText.getText().length());
            }
        });
        new ToolItem(toolBar, 2);
        this.menu = new Menu((Control)this);
        HashMap<Column, List<ColumnFilterWithOperation>> filters = ColumnFiltersManager.getInstance().getAllFilters();
        Set<Column> keys = filters.keySet();
        for (Column c : keys) {
            List<ColumnFilterWithOperation> list = filters.get(c);
            Iterator<ColumnFilterWithOperation> itFilters = list.iterator();
            String columnName = c.getName();
            while (itFilters.hasNext()) {
                ColumnFilterWithOperation filter = itFilters.next();
                MenuItem item = new MenuItem(this.menu, 64);
                item.setText(String.valueOf(columnName) + "." + filter.getName() + "     |     " + filter.getOperation() + filter.getValue());
                this.filtersValues.put(item, String.valueOf(columnName) + "." + filter.getName());
                item.addSelectionListener(new SelectionListener(){

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }

                    public void widgetSelected(SelectionEvent e) {
                        String value = (String)FiltersManagerComposite.this.filtersValues.get(e.getSource());
                        if (FiltersManagerComposite.this.filtersManagerText.getText().equals("\n\n")) {
                            FiltersManagerComposite.this.filtersManagerText.setText("");
                        }
                        FiltersManagerComposite.this.filtersManagerText.insert(" " + value);
                        FiltersManagerComposite.this.filtersManagerText.setCaretOffset(FiltersManagerComposite.this.filtersManagerText.getText().length());
                    }
                });
            }
        }
        final ToolItem item = new ToolItem(toolBar, 4);
        item.setText("Filters");
        item.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                Rectangle rect = item.getBounds();
                Point pt = new Point(rect.x, rect.y + rect.height);
                pt = toolBar.toDisplay(pt);
                FiltersManagerComposite.this.menu.setLocation(pt.x, pt.y);
                FiltersManagerComposite.this.menu.setVisible(true);
            }
        });
        this.filtersManagerText = new StyledText((Composite)this, 2626);
        this.filtersManagerText.setLayoutData((Object)new GridData(768));
        this.filtersManagerText.setText(filtersSave);
        if (this.filtersManagerText.getText().equals("")) {
            this.filtersManagerText.setText("\n\n");
        }
        ToolBar filterToolBar = new ToolBar((Composite)this, 0x800000);
        Listener cancelListener = new Listener(){

            public void handleEvent(Event event) {
                FiltersManagerComposite.this.close();
            }
        };
        ToolItem toolItem1 = new ToolItem(filterToolBar, 0);
        toolItem1.setImage(Activator.getDefault().getImageRegistry().get("cancel"));
        toolItem1.setToolTipText("Cancel");
        toolItem1.addListener(13, cancelListener);
        this.applyFilterItem = new ToolItem(filterToolBar, 0);
        this.applyFilterItem.setImage(Activator.getDefault().getImageRegistry().get("valid"));
        this.applyFilterItem.setToolTipText("Apply");
        this.applyFilterItem.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (!FiltersManagerComposite.this.filtersManagerText.getText().equals("\n\n")) {
                    FiltersManagerComposite.this.decodeFilter();
                    filtersSave = FiltersManagerComposite.this.filtersManagerText.getText();
                }
                FiltersManagerComposite.this.close();
            }
        });
    }

    protected void decodeFilter() {
        String value = this.filtersManagerText.getText();
        StringBuffer valueBuffer = new StringBuffer(value);
        if (!value.trim().equals("")) {
            char[] charArray = value.toCharArray();
            int i = 0;
            while (i < charArray.length) {
                if (charArray[i] == '.') {
                    int j = 1;
                    char c = 'a';
                    String cName = "";
                    while (c != ' ' && c != ')' && c != '(' && j <= i) {
                        c = charArray[i - j];
                        if (c != ' ' && c != ')' && c != '(') {
                            cName = String.valueOf(c) + cName;
                        }
                        ++j;
                    }
                    j = 1;
                    c = 'a';
                    String fName = "";
                    while (c != ' ' && c != ')' && c != '(' && i + j < charArray.length) {
                        c = charArray[i + j];
                        if (c != ' ' && c != ')' && c != '(') {
                            fName = String.valueOf(fName) + c;
                        }
                        ++j;
                    }
                    Column column = ColumnFiltersManager.getInstance().findColumn(cName);
                    ColumnFilterWithOperation filter = ColumnFiltersManager.getInstance().findFilter(column, fName);
                    String tableName = column.getParent().getName();
                    int x = valueBuffer.indexOf(String.valueOf(cName) + "." + fName);
                    valueBuffer.replace(x, x + (String.valueOf(cName) + "." + fName).length(), String.valueOf(tableName) + "." + cName + filter.getOperation() + filter.getValue());
                }
                ++i;
            }
            SqlOutputManager.getInstanceIfExists().setFilter(valueBuffer.substring(0));
        } else {
            SqlOutputManager.getInstanceIfExists().setFilter("");
        }
    }

    protected void close() {
        this.setVisible(false);
        Composite tampon = this.getParent().getParent();
        this.dispose();
        tampon.layout();
    }

    class DropdownSelectionListener
    extends SelectionAdapter {
        private ToolItem dropdown;
        private Menu menu;

        public DropdownSelectionListener(ToolItem dropdown) {
            this.dropdown = dropdown;
            this.menu = new Menu((Control)dropdown.getParent().getShell());
        }

        public void add(String item) {
            MenuItem menuItem = new MenuItem(this.menu, 0);
            menuItem.setText(item);
            menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    MenuItem selected = (MenuItem)event.widget;
                    DropdownSelectionListener.this.dropdown.setText(selected.getText());
                }
            });
        }

        public void widgetSelected(SelectionEvent event) {
            if (event.detail == 4) {
                ToolItem item = (ToolItem)event.widget;
                Rectangle rect = item.getBounds();
                Point pt = item.getParent().toDisplay(new Point(rect.x, rect.y));
                this.menu.setLocation(pt.x, pt.y + rect.height);
                this.menu.setVisible(true);
            }
        }
    }
}

