/*
 * Decompiled with CFR 0.152.
 */
package bpm.sqldesigner.query.editor.filter;

import bpm.sqldesigner.query.Activator;
import bpm.sqldesigner.query.SQLDesignerComposite;
import bpm.sqldesigner.query.editor.SQLEditor;
import bpm.sqldesigner.query.model.Column;
import bpm.sqldesigner.query.model.Table;
import bpm.sqldesigner.query.model.filter.ColumnFilter;
import bpm.sqldesigner.query.model.filter.ColumnFilterWithOperation;
import bpm.sqldesigner.query.model.filter.ColumnFiltersManager;
import java.util.Iterator;
import java.util.List;
import org.eclipse.gef.EditPart;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class FiltersComposite
extends Composite {
    private Combo filterNamesCombo;
    private Label labelFilter;
    private Combo opCombo;
    private StyledText textFilter;
    private ToolItem applyFilterItem;
    private ApplyFilterListener applyFilterListener;
    private StyledText filterName;
    private NamesComboListener listenerCombo;
    private SQLEditor viewer;
    private ISelectionChangedListener editorListener;
    private ToolItem trashToolItem;
    private Listener trashListener;
    private SQLDesignerComposite designerComposite;
    private Combo predefinedFiltersCombo;
    private Button newFilterButton;
    private Button existingFiltersButton;
    private Button predefinedFiltersButton;
    private int filtersDeletedCount = 0;

    public FiltersComposite(Composite parent, int style, final SQLDesignerComposite designerComposite) {
        super(parent, style);
        this.viewer = designerComposite.getEditor();
        this.designerComposite = designerComposite;
        Composite filterCNames1 = new Composite((Composite)this, 0);
        filterCNames1.setLayout((Layout)new GridLayout(5, false));
        filterCNames1.setLayoutData((Object)new GridData(1, 2, true, false, 5, 1));
        this.newFilterButton = new Button(filterCNames1, 16);
        this.newFilterButton.setText("New Filter");
        this.existingFiltersButton = new Button(filterCNames1, 16);
        this.existingFiltersButton.setText("Existing Filters");
        this.existingFiltersButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                FiltersComposite.this.filterNamesCombo.setEnabled(true);
                FiltersComposite.this.filterNamesCombo.deselectAll();
                FiltersComposite.this.predefinedFiltersCombo.setEnabled(false);
                FiltersComposite.this.predefinedFiltersCombo.deselectAll();
                FiltersComposite.this.filterName.setText("");
                FiltersComposite.this.textFilter.setText("");
                FiltersComposite.this.opCombo.select(0);
            }
        });
        this.filterNamesCombo = new Combo(filterCNames1, 2056);
        this.filterNamesCombo.setEnabled(false);
        this.predefinedFiltersButton = new Button(filterCNames1, 16);
        this.predefinedFiltersButton.setText("Predefined Filters");
        this.predefinedFiltersButton.addSelectionListener((SelectionListener)new PredefinedFilterListener());
        this.predefinedFiltersCombo = new Combo(filterCNames1, 2056);
        this.predefinedFiltersCombo.setEnabled(false);
        this.predefinedFiltersCombo.addSelectionListener((SelectionListener)new PredefinedFilterComboListener());
        Label separator = new Label((Composite)this, 258);
        separator.setLayoutData((Object)new GridData(4, 4, false, false, 5, 1));
        Composite filterCNames = new Composite((Composite)this, 0);
        filterCNames.setLayout((Layout)new GridLayout(2, false));
        filterCNames.setLayoutData((Object)new GridData(4, 2, true, false, 2, 1));
        Label label1 = new Label(filterCNames, 0);
        label1.setLayoutData((Object)new GridData(4));
        label1.setText("Filter's name :");
        this.filterName = new StyledText(filterCNames, 2048);
        this.filterName.setLayoutData((Object)new GridData(4, 2, true, false, 1, 1));
        Composite voidC = new Composite((Composite)this, 0);
        voidC.setLayout((Layout)new GridLayout(1, false));
        voidC.setLayoutData((Object)new GridData(4, 2, true, false, 1, 1));
        Composite voidC2 = new Composite((Composite)this, 0);
        voidC2.setLayout((Layout)new GridLayout(1, false));
        voidC2.setLayoutData((Object)new GridData(4, 2, true, false, 1, 1));
        Composite voidC3 = new Composite((Composite)this, 0);
        voidC3.setLayout((Layout)new GridLayout(1, false));
        voidC3.setLayoutData((Object)new GridData(4, 2, true, false, 1, 1));
        Label separator2 = new Label((Composite)this, 258);
        separator2.setLayoutData((Object)new GridData(4, 4, false, false, 5, 1));
        Composite filterValueC = new Composite((Composite)this, 0);
        filterValueC.setLayout((Layout)new GridLayout(4, false));
        filterValueC.setLayoutData((Object)new GridData(4, 2, true, false, 5, 1));
        this.labelFilter = new Label(filterValueC, 0);
        this.labelFilter.setText("                                       ");
        this.labelFilter.setLayoutData((Object)new GridData(2, 2, false, false, 1, 1));
        this.opCombo = new Combo(filterValueC, 8);
        this.opCombo.setLayoutData((Object)new GridData(1, 2, false, false, 1, 1));
        String[] stringArray = ColumnFilter.OPERATORS;
        int n = ColumnFilter.OPERATORS.length;
        int n2 = 0;
        while (n2 < n) {
            String op = stringArray[n2];
            this.opCombo.add(op);
            ++n2;
        }
        this.opCombo.select(0);
        this.opCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                String opValue = FiltersComposite.this.opCombo.getText();
                if (opValue.equals(" IS NULL") || opValue.equals(" IS NOT NULL")) {
                    FiltersComposite.this.textFilter.setEditable(false);
                    FiltersComposite.this.textFilter.setEnabled(false);
                    FiltersComposite.this.textFilter.setBackground(FiltersComposite.this.getDisplay().getSystemColor(15));
                } else if (!FiltersComposite.this.textFilter.getEditable()) {
                    FiltersComposite.this.textFilter.setEditable(true);
                    FiltersComposite.this.textFilter.setEnabled(true);
                    FiltersComposite.this.textFilter.setBackground(FiltersComposite.this.getDisplay().getSystemColor(1));
                }
            }
        });
        this.textFilter = new StyledText(filterValueC, 2048);
        this.textFilter.setLayoutData((Object)new GridData(768));
        ToolBar filterToolBar = new ToolBar(filterValueC, 0x800000);
        Listener cancelListener = new Listener(){

            public void handleEvent(Event event) {
                FiltersComposite.this.close();
            }
        };
        this.trashToolItem = new ToolItem(filterToolBar, 0);
        this.trashToolItem.setImage(Activator.getDefault().getImageRegistry().get("trash"));
        this.trashToolItem.setToolTipText("Delete");
        ToolItem toolItem1 = new ToolItem(filterToolBar, 0);
        toolItem1.setImage(Activator.getDefault().getImageRegistry().get("cancel"));
        toolItem1.setToolTipText("Cancel");
        toolItem1.addListener(13, cancelListener);
        this.applyFilterItem = new ToolItem(filterToolBar, 0);
        this.applyFilterItem.setImage(Activator.getDefault().getImageRegistry().get("valid"));
        this.applyFilterItem.setToolTipText("Apply");
        this.editorListener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                EditPart editpart;
                List selected = designerComposite.getEditor().getSelectedEditParts();
                if (selected.size() == 1 && (editpart = (EditPart)selected.iterator().next()).getModel() instanceof Column) {
                    Column c = (Column)editpart.getModel();
                    FiltersComposite.this.textFilter.insert(" " + ((Table)c.getParent()).getName() + "." + c.getName());
                    FiltersComposite.this.textFilter.setCaretOffset(FiltersComposite.this.textFilter.getText().length());
                    FiltersComposite.this.textFilter.setFocus();
                }
            }
        };
    }

    public void openFilterComposite(Column model) {
        if (this.isVisible()) {
            return;
        }
        this.setVisible(true);
        List<ColumnFilterWithOperation> filters = ColumnFiltersManager.getInstance().getFilters(model);
        this.filterNamesCombo.removeAll();
        if (filters.size() != 0) {
            Iterator<ColumnFilterWithOperation> it = filters.iterator();
            while (it.hasNext()) {
                this.filterNamesCombo.add(it.next().getName());
            }
        } else {
            this.existingFiltersButton.setEnabled(false);
        }
        List<ColumnFilter> predefinedFilters = ColumnFiltersManager.getInstance().getPredefinedFilters();
        if (predefinedFilters != null) {
            int j = 0;
            Iterator<ColumnFilter> it = predefinedFilters.iterator();
            while (it.hasNext()) {
                String name = it.next().getName();
                String[] items = this.filterNamesCombo.getItems();
                int i = 0;
                boolean found = false;
                while (i < items.length && !found) {
                    found = items[i].equals(name);
                    ++i;
                }
                if (!found) {
                    this.predefinedFiltersCombo.add(name);
                    continue;
                }
                ++j;
            }
            if (j == predefinedFilters.size()) {
                this.predefinedFiltersButton.setEnabled(false);
            }
        } else {
            this.predefinedFiltersButton.setEnabled(false);
        }
        this.listenerCombo = new NamesComboListener(filters, model);
        this.filterNamesCombo.addSelectionListener((SelectionListener)this.listenerCombo);
        this.newFilterButton.addSelectionListener((SelectionListener)new NewFilterListener(filters));
        this.newFilterButton.setSelection(true);
        this.designerComposite.setGroupFiltersText(String.valueOf(model.getName()) + " filters : ");
        this.textFilter.setText("");
        this.filterName.setEditable(true);
        this.filterName.setEnabled(true);
        this.filterName.setBackground(this.getDisplay().getSystemColor(1));
        this.filterName.setText("filter" + (filters.size() + 1));
        this.filterNamesCombo.select(0);
        this.opCombo.select(0);
        this.trashToolItem.setEnabled(false);
        this.textFilter.setFocus();
        this.labelFilter.setText(model.getName());
        this.applyFilterListener = new ApplyFilterListener(model);
        this.applyFilterItem.addListener(13, (Listener)this.applyFilterListener);
        this.viewer.addSelectionChangedListener(this.editorListener);
    }

    public void close() {
        this.setVisible(false);
        this.applyFilterItem.removeListener(13, (Listener)this.applyFilterListener);
        this.filterNamesCombo.removeSelectionListener((SelectionListener)this.listenerCombo);
        this.viewer.removeSelectionChangedListener(this.editorListener);
        Composite tampon = this.getParent().getParent();
        this.dispose();
        tampon.layout();
    }

    protected class ApplyFilterListener
    implements Listener {
        private Column column;

        public ApplyFilterListener(Column c) {
            this.column = c;
        }

        public void handleEvent(Event event) {
            ColumnFilterWithOperation cFilter = new ColumnFilterWithOperation();
            String name = FiltersComposite.this.filterName.getText();
            if (name.equals("")) {
                name = "filter" + (ColumnFiltersManager.getInstance().getFilters(this.column).size() + 1);
            }
            cFilter.setName(name);
            String value = FiltersComposite.this.textFilter.getText();
            String opValue = FiltersComposite.this.opCombo.getText();
            if (!value.equals("") || opValue.equals(" IS NULL") || opValue.equals(" IS NOT NULL")) {
                cFilter.setValue(value);
                cFilter.setOperation(FiltersComposite.this.opCombo.getText());
                ColumnFiltersManager.getInstance().putFilter(this.column, cFilter);
            }
            FiltersComposite.this.close();
        }
    }

    protected class NamesComboListener
    implements SelectionListener {
        private List<ColumnFilterWithOperation> filters;
        private Column column;

        public NamesComboListener(List<ColumnFilterWithOperation> l, Column column) {
            this.filters = l;
            this.column = column;
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            final int index = FiltersComposite.this.filterNamesCombo.getSelectionIndex();
            FiltersComposite.this.filterName.setText(FiltersComposite.this.filterNamesCombo.getItem(index));
            FiltersComposite.this.textFilter.setText(this.filters.get(index).getValue());
            FiltersComposite.this.filterName.setEditable(false);
            FiltersComposite.this.filterName.setEnabled(false);
            FiltersComposite.this.filterName.setBackground(FiltersComposite.this.getDisplay().getSystemColor(15));
            FiltersComposite.this.opCombo.setText(this.filters.get(index).getOperation());
            FiltersComposite.this.trashListener = new Listener(){

                public void handleEvent(Event event) {
                    ColumnFiltersManager.getInstance().remove(NamesComboListener.this.column, (ColumnFilterWithOperation)NamesComboListener.this.filters.get(index));
                    FiltersComposite filtersComposite = FiltersComposite.this;
                    filtersComposite.filtersDeletedCount = filtersComposite.filtersDeletedCount + 1;
                    FiltersComposite.this.filterNamesCombo.remove(index);
                    FiltersComposite.this.newFilterButton.setSelection(true);
                    FiltersComposite.this.trashToolItem.setEnabled(false);
                    FiltersComposite.this.trashToolItem.removeListener(13, (Listener)this);
                    FiltersComposite.this.filterName.setText("filter" + (NamesComboListener.this.filters.size() + 1));
                    FiltersComposite.this.textFilter.setText("");
                    FiltersComposite.this.filterName.setEditable(true);
                    FiltersComposite.this.filterName.setEnabled(true);
                    FiltersComposite.this.filterName.setBackground(FiltersComposite.this.getDisplay().getSystemColor(1));
                    FiltersComposite.this.opCombo.select(0);
                    FiltersComposite.this.filterNamesCombo.setEnabled(false);
                    FiltersComposite.this.existingFiltersButton.setSelection(false);
                    if (NamesComboListener.this.filters.size() == 0) {
                        FiltersComposite.this.existingFiltersButton.setEnabled(false);
                    }
                }
            };
            FiltersComposite.this.trashToolItem.addListener(13, FiltersComposite.this.trashListener);
            FiltersComposite.this.trashToolItem.setEnabled(true);
        }
    }

    protected class NewFilterListener
    implements SelectionListener {
        private List<ColumnFilterWithOperation> filters;

        public NewFilterListener(List<ColumnFilterWithOperation> l) {
            this.filters = l;
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            FiltersComposite.this.filterName.setText("filter" + (this.filters.size() + 1));
            FiltersComposite.this.textFilter.setText("");
            FiltersComposite.this.filterName.setEditable(true);
            FiltersComposite.this.filterName.setEnabled(true);
            FiltersComposite.this.filterName.setBackground(FiltersComposite.this.getDisplay().getSystemColor(1));
            FiltersComposite.this.trashToolItem.setEnabled(false);
            FiltersComposite.this.filterNamesCombo.setEnabled(false);
            FiltersComposite.this.opCombo.select(0);
            FiltersComposite.this.predefinedFiltersCombo.setEnabled(false);
        }
    }

    protected class PredefinedFilterComboListener
    implements SelectionListener {
        protected PredefinedFilterComboListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            List<ColumnFilter> predefinedFilters = ColumnFiltersManager.getInstance().getPredefinedFilters();
            String cName = FiltersComposite.this.predefinedFiltersCombo.getItem(FiltersComposite.this.predefinedFiltersCombo.getSelectionIndex());
            boolean found = false;
            Iterator<ColumnFilter> it = predefinedFilters.iterator();
            ColumnFilter c = null;
            while (it.hasNext() && !found) {
                c = it.next();
                if (!c.getName().equals(cName)) continue;
                found = true;
            }
            if (found) {
                if (c.needsApostrophe()) {
                    FiltersComposite.this.textFilter.setText("'" + c.getValue() + "'");
                } else {
                    FiltersComposite.this.textFilter.setText(c.getValue());
                }
                FiltersComposite.this.filterName.setText(c.getName());
                FiltersComposite.this.filterName.setEditable(false);
                FiltersComposite.this.filterName.setEnabled(false);
                FiltersComposite.this.filterName.setBackground(FiltersComposite.this.getDisplay().getSystemColor(15));
            }
        }
    }

    protected class PredefinedFilterListener
    implements SelectionListener {
        protected PredefinedFilterListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            FiltersComposite.this.textFilter.setText("");
            FiltersComposite.this.filterName.setEditable(true);
            FiltersComposite.this.filterName.setEnabled(true);
            FiltersComposite.this.filterName.setBackground(FiltersComposite.this.getDisplay().getSystemColor(1));
            FiltersComposite.this.trashToolItem.setEnabled(false);
            FiltersComposite.this.filterNamesCombo.setEnabled(false);
            FiltersComposite.this.filterNamesCombo.deselectAll();
            FiltersComposite.this.predefinedFiltersCombo.setEnabled(true);
            FiltersComposite.this.predefinedFiltersCombo.deselectAll();
            FiltersComposite.this.filterName.setText("");
            FiltersComposite.this.opCombo.select(0);
        }
    }
}

