/*
 * Decompiled with CFR 0.152.
 */
package bpm.sqldesigner.query.editor;

import bpm.sqldesigner.query.editor.FilterContextMenuProvider;
import bpm.sqldesigner.query.editor.LinkContextMenuProvider;
import bpm.sqldesigner.query.editor.NullContextMenuProvider;
import bpm.sqldesigner.query.editor.SQLRootPart;
import bpm.sqldesigner.query.model.Column;
import bpm.sqldesigner.query.model.connection.JoinConnection;
import bpm.sqldesigner.query.part.AppEditPartFactory;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;

public class SQLEditor
extends ScrollingGraphicalViewer {
    private ZoomManager zoomManager;
    private FilterContextMenuProvider filterMenu;
    private LinkContextMenuProvider linkMenu;

    public SQLEditor(Composite editorC, EditDomain editDomain) {
        this.createControl(editorC);
        this.getControl().setBackground(ColorConstants.listBackground);
        this.getControl().setLayoutData((Object)new GridData(1808));
        this.setEditPartFactory(new AppEditPartFactory());
        SQLRootPart rootEditPart = new SQLRootPart();
        this.setRootEditPart((RootEditPart)rootEditPart);
        this.zoomManager = rootEditPart.getZoomManager();
        double[] zoomLevels = new double[]{0.25, 0.5, 0.75, 1.0, 1.5, 2.0, 2.5, 3.0, 4.0, 5.0, 10.0, 20.0};
        this.zoomManager.setZoomLevels(zoomLevels);
        ArrayList<String> zoomContributions = new ArrayList<String>();
        zoomContributions.add(ZoomManager.FIT_ALL);
        zoomContributions.add(ZoomManager.FIT_HEIGHT);
        zoomContributions.add(ZoomManager.FIT_WIDTH);
        this.zoomManager.setZoomLevelContributions(zoomContributions);
        this.filterMenu = new FilterContextMenuProvider((EditPartViewer)this);
        this.linkMenu = new LinkContextMenuProvider((EditPartViewer)this);
        this.setContextMenu((MenuManager)new NullContextMenuProvider((EditPartViewer)this));
        this.addSelectionChangedListener(new SelectionChangedListener());
    }

    public ZoomManager getZoomManager() {
        return this.zoomManager;
    }

    private SQLEditor getViewer() {
        return this;
    }

    protected class SelectionChangedListener
    implements ISelectionChangedListener {
        protected SelectionChangedListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            List selected = SQLEditor.this.getSelectedEditParts();
            if (selected.size() == 1) {
                EditPart e = (EditPart)selected.iterator().next();
                if (e.getModel() instanceof Column) {
                    SQLEditor.this.setContextMenu((MenuManager)SQLEditor.this.filterMenu);
                } else if (e.getModel() instanceof JoinConnection) {
                    SQLEditor.this.setContextMenu((MenuManager)SQLEditor.this.linkMenu);
                } else {
                    SQLEditor.this.setContextMenu((MenuManager)new NullContextMenuProvider((EditPartViewer)SQLEditor.this.getViewer()));
                }
            }
        }
    }
}

