/*
 * Decompiled with CFR 0.152.
 */
package bpm.sqldesigner.query.commands.creation;

import bpm.sqldesigner.query.model.Column;
import bpm.sqldesigner.query.model.Node;
import bpm.sqldesigner.query.model.Schema;
import bpm.sqldesigner.query.model.Table;
import bpm.sqldesigner.query.model.selected.SelectedColumnsManager;
import bpm.sqldesigner.query.palette.SQLDesignerPalette;
import java.util.Iterator;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.commands.Command;

public class TableCreateCommand
extends Command {
    private Schema schema = null;
    private Table table = null;
    private SQLDesignerPalette palette;

    public void setTable(Object t, SQLDesignerPalette palette) {
        if (t instanceof Table) {
            this.table = (Table)t;
        }
        this.palette = palette;
    }

    public void setSchema(Object s) {
        if (s instanceof Schema) {
            this.schema = (Schema)s;
        }
    }

    public void setLayout(Rectangle r) {
        if (this.table == null) {
            return;
        }
        this.table.setLayout(r);
    }

    public boolean canExecute() {
        return this.table != null && this.schema != null;
    }

    public void execute() {
        if (this.table.getChildren().size() == 0) {
            this.palette.loadColumns(this.table);
        }
        this.schema.addChild(this.table);
        this.table.canBeCreated(false);
    }

    public boolean canUndo() {
        if (this.schema == null || this.table == null) {
            return false;
        }
        return this.schema.contains(this.table);
    }

    public void undo() {
        this.table.canBeCreated(true);
        Iterator<Node> itC = this.table.getChildren().iterator();
        while (itC.hasNext()) {
            SelectedColumnsManager.getInstance().removeColumn((Column)itC.next());
        }
        this.schema.removeChild(this.table);
        this.table.fireRemoveOrAdd();
    }
}

