/*
 * Decompiled with CFR 0.152.
 */
package bpm.sqldesigner.query.commands;

import bpm.sqldesigner.query.model.Column;
import bpm.sqldesigner.query.model.Node;
import bpm.sqldesigner.query.model.Table;
import bpm.sqldesigner.query.model.connection.ConnectionsManager;
import bpm.sqldesigner.query.model.connection.JoinConnection;
import bpm.sqldesigner.query.model.filter.ColumnFiltersManager;
import bpm.sqldesigner.query.model.selected.SelectedColumnsManager;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.gef.commands.Command;

public class TableDeleteCommand
extends Command {
    private Node model;
    private Node parentModel;
    private List<JoinConnection> links;
    private List<Column> selectedColumns;

    public void execute() {
        Table table = (Table)this.model;
        table.canBeCreated(true);
        List<Node> columns = table.getChildren();
        Iterator<Node> it = columns.iterator();
        this.links = new ArrayList<JoinConnection>();
        this.selectedColumns = new ArrayList<Column>();
        while (it.hasNext()) {
            Column c = (Column)it.next();
            ColumnFiltersManager.getInstance().removeForColumn(c);
            ArrayList<JoinConnection> currenLinks = new ArrayList<JoinConnection>();
            currenLinks.addAll(c.getSourceConnections());
            currenLinks.addAll(c.getTargetConnections());
            for (JoinConnection j : currenLinks) {
                j.disconnect();
                ConnectionsManager.getInstance().removeConnection(j);
            }
            this.links.addAll(currenLinks);
            ArrayList<Column> toRemove = new ArrayList<Column>();
            for (Column col : SelectedColumnsManager.getInstance().getColumns()) {
                if (!col.getName().equals(c.getName()) || !col.getParent().getName().equals(c.getParent().getName())) continue;
                toRemove.add(c);
            }
            for (Column col : toRemove) {
                SelectedColumnsManager.getInstance().removeColumn(col);
                this.selectedColumns.add(col);
            }
            if (!SelectedColumnsManager.getInstance().contains(c)) continue;
            SelectedColumnsManager.getInstance().removeColumn(c);
            this.selectedColumns.add(c);
        }
        this.model.fireRemoveOrAdd();
        this.parentModel.removeChild(this.model);
    }

    public void setModel(Object model) {
        this.model = (Node)model;
    }

    public void setParentModel(Object model) {
        this.parentModel = (Node)model;
    }

    public void undo() {
        Iterator<Column> itC = this.selectedColumns.iterator();
        while (itC.hasNext()) {
            itC.next().setSelected(true);
        }
        this.parentModel.addChild(this.model);
        ((Table)this.model).canBeCreated(false);
        for (JoinConnection j : this.links) {
            j.reconnect();
            ConnectionsManager.getInstance().addConnection(j);
        }
        SelectedColumnsManager.getInstance().addAllColumns(this.selectedColumns);
        this.model.fireRemoveOrAdd();
    }
}

