/*
 * Decompiled with CFR 0.152.
 */
package bpm.sqldesigner.query.commands;

import bpm.sqldesigner.query.commands.AbstractLayoutCommand;
import bpm.sqldesigner.query.model.Column;
import bpm.sqldesigner.query.model.Node;
import bpm.sqldesigner.query.model.Table;
import bpm.sqldesigner.query.model.connection.JoinConnection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.geometry.Rectangle;

public class TableChangeLayoutCommand
extends AbstractLayoutCommand {
    private Table model;
    private Rectangle layout;
    private Rectangle oldLayout;

    public void execute() {
        Rectangle oldLayout = this.model.getLayout();
        if (oldLayout.height == this.layout.height && oldLayout.width == this.layout.width) {
            this.model.setLayout(this.layout);
            List<Node> columns = this.model.getChildren();
            for (Column column : columns) {
                ArrayList<JoinConnection> l = new ArrayList<JoinConnection>();
                l.addAll(column.getSourceConnections());
                l.addAll(column.getTargetConnections());
                Iterator it2 = l.iterator();
                while (it2.hasNext()) {
                    ((JoinConnection)it2.next()).getListeners().firePropertyChange("Nodelinks", null, null);
                }
            }
        }
    }

    @Override
    public void setConstraint(Rectangle rect) {
        this.layout = rect;
    }

    @Override
    public void setModel(Object model) {
        this.model = (Table)model;
        this.oldLayout = ((Table)model).getLayout();
    }

    public void undo() {
        this.model.setLayout(this.oldLayout);
    }
}

