/*
 * Decompiled with CFR 0.152.
 */
package bpm.sqldesigner.query;

import bpm.gateway.core.DocumentGateway;
import bpm.gateway.core.exception.ServerException;
import bpm.gateway.core.server.database.DataBaseConnection;
import bpm.sqldesigner.query.Activator;
import bpm.sqldesigner.query.editor.SQLEditor;
import bpm.sqldesigner.query.editor.SQLRootPart;
import bpm.sqldesigner.query.editor.filter.FiltersComposite;
import bpm.sqldesigner.query.editor.filter.FiltersManagerComposite;
import bpm.sqldesigner.query.listener.DeleteListener;
import bpm.sqldesigner.query.model.Column;
import bpm.sqldesigner.query.model.Schema;
import bpm.sqldesigner.query.model.connection.ConnectionsManager;
import bpm.sqldesigner.query.model.filter.ColumnFilter;
import bpm.sqldesigner.query.model.filter.ColumnFiltersManager;
import bpm.sqldesigner.query.model.selected.SelectedColumnsManager;
import bpm.sqldesigner.query.output.SqlOutput;
import bpm.sqldesigner.query.output.SqlOutputManager;
import bpm.sqldesigner.query.palette.SQLDesignerPalette;
import bpm.sqldesigner.query.services.AbstractDatabaseService;
import bpm.sqldesigner.query.services.FactoryDatabaseService;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.parts.ScrollableThumbnail;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.ui.palette.PaletteViewer;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class SQLDesignerComposite
extends Composite {
    private EditDomain editDomain = new EditDomain();
    private SQLDesignerPalette palette;
    private SqlOutput textSQL;
    private SQLEditor viewer;
    private ToolBar toolbar;
    private DataBaseConnection dbc;
    private Composite paletteC;
    private Composite mainC;
    private FiltersComposite filterC;
    private Label imageTestQuery;
    private Composite editorC;
    private boolean filterCompositeEnabled = false;
    private FiltersManagerComposite filtersManagerC;
    private Group groupFilters;
    private Group groupFiltersManager;
    private Schema schema = null;
    private Button activateFilter;
    private Text tableNameFilter;
    private DocumentGateway document;

    public SQLDesignerComposite(Composite parent, int style, DataBaseConnection dbc, List<ColumnFilter> predefinedFilters, DocumentGateway document) {
        super(parent, 0);
        this.dbc = dbc;
        this.document = document;
        this.initAll(predefinedFilters);
    }

    public SQLDesignerComposite(Composite parent, int style, Schema schema, List<ColumnFilter> predefinedFilters) {
        super(parent, 0);
        this.schema = schema;
        this.initAll(predefinedFilters);
    }

    public SQLDesignerPalette getPalette() {
        return this.palette;
    }

    public void initAll(List<ColumnFilter> predefinedFilters) {
        ColumnFiltersManager.getInstance().setPredefinedFilters(predefinedFilters);
        this.setLayout((Layout)new GridLayout(1, false));
        this.setLayoutData(new GridData(4, 4, true, true));
        SashForm sf = new SashForm((Composite)this, 256);
        sf.setLayoutData((Object)new GridData(1808));
        this.paletteC = new Composite((Composite)sf, 2048);
        this.paletteC.setLayout((Layout)new GridLayout(1, true));
        this.paletteC.setLayoutData((Object)new GridData(1, 4, false, true, 1, 1));
        this.mainC = new Composite((Composite)sf, 2048);
        this.mainC.setLayout((Layout)new GridLayout(1, false));
        this.mainC.setLayoutData((Object)new GridData(1808));
        this.initToolBar();
        this.initEditor();
        this.initFilters();
        this.initPalette();
        this.initThumbnail();
        this.initZoom();
        this.initFilterButton();
        this.editDomain.setPaletteViewer((PaletteViewer)this.palette);
        this.editDomain.setPaletteRoot(this.palette.getPaletteRoot());
        this.initSQLOutput();
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                SQLDesignerComposite.this.dispose();
            }
        });
        sf.setWeights(new int[]{1, 4});
    }

    private void initFilters() {
        Composite main = new Composite(this.paletteC, 0);
        main.setLayout((Layout)new GridLayout(2, false));
        main.setLayoutData((Object)new GridData(4, 2, true, false));
        this.activateFilter = new Button(main, 32);
        this.activateFilter.setLayoutData((Object)new GridData(4, 2, true, false, 2, 1));
        this.activateFilter.setText("Filter on Table Name");
        this.activateFilter.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SQLDesignerComposite.this.tableNameFilter.setEnabled(SQLDesignerComposite.this.activateFilter.getSelection());
            }
        });
        Label l = new Label(main, 0);
        l.setLayoutData((Object)new GridData(1, 2, false, false));
        l.setText("Table Name");
        this.tableNameFilter = new Text(main, 2048);
        this.tableNameFilter.setLayoutData((Object)new GridData(4, 2, true, false));
        this.tableNameFilter.setEnabled(false);
        this.tableNameFilter.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SQLDesignerComposite.this.palette.filterOnName(SQLDesignerComposite.this.tableNameFilter.getText());
            }
        });
    }

    private void initFilterButton() {
        Listener filtersManagerListener = new Listener(){

            public void handleEvent(Event event) {
                if (!SQLDesignerComposite.this.filterCompositeEnabled) {
                    SQLDesignerComposite.this.initFiltersManager();
                    SQLDesignerComposite.this.filtersManagerC.getParent().getParent().layout();
                }
            }
        };
        new ToolItem(this.toolbar, 2);
        ToolItem toolItem4 = new ToolItem(this.toolbar, 0);
        toolItem4.setImage(Activator.getDefault().getImageRegistry().get("filter"));
        toolItem4.setToolTipText("Filters Manager");
        toolItem4.addListener(13, filtersManagerListener);
    }

    protected void initSQLOutput() {
        Composite sqlOutputC = new Composite((Composite)this, 0);
        sqlOutputC.setLayout((Layout)new GridLayout(3, false));
        sqlOutputC.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.textSQL = SqlOutputManager.getInstance(sqlOutputC, 2626);
        this.textSQL.setLayoutData(new GridData(1808));
        Button testButton = new Button(sqlOutputC, 8);
        testButton.setText("Test Query");
        if (this.schema == null) {
            testButton.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    AbstractDatabaseService dS = FactoryDatabaseService.getDataBaseService(SQLDesignerComposite.this.dbc);
                    try {
                        dS.connect(SQLDesignerComposite.this.document);
                    }
                    catch (ServerException e) {
                        e.printStackTrace();
                    }
                    boolean b = dS.testQuery(SQLDesignerComposite.this.textSQL.getText());
                    dS.disconnect();
                    SQLDesignerComposite.this.setValidQuery(b);
                }
            });
        } else {
            testButton.setEnabled(false);
        }
        this.imageTestQuery = new Label(sqlOutputC, 0);
        this.imageTestQuery.setImage(Activator.getDefault().getImageRegistry().get("valid"));
        this.imageTestQuery.setVisible(false);
    }

    protected void setValidQuery(boolean b) {
        if (b) {
            this.imageTestQuery.setImage(Activator.getDefault().getImageRegistry().get("valid"));
            this.imageTestQuery.setVisible(true);
        } else {
            this.imageTestQuery.setImage(Activator.getDefault().getImageRegistry().get("invalid"));
            this.imageTestQuery.setVisible(true);
        }
        this.imageTestQuery.redraw();
    }

    public void setImageTestQueryVisible(boolean b) {
        this.imageTestQuery.setVisible(b);
    }

    protected void initEditor() {
        this.editorC = new Composite(this.mainC, 0);
        this.editorC.setLayout((Layout)new GridLayout(1, false));
        this.editorC.setLayoutData((Object)new GridData(1808));
        this.viewer = new SQLEditor(this.editorC, this.editDomain);
        this.viewer.setEditDomain(this.editDomain);
        this.editDomain.addViewer((EditPartViewer)this.viewer);
        Schema model = new Schema();
        this.viewer.setContents(model);
    }

    protected void initToolBar() {
        this.toolbar = new ToolBar(this.mainC, 0x800000);
        this.toolbar.setBounds(0, 0, 200, 70);
        Listener undoListener = new Listener(){

            public void handleEvent(Event event) {
                SQLDesignerComposite.this.editDomain.getCommandStack().undo();
            }
        };
        Listener redoListener = new Listener(){

            public void handleEvent(Event event) {
                SQLDesignerComposite.this.editDomain.getCommandStack().redo();
            }
        };
        DeleteListener deleteListener = new DeleteListener(this);
        ToolItem toolItem1 = new ToolItem(this.toolbar, 0);
        toolItem1.setImage(Activator.getDefault().getImageRegistry().get("undo"));
        toolItem1.setToolTipText("Undo");
        toolItem1.addListener(13, undoListener);
        ToolItem toolItem2 = new ToolItem(this.toolbar, 0);
        toolItem2.setImage(Activator.getDefault().getImageRegistry().get("redo"));
        toolItem2.setToolTipText("Redo");
        toolItem2.addListener(13, redoListener);
        ToolItem toolItem3 = new ToolItem(this.toolbar, 0);
        toolItem3.setImage(Activator.getDefault().getImageRegistry().get("delete"));
        toolItem3.setToolTipText("Delete");
        toolItem3.addListener(13, (Listener)deleteListener);
    }

    public void initFilter() {
        this.groupFilters = new Group(this.mainC, 16);
        this.groupFilters.setLayout((Layout)new GridLayout(1, false));
        this.groupFilters.setLayoutData((Object)new GridData(768));
        this.filterC = new FiltersComposite((Composite)this.groupFilters, 0, this);
        this.filterC.setLayout((Layout)new GridLayout(5, false));
        this.filterC.setLayoutData(new GridData(768));
        this.filterC.setVisible(false);
        this.filterC.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                SQLDesignerComposite.this.groupFilters.dispose();
                SQLDesignerComposite.this.filterCompositeEnabled = false;
            }
        });
    }

    public void initFiltersManager() {
        if (!this.filterCompositeEnabled) {
            this.groupFiltersManager = new Group(this.mainC, 16);
            this.groupFiltersManager.setLayout((Layout)new GridLayout(1, false));
            this.groupFiltersManager.setLayoutData((Object)new GridData(768));
            this.groupFiltersManager.setText("Filters Manager");
            this.filterCompositeEnabled = true;
            this.filtersManagerC = new FiltersManagerComposite((Composite)this.groupFiltersManager, 0, this);
            this.filtersManagerC.setLayout((Layout)new GridLayout(1, false));
            this.filtersManagerC.setLayoutData(new GridData(768));
            this.filtersManagerC.setVisible(true);
            this.filtersManagerC.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    SQLDesignerComposite.this.filterCompositeEnabled = false;
                    SQLDesignerComposite.this.groupFiltersManager.dispose();
                }
            });
        }
    }

    protected void initZoom() {
        Listener zoomInListener = new Listener(){

            public void handleEvent(Event event) {
                ZoomManager zm = SQLDesignerComposite.this.viewer.getZoomManager();
                if (zm.canZoomIn()) {
                    zm.zoomIn();
                }
            }
        };
        Listener zoomOutListener = new Listener(){

            public void handleEvent(Event event) {
                ZoomManager zm = SQLDesignerComposite.this.viewer.getZoomManager();
                if (zm.canZoomOut()) {
                    zm.zoomOut();
                }
            }
        };
        new ToolItem(this.toolbar, 2);
        ToolItem zoomIn = new ToolItem(this.toolbar, 0);
        zoomIn.setImage(Activator.getDefault().getImageRegistry().get("zoomIn"));
        zoomIn.setToolTipText("Zoom In");
        zoomIn.addListener(13, zoomInListener);
        ToolItem zoomOut = new ToolItem(this.toolbar, 0);
        zoomOut.setImage(Activator.getDefault().getImageRegistry().get("zoomOut"));
        zoomOut.setToolTipText("Zoom Out");
        zoomOut.addListener(13, zoomOutListener);
    }

    protected void initPalette() {
        CLabel l = new CLabel(this.paletteC, 0);
        l.setText("Design");
        l.setLayoutData((Object)new GridData(4, 2, true, false));
        l.setBackground(new Color[]{Display.getDefault().getSystemColor(32), Display.getDefault().getSystemColor(9), Display.getDefault().getSystemColor(32)}, new int[]{90, 100});
        this.palette = this.schema != null ? new SQLDesignerPalette(this.schema, this.document) : new SQLDesignerPalette(this.dbc, this.document);
        this.palette.createControl(this.paletteC);
        this.palette.getControl().setLayoutData((Object)new GridData(1808));
        this.setBackground(this.palette.getControl().getBackground());
    }

    protected void initThumbnail() {
        Canvas canvas = new Canvas(this.paletteC, 0);
        canvas.setLayoutData((Object)new GridData(4, 3, true, false));
        LightweightSystem lws = new LightweightSystem(canvas);
        ScrollableThumbnail thumbnail = new ScrollableThumbnail((Viewport)((SQLRootPart)this.viewer.getRootEditPart()).getFigure());
        thumbnail.setSource(((SQLRootPart)this.viewer.getRootEditPart()).getLayer("Printable Layers"));
        lws.setContents((IFigure)thumbnail);
    }

    public EditDomain getDomain() {
        return this.editDomain;
    }

    public SQLEditor getEditor() {
        return this.viewer;
    }

    public String getQuery() {
        return this.textSQL.getText().replace('\n', ' ');
    }

    public void dispose() {
        super.dispose();
        SqlOutputManager.dispose();
        ConnectionsManager.dispose();
        ColumnFiltersManager.dispose();
        SelectedColumnsManager.dispose();
    }

    public FiltersComposite addFilterComposite(Column model) {
        if (!this.filterCompositeEnabled) {
            this.initFilter();
            this.filterCompositeEnabled = true;
            this.filterC.openFilterComposite(model);
            this.filterC.getParent().getParent().layout();
            return this.filterC;
        }
        return null;
    }

    public void setGroupFiltersText(String text) {
        this.groupFilters.setText(text);
    }
}

