/*
 * Decompiled with CFR 0.152.
 */
package com.simba.googlebigquery.jdbc.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ParseQueryUtils {
    private static final Pattern s_patternWithDollarSign = Pattern.compile("(;)|(')|(\\\\)|(-)|(\")|(\\/)|(\\$)");
    private static final Pattern s_patternWithoutDollarSign = Pattern.compile("(;)|(')|(\\\\)|(-)|(\")|(\\/)");

    public static List<String> splitQueries(String string, boolean bl) {
        Matcher matcher;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (null == string || string.isEmpty()) {
            return arrayList;
        }
        Pattern pattern = bl ? s_patternWithDollarSign : s_patternWithoutDollarSign;
        if (';' == (string = string.trim()).charAt(string.length() - 1)) {
            string = string.substring(0, string.length() - 1);
        }
        if (!(matcher = pattern.matcher(string)).find()) {
            arrayList.add(string);
            return arrayList;
        }
        ArrayList<SubstringBounds> arrayList2 = new ArrayList<SubstringBounds>();
        boolean bl2 = false;
        boolean bl3 = false;
        int n = 0;
        int n2 = 0;
        block9: for (n2 = 0; n2 < string.length(); ++n2) {
            switch (string.charAt(n2)) {
                case ';': {
                    if (bl3 || bl2) continue block9;
                    arrayList2.add(new SubstringBounds(n, n2));
                    n = n2 + 1;
                    continue block9;
                }
                case '\"': {
                    if (bl2) continue block9;
                    bl3 = !bl3;
                    continue block9;
                }
                case '\'': {
                    if (bl3) continue block9;
                    bl2 = !bl2;
                    continue block9;
                }
                case '\\': {
                    ++n2;
                    continue block9;
                }
                case '-': {
                    if (bl3 || bl2 || string.charAt(n2 + 1) != '-') continue block9;
                    int n3 = string.indexOf(10, n2 + 2);
                    if (-1 == n3) {
                        n2 = string.length();
                        continue block9;
                    }
                    n2 = n3;
                    continue block9;
                }
                case '/': {
                    int n3;
                    if (bl3 || bl2 || string.charAt(n2 + 1) != '*' || -1 == (n3 = string.indexOf("*/", n2 + 2))) continue block9;
                    n2 = n3 + 1;
                    continue block9;
                }
                case '$': {
                    int n3;
                    if (bl3 || bl2 || !bl) continue block9;
                    if (n2 + 1 < string.length() && string.charAt(n2 + 1) == '$') {
                        n3 = string.indexOf("$$", n2 + 2);
                        if (n3 < 0) {
                            n2 = string.length();
                            continue block9;
                        }
                        n2 = n3 + 1;
                        continue block9;
                    }
                    n3 = string.indexOf("$", n2 + 1);
                    if (n3 < 0) {
                        n2 = string.length();
                        continue block9;
                    }
                    if (n3 + 1 >= string.length()) continue block9;
                    String object = string.substring(n2, n3 + 1);
                    int n4 = string.indexOf(object, n3 + 1);
                    n2 = n4 < 0 ? string.length() : n4 + object.length() - 1;
                }
            }
        }
        if (n != string.length()) {
            arrayList2.add(new SubstringBounds(n, string.length()));
        }
        for (SubstringBounds substringBounds : arrayList2) {
            String string2 = string.substring(substringBounds.m_begin, substringBounds.m_end);
            if (string2.trim().isEmpty()) continue;
            arrayList.add(string2);
        }
        return arrayList;
    }

    public static List<String> splitQueries(String string) {
        return ParseQueryUtils.splitQueries(string, false);
    }

    @Deprecated
    public static String removeComments(String string) {
        String string2 = string;
        if (string.contains("/*")) {
            StringBuilder stringBuilder = new StringBuilder();
            int n = string.indexOf("/*");
            int n2 = string.indexOf("*/");
            stringBuilder.append(string.substring(0, n));
            if (-1 != n2) {
                stringBuilder.append(string.substring(n2, string.length()));
            }
            string2 = stringBuilder.toString().trim();
        } else if (string.contains("--")) {
            StringBuilder stringBuilder = new StringBuilder();
            int n = string.indexOf("--");
            int n3 = string.indexOf("\n");
            stringBuilder.append(string.substring(0, n));
            if (-1 != n3) {
                stringBuilder.append(string.substring(n3 + 1, string.length()));
            }
            string2 = stringBuilder.toString().trim();
        } else if (string.contains("#")) {
            StringBuilder stringBuilder = new StringBuilder();
            int n = string.indexOf("#");
            int n4 = string.indexOf("\n");
            stringBuilder.append(string.substring(0, n));
            if (-1 != n4) {
                stringBuilder.append(string.substring(n4 + 1, string.length()));
            }
            string2 = stringBuilder.toString().trim();
        }
        return string2;
    }

    public static String parseCommentsOnSingleQuery(String string) {
        return ParseQueryUtils.parseCommentsOnSingleQuery(string, false);
    }

    public static String parseCommentsOnSingleQuery(String string, boolean bl) {
        HashMap<Character, Character> hashMap = new HashMap<Character, Character>();
        hashMap.put(Character.valueOf('\''), Character.valueOf('\''));
        hashMap.put(Character.valueOf('\"'), Character.valueOf('\"'));
        return ParseQueryUtils.parseCommentsOnSingleQuery(string, bl, hashMap);
    }

    public static String parseCommentsOnSingleQuery(String string, boolean bl, Map<Character, Character> map) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = string.length();
        block5: for (int i = 0; i < n; ++i) {
            int n2;
            char c = string.charAt(i);
            if (map.containsKey(Character.valueOf(c))) {
                n2 = string.indexOf(map.get(Character.valueOf(c)).charValue(), i + 1);
                if (i < n2) {
                    stringBuilder.append(string, i, n2 + 1);
                    i = n2;
                    continue;
                }
                stringBuilder.append(string, i, string.length());
                return stringBuilder.toString();
            }
            switch (c) {
                case '/': {
                    if (i + 1 < n && '*' == string.charAt(i + 1)) {
                        n2 = string.indexOf("*/", i);
                        if (n2 <= 0) {
                            return string;
                        }
                        if (bl && ParseQueryUtils.containsValidHint(string.substring(i + 2, n2))) {
                            return string;
                        }
                        i = n2 + 1;
                        continue block5;
                    }
                    stringBuilder.append(c);
                    continue block5;
                }
                case '-': {
                    if (i + 1 < n && '-' == string.charAt(i + 1)) {
                        n2 = string.indexOf("\n", i);
                        if (n2 == -1) {
                            i = n;
                            continue block5;
                        }
                        if (bl && ParseQueryUtils.containsValidHint(string.substring(i + 2, n2))) {
                            return string;
                        }
                        i = n2;
                        continue block5;
                    }
                    stringBuilder.append(c);
                    continue block5;
                }
                case '#': {
                    n2 = string.indexOf("\n", i);
                    if (n2 == -1) {
                        i = n;
                        continue block5;
                    }
                    i = n2;
                    continue block5;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
        }
        return stringBuilder.toString();
    }

    private static boolean containsValidHint(String string) {
        return string.matches("^\\s*\\+[\\s\\S]*");
    }

    public static String escapeString(String string, String string2) {
        if (null == string) {
            return null;
        }
        if (string.isEmpty()) {
            return string;
        }
        return string.replace(string2, string2 + string2);
    }

    public static String escapeSingleQuoteAndBackSlash(String string) {
        return ParseQueryUtils.escapeString(ParseQueryUtils.escapeString(string, "'"), "\\");
    }

    public static String stripSemiColons(String string) {
        int n = string.length();
        int n2 = string.length() - 1;
        while (n2 >= 0 && (string.charAt(n2) == ';' || Character.isWhitespace(string.charAt(n2)))) {
            n = n2--;
        }
        return string.substring(0, n);
    }

    private static class SubstringBounds {
        public final int m_begin;
        public final int m_end;

        public SubstringBounds(int n, int n2) {
            this.m_begin = n;
            this.m_end = n2;
        }
    }
}

