/*
 * Decompiled with CFR 0.152.
 */
package com.simba.googlebigquery.jdbc.common;

import com.simba.googlebigquery.exceptions.ExceptionConverter;
import com.simba.googlebigquery.exceptions.JDBCMessageKey;
import com.simba.googlebigquery.support.ILogger;
import com.simba.googlebigquery.support.IWarningListener;
import com.simba.googlebigquery.support.LogUtilities;
import com.simba.googlebigquery.support.exceptions.ExceptionType;
import java.sql.SQLException;
import java.sql.Savepoint;

public class SSavepoint
implements Savepoint {
    private int m_id = 0;
    private String m_name = null;
    private ILogger m_logger = null;
    private IWarningListener m_warningListener = null;

    protected SSavepoint(int n, ILogger iLogger, IWarningListener iWarningListener) {
        this.m_logger = iLogger;
        LogUtilities.logFunctionEntrance(this.m_logger, n, iLogger);
        this.m_warningListener = iWarningListener;
        this.m_id = n;
    }

    protected SSavepoint(String string, ILogger iLogger, IWarningListener iWarningListener) {
        this.m_logger = iLogger;
        LogUtilities.logFunctionEntrance(this.m_logger, string, iLogger);
        this.m_warningListener = iWarningListener;
        this.m_name = string;
    }

    @Override
    public int getSavepointId() throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (null != this.m_name) {
            SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.SAVEPOINT_ID_FROM_NAMED, this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
            LogUtilities.logError(sQLException, this.m_logger);
            throw sQLException;
        }
        return this.m_id;
    }

    @Override
    public String getSavepointName() throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (null == this.m_name) {
            SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.SAVEPOINT_ID_FROM_NAMED, this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
            LogUtilities.logError(sQLException, this.m_logger);
            throw sQLException;
        }
        return this.m_name;
    }

    boolean isNamed() {
        return null != this.m_name;
    }
}

