/*
 * Decompiled with CFR 0.152.
 */
package com.simba.googlebigquery.googlebigquery.tests.unit;

import com.google.api.services.bigquery.model.DatasetReference;
import com.simba.googlebigquery.googlebigquery.client.metadata.BQMetadataResult;
import com.simba.googlebigquery.googlebigquery.client.metadata.BQThreadPoolExecutor;
import com.simba.googlebigquery.googlebigquery.dataengine.metadata.BQColumnMetadata;
import com.simba.googlebigquery.googlebigquery.dataengine.metadata.BQFunction;
import com.simba.googlebigquery.googlebigquery.dataengine.metadata.BQFunctionColumn;
import com.simba.googlebigquery.googlebigquery.dataengine.metadata.BQTable;
import com.simba.googlebigquery.support.exceptions.ErrorException;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import junit.framework.TestCase;
import org.junit.Test;

public class BQThreadPoolExecutorTests
extends TestCase {
    BQThreadPoolExecutor m_threadpool;

    public void setUp() throws ErrorException {
        this.m_threadpool = new BQThreadPoolExecutor(1024);
    }

    public void tearDown() {
        this.m_threadpool.shutdownNow();
    }

    @Test
    public void testValidSubmit() throws ErrorException {
        this.m_threadpool.submit(new ProjectTask());
        BQThreadPoolExecutorTests.assertEquals((int)1, (int)this.m_threadpool.getTaskCount());
    }

    @Test
    public void testMultipleSubmit() throws ErrorException {
        for (int i = 1; i <= 10; ++i) {
            this.m_threadpool.submit(new ProjectTask());
            BQThreadPoolExecutorTests.assertEquals((int)i, (int)this.m_threadpool.getTaskCount());
        }
    }

    @Test
    public void testExecuteProject() throws ErrorException, ExecutionException, InterruptedException {
        this.m_threadpool.submit(new ProjectTask());
        BQMetadataResult bQMetadataResult = this.m_threadpool.take();
        BQThreadPoolExecutorTests.assertTrue((null != bQMetadataResult ? 1 : 0) != 0);
        BQThreadPoolExecutorTests.assertTrue((!bQMetadataResult.isEmpty() ? 1 : 0) != 0);
        BQThreadPoolExecutorTests.assertEquals((int)1, (int)bQMetadataResult.getProjects().size());
    }

    @Test
    public void testExecuteDataset() throws ErrorException, ExecutionException, InterruptedException {
        this.m_threadpool.submit(new DatasetTask());
        BQMetadataResult bQMetadataResult = this.m_threadpool.take();
        BQThreadPoolExecutorTests.assertTrue((null != bQMetadataResult ? 1 : 0) != 0);
        BQThreadPoolExecutorTests.assertTrue((!bQMetadataResult.isEmpty() ? 1 : 0) != 0);
        BQThreadPoolExecutorTests.assertEquals((int)1, (int)bQMetadataResult.getDatasets().size());
    }

    @Test
    public void testExecuteColumns() throws ErrorException, ExecutionException, InterruptedException {
        this.m_threadpool.submit(new ColumnTask());
        BQMetadataResult bQMetadataResult = this.m_threadpool.take();
        BQThreadPoolExecutorTests.assertTrue((null != bQMetadataResult ? 1 : 0) != 0);
        BQThreadPoolExecutorTests.assertTrue((!bQMetadataResult.isEmpty() ? 1 : 0) != 0);
        BQThreadPoolExecutorTests.assertEquals((int)1, (int)bQMetadataResult.getColumns().size());
    }

    @Test
    public void testExecuteFunctions() throws ErrorException, ExecutionException, InterruptedException {
        this.m_threadpool.submit(new FunctionTask());
        BQMetadataResult bQMetadataResult = this.m_threadpool.take();
        BQThreadPoolExecutorTests.assertTrue((null != bQMetadataResult ? 1 : 0) != 0);
        BQThreadPoolExecutorTests.assertTrue((!bQMetadataResult.isEmpty() ? 1 : 0) != 0);
        BQThreadPoolExecutorTests.assertEquals((int)1, (int)bQMetadataResult.getFunctions().size());
    }

    @Test
    public void testExecuteFunctionColumns() throws ErrorException, ExecutionException, InterruptedException {
        this.m_threadpool.submit(new FunctionColumnsTask());
        BQMetadataResult bQMetadataResult = this.m_threadpool.take();
        BQThreadPoolExecutorTests.assertTrue((null != bQMetadataResult ? 1 : 0) != 0);
        BQThreadPoolExecutorTests.assertTrue((!bQMetadataResult.isEmpty() ? 1 : 0) != 0);
        BQThreadPoolExecutorTests.assertEquals((int)1, (int)bQMetadataResult.getFunctionColumns().size());
    }

    @Test
    public void testAllTasksExecution() throws ErrorException, ExecutionException, InterruptedException {
        this.m_threadpool.submit(new ProjectTask());
        this.m_threadpool.submit(new DatasetTask());
        this.m_threadpool.submit(new TableTask());
        this.m_threadpool.submit(new ColumnTask());
        this.m_threadpool.submit(new FunctionTask());
        this.m_threadpool.submit(new FunctionColumnsTask());
        for (int i = 1; i <= 6; ++i) {
            BQMetadataResult bQMetadataResult = this.m_threadpool.take();
            BQThreadPoolExecutorTests.assertTrue((null != bQMetadataResult ? 1 : 0) != 0);
            BQThreadPoolExecutorTests.assertTrue((!bQMetadataResult.isEmpty() ? 1 : 0) != 0);
        }
    }

    @Test
    public void testManyExecutions() throws ErrorException, ExecutionException, InterruptedException {
        int n;
        for (n = 1; n <= 10000; ++n) {
            this.m_threadpool.submit(new ProjectTask());
        }
        for (n = 1; n <= 10000; ++n) {
            BQMetadataResult bQMetadataResult = this.m_threadpool.take();
            BQThreadPoolExecutorTests.assertTrue((null != bQMetadataResult ? 1 : 0) != 0);
            BQThreadPoolExecutorTests.assertTrue((!bQMetadataResult.isEmpty() ? 1 : 0) != 0);
        }
    }

    @Test
    public void testMerge() throws ErrorException, ExecutionException, InterruptedException {
        this.m_threadpool.submit(new ProjectTask());
        this.m_threadpool.submit(new ProjectTask());
        BQMetadataResult bQMetadataResult = this.m_threadpool.take();
        BQMetadataResult bQMetadataResult2 = this.m_threadpool.take();
        bQMetadataResult.merge(bQMetadataResult2);
        BQThreadPoolExecutorTests.assertEquals((int)2, (int)bQMetadataResult.getProjects().size());
    }

    @Test
    public void testAllTasksMerge() throws ErrorException, ExecutionException, InterruptedException {
        this.m_threadpool.submit(new ProjectTask());
        this.m_threadpool.submit(new DatasetTask());
        this.m_threadpool.submit(new TableTask());
        this.m_threadpool.submit(new ColumnTask());
        this.m_threadpool.submit(new FunctionTask());
        this.m_threadpool.submit(new FunctionColumnsTask());
        BQMetadataResult bQMetadataResult = new BQMetadataResult();
        for (int i = 0; i < 6; ++i) {
            bQMetadataResult.merge(this.m_threadpool.take());
        }
        BQThreadPoolExecutorTests.assertEquals((int)1, (int)bQMetadataResult.getColumns().size());
        BQThreadPoolExecutorTests.assertEquals((int)1, (int)bQMetadataResult.getDatasets().size());
        BQThreadPoolExecutorTests.assertEquals((int)1, (int)bQMetadataResult.getFunctionColumns().size());
        BQThreadPoolExecutorTests.assertEquals((int)1, (int)bQMetadataResult.getFunctions().size());
        BQThreadPoolExecutorTests.assertEquals((int)1, (int)bQMetadataResult.getProjects().size());
        BQThreadPoolExecutorTests.assertEquals((int)1, (int)bQMetadataResult.getTables().size());
    }

    private class FunctionColumnsTask
    implements Callable<BQMetadataResult> {
        private FunctionColumnsTask() {
        }

        @Override
        public BQMetadataResult call() throws Exception {
            Thread.sleep((long)(Math.random() * 1000.0));
            ArrayList<BQFunctionColumn> arrayList = new ArrayList<BQFunctionColumn>();
            arrayList.add(null);
            BQMetadataResult bQMetadataResult = new BQMetadataResult();
            bQMetadataResult.addFunctionColumns(arrayList);
            return bQMetadataResult;
        }
    }

    private class FunctionTask
    implements Callable<BQMetadataResult> {
        private FunctionTask() {
        }

        @Override
        public BQMetadataResult call() throws Exception {
            Thread.sleep((long)(Math.random() * 1000.0));
            ArrayList<BQFunction> arrayList = new ArrayList<BQFunction>();
            arrayList.add(null);
            BQMetadataResult bQMetadataResult = new BQMetadataResult();
            bQMetadataResult.addFunctions(arrayList);
            return bQMetadataResult;
        }
    }

    private class ColumnTask
    implements Callable<BQMetadataResult> {
        private ColumnTask() {
        }

        @Override
        public BQMetadataResult call() throws Exception {
            Thread.sleep((long)(Math.random() * 1000.0));
            ArrayList<BQColumnMetadata> arrayList = new ArrayList<BQColumnMetadata>();
            arrayList.add(null);
            BQMetadataResult bQMetadataResult = new BQMetadataResult();
            bQMetadataResult.addColumns(arrayList);
            return bQMetadataResult;
        }
    }

    private class TableTask
    implements Callable<BQMetadataResult> {
        private TableTask() {
        }

        @Override
        public BQMetadataResult call() throws Exception {
            Thread.sleep((long)(Math.random() * 1000.0));
            ArrayList<BQTable> arrayList = new ArrayList<BQTable>();
            arrayList.add(null);
            BQMetadataResult bQMetadataResult = new BQMetadataResult();
            bQMetadataResult.addTables(arrayList);
            return bQMetadataResult;
        }
    }

    private class DatasetTask
    implements Callable<BQMetadataResult> {
        private DatasetTask() {
        }

        @Override
        public BQMetadataResult call() throws Exception {
            Thread.sleep((long)(Math.random() * 1000.0));
            ArrayList<DatasetReference> arrayList = new ArrayList<DatasetReference>();
            arrayList.add(null);
            BQMetadataResult bQMetadataResult = new BQMetadataResult();
            bQMetadataResult.addDatasets(arrayList);
            return bQMetadataResult;
        }
    }

    private class ProjectTask
    implements Callable<BQMetadataResult> {
        private ProjectTask() {
        }

        @Override
        public BQMetadataResult call() throws Exception {
            Thread.sleep((long)(Math.random() * 1000.0));
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(null);
            BQMetadataResult bQMetadataResult = new BQMetadataResult();
            bQMetadataResult.addProjects(arrayList);
            return bQMetadataResult;
        }
    }
}

