/*
 * Decompiled with CFR 0.152.
 */
package com.simba.googlebigquery.googlebigquery.dataengine.metadata;

import com.google.api.services.bigquery.model.Argument;
import com.google.api.services.bigquery.model.Routine;
import java.util.List;

public class BQFunction {
    private final String m_catalogName;
    private final String m_schemaName;
    private final String m_functionName;
    private final String m_routineDef;
    private short m_returnType = 0;
    private Routine m_routine;
    private List<Argument> m_argList;
    private boolean m_isFunction;

    public BQFunction(Routine routine, boolean bl) {
        this.m_routine = routine;
        this.m_catalogName = routine.getRoutineReference().getProjectId();
        this.m_schemaName = routine.getRoutineReference().getDatasetId();
        this.m_functionName = routine.getRoutineReference().getRoutineId();
        this.m_routineDef = routine.getDefinitionBody();
        this.m_argList = routine.getArguments();
        this.m_isFunction = bl;
    }

    public short getReturnType() {
        if (!this.m_isFunction && null != this.m_argList) {
            for (Argument argument : this.m_argList) {
                if (null == argument.getMode() || !argument.getMode().toLowerCase().contains("out")) continue;
                this.m_returnType = (short)2;
                return this.m_returnType;
            }
            this.m_returnType = 1;
        } else if (null != this.m_routineDef && this.m_routineDef.toLowerCase().contains("return")) {
            this.m_returnType = (short)2;
        }
        return this.m_returnType;
    }

    public String getRoutineDef() {
        return this.m_routineDef;
    }

    public String getCatalogName() {
        return this.m_catalogName;
    }

    public String getSchemaName() {
        return this.m_schemaName;
    }

    public String getFunctionName() {
        return this.m_functionName;
    }

    public Routine getRoutine() {
        return this.m_routine;
    }

    public List<Argument> getArguments() {
        return this.m_argList;
    }
}

