/*
 * Decompiled with CFR 0.152.
 */
package com.simba.googlebigquery.googlebigquery.dataengine.metadata;

import com.simba.googlebigquery.dsi.dataengine.filters.IFilter;
import com.simba.googlebigquery.dsi.dataengine.utilities.DSITypeUtilities;
import com.simba.googlebigquery.dsi.dataengine.utilities.DataWrapper;
import com.simba.googlebigquery.dsi.dataengine.utilities.MetadataSourceColumnTag;
import com.simba.googlebigquery.dsi.dataengine.utilities.TypeMetadata;
import com.simba.googlebigquery.dsi.dataengine.utilities.TypeUtilities;
import com.simba.googlebigquery.googlebigquery.core.BQConnection;
import com.simba.googlebigquery.googlebigquery.core.BQDriver;
import com.simba.googlebigquery.googlebigquery.dataengine.metadata.BQColumnMetadata;
import com.simba.googlebigquery.googlebigquery.dataengine.metadata.BQMetadataSource;
import com.simba.googlebigquery.googlebigquery.exceptions.BQMessageKey;
import com.simba.googlebigquery.support.ILogger;
import com.simba.googlebigquery.support.LogUtilities;
import com.simba.googlebigquery.support.exceptions.ErrorException;
import java.util.Map;

public class BQColumnsMetadataSource
extends BQMetadataSource {
    public BQColumnsMetadataSource(ILogger iLogger, BQConnection bQConnection, Map<MetadataSourceColumnTag, String> map) throws ErrorException {
        super(iLogger, bQConnection, map);
        LogUtilities.logFunctionEntrance(iLogger, iLogger);
        this.m_filters = new IFilter[4];
        if (null != this.m_restrictions.get((Object)MetadataSourceColumnTag.CATALOG_NAME) && null != this.m_restrictions.get((Object)MetadataSourceColumnTag.SCHEMA_NAME) && null != this.m_restrictions.get((Object)MetadataSourceColumnTag.TABLE_NAME)) {
            this.m_haveAllRestrictions = true;
        }
    }

    @Override
    public void close() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.closeCursor();
    }

    @Override
    public void closeCursor() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.m_hasStartedColumnsFetch = false;
    }

    @Override
    public boolean getMetadata(MetadataSourceColumnTag metadataSourceColumnTag, long l, long l2, DataWrapper dataWrapper) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[]{metadataSourceColumnTag, l, l2});
        if (null != this.m_cachedException) {
            throw this.m_cachedException;
        }
        BQColumnMetadata bQColumnMetadata = (BQColumnMetadata)this.m_columns.get(this.m_columnIdx);
        switch (metadataSourceColumnTag) {
            case CATALOG_NAME: {
                return DSITypeUtilities.outputVarCharStringData(bQColumnMetadata.getCatalogName(), dataWrapper, l, l2);
            }
            case SCHEMA_NAME: {
                return DSITypeUtilities.outputVarCharStringData(bQColumnMetadata.getSchemaName(), dataWrapper, l, l2);
            }
            case TABLE_NAME: {
                return DSITypeUtilities.outputVarCharStringData(bQColumnMetadata.getTableName(), dataWrapper, l, l2);
            }
            case COLUMN_NAME: {
                return DSITypeUtilities.outputVarCharStringData(bQColumnMetadata.getName(), dataWrapper, l, l2);
            }
            case DATA_TYPE: {
                short s = bQColumnMetadata.getTypeMetadata().getType();
                dataWrapper.setSmallInt(s);
                return false;
            }
            case DATA_TYPE_NAME: {
                return DSITypeUtilities.outputVarCharStringData(bQColumnMetadata.getTypeMetadata().getTypeName(), dataWrapper, l, l2);
            }
            case COLUMN_SIZE: {
                dataWrapper.setInteger((int)TypeUtilities.getColumnSize(bQColumnMetadata.getTypeMetadata(), bQColumnMetadata.getColumnLength()));
                return false;
            }
            case BUFFER_LENGTH: {
                dataWrapper.setInteger(bQColumnMetadata.getByteLength());
                return false;
            }
            case DECIMAL_DIGITS: {
                Long l3 = null;
                TypeMetadata typeMetadata = bQColumnMetadata.getTypeMetadata();
                if (typeMetadata.isIntervalType() || 92 == typeMetadata.getType() || 93 == typeMetadata.getType()) {
                    l3 = new Long(typeMetadata.getPrecision());
                } else if (typeMetadata.isExactNumericType()) {
                    l3 = new Long(typeMetadata.getScale());
                } else if (typeMetadata.isIntegerType()) {
                    l3 = 0L;
                }
                dataWrapper.setInteger(l3);
                return false;
            }
            case NUM_PREC_RADIX: {
                TypeMetadata typeMetadata = bQColumnMetadata.getTypeMetadata();
                Long l4 = typeMetadata.isIntegerType() || typeMetadata.isExactNumericType() ? Long.valueOf(10L) : (typeMetadata.isApproximateNumericType() ? Long.valueOf(2L) : null);
                dataWrapper.setInteger(l4);
                return false;
            }
            case NULLABLE: {
                dataWrapper.setSmallInt(bQColumnMetadata.getNullable().ordinal());
                return false;
            }
            case REMARKS: {
                dataWrapper.setNull(12);
                return false;
            }
            case COLUMN_DEF: {
                String string = bQColumnMetadata.getDefaultValue();
                if (string == null) {
                    dataWrapper.setNull(12);
                    return false;
                }
                return DSITypeUtilities.outputVarCharStringData(string, dataWrapper, l, l2);
            }
            case SQL_DATA_TYPE: {
                short s = bQColumnMetadata.getTypeMetadata().getType();
                dataWrapper.setInteger(s);
                return false;
            }
            case SQL_DATETIME_SUB: {
                short s = bQColumnMetadata.getTypeMetadata().getType();
                short s2 = TypeUtilities.getIntervalCodeFromConciseType(s);
                if (0 == s2) {
                    dataWrapper.setNull(5);
                } else {
                    dataWrapper.setSmallInt(s2);
                }
                return false;
            }
            case CHAR_OCTET_LENGTH: {
                Long l5 = null;
                if (bQColumnMetadata.getTypeMetadata().isCharacterOrBinaryType()) {
                    l5 = new Long(bQColumnMetadata.getByteLength());
                }
                dataWrapper.setInteger(l5);
                return false;
            }
            case ORDINAL_POSITION: {
                dataWrapper.setInteger(bQColumnMetadata.getPosition());
                return false;
            }
            case IS_NULLABLE: {
                return DSITypeUtilities.outputVarCharStringData(bQColumnMetadata.getNullable().isNullable().toUpperCase(), dataWrapper, l, l2);
            }
            case IS_AUTOINCREMENT: {
                return DSITypeUtilities.outputVarCharStringData("NO", dataWrapper, l, l2);
            }
            case USER_DATA_TYPE: {
                dataWrapper.setSmallInt(0);
                return false;
            }
            case IS_GENERATEDCOLUMN: {
                return DSITypeUtilities.outputVarCharStringData("NO", dataWrapper, l, l2);
            }
        }
        throw BQDriver.s_BQMessages.createGeneralException(BQMessageKey.METADATA_COLUMN_NOT_FOUND_ERR.name(), new String[]{metadataSourceColumnTag.toString()});
    }

    @Override
    public boolean hasMoreRows() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        return this.m_columnIdx + 1 < this.m_columns.size();
    }

    @Override
    public boolean moveToNextRow() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        boolean bl = false;
        try {
            bl = this.moveToNextColumn();
        }
        catch (ErrorException errorException) {
            this.m_cachedException = errorException;
            return true;
        }
        return bl;
    }
}

