/*
 * Decompiled with CFR 0.152.
 */
package com.simba.googlebigquery.googlebigquery.dataengine.metadata;

import com.google.api.services.bigquery.model.TableFieldSchema;
import com.simba.googlebigquery.dsi.dataengine.utilities.ColumnMetadata;
import com.simba.googlebigquery.dsi.dataengine.utilities.Nullable;
import com.simba.googlebigquery.dsi.dataengine.utilities.Searchable;
import com.simba.googlebigquery.dsi.dataengine.utilities.TypeMetadata;
import com.simba.googlebigquery.dsi.dataengine.utilities.TypeUtilities;
import com.simba.googlebigquery.dsi.dataengine.utilities.Updatable;
import com.simba.googlebigquery.dsi.exceptions.NumericOverflowException;
import com.simba.googlebigquery.googlebigquery.core.BQConnectionOptions;
import com.simba.googlebigquery.googlebigquery.core.BQDriver;
import com.simba.googlebigquery.googlebigquery.exceptions.BQMessageKey;
import com.simba.googlebigquery.googlebigquery.utils.BQCoreUtils;
import com.simba.googlebigquery.support.ILogger;
import com.simba.googlebigquery.support.LogUtilities;
import com.simba.googlebigquery.support.exceptions.ErrorException;
import java.util.List;

public class BQColumnMetadata
extends ColumnMetadata {
    private int m_columnPosition;
    private long m_byteLength;
    private String m_defaultValue;
    private boolean m_isRepeated = false;
    private boolean m_isRecord = false;
    private List<TableFieldSchema> nestedTypes = null;

    public BQColumnMetadata(ILogger iLogger, String string, String string2, String string3, TableFieldSchema tableFieldSchema, BQConnectionOptions bQConnectionOptions) throws ErrorException {
        super(TypeMetadata.createTypeMetadata(BQCoreUtils.isRepeated(tableFieldSchema) || BQCoreUtils.isRecord(tableFieldSchema) ? 12 : BQCoreUtils.bigqueryToSqlTypeConverter(tableFieldSchema.getType())));
        TypeMetadata typeMetadata = this.getTypeMetadata();
        this.m_isRepeated = BQCoreUtils.isRepeated(tableFieldSchema);
        this.m_isRecord = BQCoreUtils.isRecord(tableFieldSchema);
        if (this.m_isRecord || this.m_isRepeated) {
            this.nestedTypes = tableFieldSchema.getFields();
        }
        String string4 = BQCoreUtils.getBqTypeFromDialect(bQConnectionOptions.m_queryDialect, tableFieldSchema);
        typeMetadata.setLocalTypeName(string4);
        typeMetadata.setTypeName(string4);
        if (typeMetadata.isExactNumericType()) {
            short s = null != tableFieldSchema.getPrecision() ? tableFieldSchema.getPrecision().shortValue() : BQCoreUtils.getNumericPrecision(string4);
            short s2 = null != tableFieldSchema.getScale() ? tableFieldSchema.getScale().shortValue() : BQCoreUtils.getNumericScale(string4).shortValue();
            typeMetadata.setPrecision(s);
            typeMetadata.setScale(s2);
        }
        this.setCatalogName(string);
        this.setSchemaName(string2);
        this.setTableName(string3);
        String string5 = tableFieldSchema.getName();
        this.setName(string5);
        this.setLabel(string5);
        String string6 = tableFieldSchema.getDefaultValueExpression();
        if (string6 != null) {
            this.setDefaultValue(string6.toString());
        }
        short s = typeMetadata.getType();
        if (typeMetadata.isCharacterOrBinaryType()) {
            long l = null != tableFieldSchema.getMaxLength() ? tableFieldSchema.getMaxLength() : (typeMetadata.isBinaryType() ? 65535L : bQConnectionOptions.m_stringColumnLength);
            if (l > Integer.MAX_VALUE) {
                String string7 = "Column length " + l + " exceeds supported maximum, truncating to " + Integer.MAX_VALUE + ".";
                LogUtilities.logWarning(string7, iLogger);
                l = Integer.MAX_VALUE;
            }
            try {
                this.setColumnLength(l);
            }
            catch (NumericOverflowException numericOverflowException) {
                throw BQDriver.s_BQMessages.createGeneralException(BQMessageKey.RESULT_COLUMN_INIT_ERR.name(), (Throwable)numericOverflowException);
            }
        }
        switch (s) {
            case 92: 
            case 93: {
                typeMetadata.setPrecision((short)6);
            }
        }
        this.setAutoUnique(false);
        this.setCaseSensitive(false);
        if (null != tableFieldSchema.getMode()) {
            String string8 = tableFieldSchema.getMode();
            if (string8.equals("NULLABLE")) {
                this.setNullable(Nullable.NULLABLE);
            } else if (string8.equals("REQUIRED")) {
                this.setNullable(Nullable.NO_NULLS);
            }
        }
        this.setSearchable(Searchable.SEARCHABLE);
        this.setUpdatable(Updatable.WRITE);
        this.m_byteLength = -8 == s || -9 == s || -10 == s ? this.getColumnLength() * 2L : (typeMetadata.isCharacterOrBinaryType() ? this.getColumnLength() : (long)TypeUtilities.getSizeInBytes(s));
    }

    public long getByteLength() {
        return this.m_byteLength;
    }

    public String getDefaultValue() {
        return this.m_defaultValue;
    }

    public boolean isRecord() {
        return this.m_isRecord;
    }

    public boolean isRepeated() {
        return this.m_isRepeated;
    }

    public int getPosition() {
        return this.m_columnPosition;
    }

    public void setDefaultValue(String string) {
        this.m_defaultValue = string;
    }

    public void setPosition(int n) {
        this.m_columnPosition = n;
    }

    public List<TableFieldSchema> getNestedTypes() {
        return this.nestedTypes;
    }
}

