/*
 * Decompiled with CFR 0.152.
 */
package com.simba.googlebigquery.googlebigquery.dataengine;

import com.simba.googlebigquery.googlebigquery.BigQuery;
import com.simba.googlebigquery.googlebigquery.dataengine.BQAbstractReplacer;
import com.simba.googlebigquery.support.EscapeTypes;
import com.simba.googlebigquery.support.IReplacer;
import java.util.ArrayList;

public class BQStandardReplacer
extends BQAbstractReplacer
implements IReplacer {
    @Override
    public StringBuilder replace(EscapeTypes escapeTypes, ArrayList<StringBuilder> arrayList) {
        StringBuilder stringBuilder = new StringBuilder();
        switch (escapeTypes) {
            case PARAM: {
                return stringBuilder.append("?");
            }
            case LIMIT_OFFSET: {
                if (1 == arrayList.size()) {
                    stringBuilder.append("LIMIT").append(" ").append((CharSequence)arrayList.get(0));
                } else if (2 == arrayList.size()) {
                    stringBuilder.append("LIMIT").append(" ").append((CharSequence)arrayList.get(0)).append(" ").append("OFFSET").append(" ").append((CharSequence)arrayList.get(1));
                }
                return stringBuilder;
            }
            case DATE: 
            case TIME: 
            case TIMESTAMP: {
                return stringBuilder.append(escapeTypes.toString()).append((CharSequence)arrayList.get(0));
            }
            case OUTERJOIN: {
                int n = arrayList.size();
                stringBuilder.append("(");
                for (int i = 0; i < n; ++i) {
                    stringBuilder.append((CharSequence)arrayList.get(i));
                    if (i == n - 1) continue;
                    stringBuilder.append(" ");
                }
                return stringBuilder.append(")");
            }
            case FN: {
                String string = arrayList.get(0).toString().toUpperCase();
                if (string.equals(BigQuery.JDBCScalarFunctions.ASCII.name()) && 2 == arrayList.size()) {
                    return stringBuilder.append("TO_CODE_POINTS(" + arrayList.get(1) + ")[OFFSET(0)]");
                }
                if (string.equals(BigQuery.JDBCScalarFunctions.BIT_LENGTH.name()) && 2 == arrayList.size()) {
                    return stringBuilder.append("BYTE_LENGTH(" + arrayList.get(1) + ")*8");
                }
                if (string.equals(BigQuery.JDBCScalarFunctions.CHAR.name()) && 2 == arrayList.size()) {
                    return stringBuilder.append("CODE_POINTS_TO_STRING([" + arrayList.get(1) + "])");
                }
                if ((string.equals(BigQuery.JDBCScalarFunctions.CHAR_LENGTH.name()) || string.equals(BigQuery.JDBCScalarFunctions.CHARACTER_LENGTH.name())) && 2 == arrayList.size()) {
                    return stringBuilder.append("LENGTH(" + arrayList.get(1) + ")");
                }
                if (string.equals(BigQuery.JDBCScalarFunctions.INSERT.name()) && 5 == arrayList.size()) {
                    return stringBuilder.append("CONCAT(SUBSTR(" + arrayList.get(1) + ",1," + arrayList.get(2) + "-1)," + arrayList.get(4) + ",SUBSTR(" + arrayList.get(1) + "," + arrayList.get(2) + "+" + arrayList.get(3) + "))");
                }
                if (string.equals(BigQuery.JDBCScalarFunctions.LCASE.name()) && 2 == arrayList.size()) {
                    return stringBuilder.append("LOWER(" + arrayList.get(1) + ")");
                }
                if (string.equals(BigQuery.JDBCScalarFunctions.LEFT.name()) && 3 == arrayList.size()) {
                    return stringBuilder.append("SUBSTR(" + arrayList.get(1) + ",1," + arrayList.get(2) + ")");
                }
                if (string.equals(BigQuery.JDBCScalarFunctions.LENGTH.name()) && 2 == arrayList.size()) {
                    return stringBuilder.append("CHAR_LENGTH(CAST(" + arrayList.get(1) + " AS STRING))");
                }
                if (string.equals(BigQuery.JDBCScalarFunctions.LOCATE.name()) && 3 == arrayList.size()) {
                    return stringBuilder.append("STRPOS(" + arrayList.get(2) + "," + arrayList.get(1) + ")");
                }
                if (string.equals(BigQuery.JDBCScalarFunctions.OCTET_LENGTH.name()) && 2 == arrayList.size()) {
                    return stringBuilder.append("BYTE_LENGTH(" + arrayList.get(1) + ")");
                }
                if (string.equals(BigQuery.JDBCScalarFunctions.RIGHT.name()) && 3 == arrayList.size()) {
                    return stringBuilder.append("SUBSTR(" + arrayList.get(1) + ",-" + arrayList.get(2) + "," + arrayList.get(2) + ")");
                }
                if (string.equals(BigQuery.JDBCScalarFunctions.SPACE.name()) && 2 == arrayList.size()) {
                    return stringBuilder.append("REPEAT(\" \"," + arrayList.get(1) + ")");
                }
                if (string.equals(BigQuery.JDBCScalarFunctions.SUBSTRING.name()) && 4 == arrayList.size()) {
                    return stringBuilder.append("SUBSTR(" + arrayList.get(1) + "," + arrayList.get(2) + "," + arrayList.get(3) + ")");
                }
                if (string.equals(BigQuery.JDBCScalarFunctions.UCASE.name()) && 2 == arrayList.size()) {
                    return stringBuilder.append("UPPER(" + arrayList.get(1) + ")");
                }
                if (string.equals(BigQuery.JDBCScalarFunctions.CURRENT_DATE.name()) || string.equals(BigQuery.JDBCScalarFunctions.CURDATE.name())) {
                    return stringBuilder.append("CURRENT_DATE");
                }
                if (string.equals(BigQuery.JDBCScalarFunctions.CURRENT_TIME.name())) {
                    return stringBuilder.append("CURRENT_TIME");
                }
                if (string.equals(BigQuery.JDBCScalarFunctions.CURRENT_TIMESTAMP.name())) {
                    return stringBuilder.append("CURRENT_TIMESTAMP");
                }
                if (string.equals(BigQuery.JDBCScalarFunctions.CURTIME.name())) {
                    return stringBuilder.append("CURRENT_TIME");
                }
                if (string.equals(BigQuery.JDBCScalarFunctions.DAYNAME.name()) && 2 == arrayList.size()) {
                    this.wrapDateExpression(arrayList.get(1));
                    return stringBuilder.append("FORMAT_DATE(\"%A\"," + arrayList.get(1) + ")");
                }
                if (string.equals(BigQuery.JDBCScalarFunctions.DAYOFMONTH.name()) && 2 == arrayList.size()) {
                    this.wrapDateExpression(arrayList.get(1));
                    return stringBuilder.append("EXTRACT(DAY FROM " + arrayList.get(1) + ")");
                }
                if (string.equals(BigQuery.JDBCScalarFunctions.DAYOFWEEK.name()) && 2 == arrayList.size()) {
                    this.wrapDateExpression(arrayList.get(1));
                    return stringBuilder.append("EXTRACT(DAYOFWEEK FROM " + arrayList.get(1) + ")");
                }
                if (string.equals(BigQuery.JDBCScalarFunctions.DAYOFYEAR.name()) && 2 == arrayList.size()) {
                    this.wrapDateExpression(arrayList.get(1));
                    return stringBuilder.append("EXTRACT(DAYOFYEAR FROM " + arrayList.get(1) + ")");
                }
                if (string.equals(BigQuery.JDBCScalarFunctions.HOUR.name()) && 2 == arrayList.size()) {
                    this.wrapTimeExpression(arrayList.get(1));
                    return stringBuilder.append("EXTRACT(HOUR FROM " + arrayList.get(1) + ")");
                }
                if (string.equals(BigQuery.JDBCScalarFunctions.MINUTE.name()) && 2 == arrayList.size()) {
                    this.wrapTimeExpression(arrayList.get(1));
                    return stringBuilder.append("EXTRACT(MINUTE FROM " + arrayList.get(1) + ")");
                }
                if (string.equals(BigQuery.JDBCScalarFunctions.MONTH.name()) && 2 == arrayList.size()) {
                    this.wrapDateExpression(arrayList.get(1));
                    return stringBuilder.append("EXTRACT(MONTH FROM " + arrayList.get(1) + ")");
                }
                if (string.equals(BigQuery.JDBCScalarFunctions.MONTHNAME.name()) && 2 == arrayList.size()) {
                    this.wrapDateExpression(arrayList.get(1));
                    return stringBuilder.append("FORMAT_DATE(\"%B\"," + arrayList.get(1) + ")");
                }
                if (string.equals(BigQuery.JDBCScalarFunctions.NOW.name())) {
                    return stringBuilder.append("CURRENT_TIMESTAMP");
                }
                if (string.equals(BigQuery.JDBCScalarFunctions.QUARTER.name()) && 2 == arrayList.size()) {
                    this.wrapDateExpression(arrayList.get(1));
                    return stringBuilder.append("EXTRACT(QUARTER FROM " + arrayList.get(1) + ")");
                }
                if (string.equals(BigQuery.JDBCScalarFunctions.SECOND.name()) && 2 == arrayList.size()) {
                    this.wrapTimeExpression(arrayList.get(1));
                    return stringBuilder.append("EXTRACT(SECOND FROM " + arrayList.get(1) + ")");
                }
                String string2 = arrayList.get(1).toString().toUpperCase();
                if (string.equals(BigQuery.JDBCScalarFunctions.TIMESTAMPDIFF.name()) && 4 == arrayList.size()) {
                    if (string2.equals(BigQuery.JDBCTimestampInterval.SQL_TSI_SECOND.name()) || string2.equals(BigQuery.JDBCTimestampInterval.SQL_TSI_MINUTE.name()) || string2.equals(BigQuery.JDBCTimestampInterval.SQL_TSI_HOUR.name())) {
                        this.wrapTimestampExpression(arrayList.get(3));
                        this.wrapTimestampExpression(arrayList.get(2));
                        return stringBuilder.append("TIMESTAMP_DIFF(" + arrayList.get(3) + "," + arrayList.get(2) + "," + (String)jdbcToBigQueryIntervalMap.get(string2) + ")");
                    }
                    if (string2.equals(BigQuery.JDBCTimestampInterval.SQL_TSI_DAY.name()) || string2.equals(BigQuery.JDBCTimestampInterval.SQL_TSI_MONTH.name()) || string2.equals(BigQuery.JDBCTimestampInterval.SQL_TSI_QUARTER.name()) || string2.equals(BigQuery.JDBCTimestampInterval.SQL_TSI_YEAR.name())) {
                        this.wrapDateExpression(arrayList.get(3));
                        this.wrapDateExpression(arrayList.get(2));
                        return stringBuilder.append("DATE_DIFF(" + arrayList.get(3) + "," + arrayList.get(2) + "," + (String)jdbcToBigQueryIntervalMap.get(string2) + ")");
                    }
                    return this.originalExpression(arrayList, stringBuilder);
                }
                if (string.equals(BigQuery.JDBCScalarFunctions.TIMESTAMPADD.name()) && 4 == arrayList.size()) {
                    if (string2.equals(BigQuery.JDBCTimestampInterval.SQL_TSI_SECOND.name()) || string2.equals(BigQuery.JDBCTimestampInterval.SQL_TSI_MINUTE.name()) || string2.equals(BigQuery.JDBCTimestampInterval.SQL_TSI_HOUR.name())) {
                        this.wrapTimestampExpression(arrayList.get(3));
                        return stringBuilder.append("TIMESTAMP_ADD(" + arrayList.get(3) + ",INTERVAL " + arrayList.get(2) + " " + (String)jdbcToBigQueryIntervalMap.get(string2) + ")");
                    }
                    if (string2.equals(BigQuery.JDBCTimestampInterval.SQL_TSI_DAY.name()) || string2.equals(BigQuery.JDBCTimestampInterval.SQL_TSI_WEEK.name()) || string2.equals(BigQuery.JDBCTimestampInterval.SQL_TSI_MONTH.name()) || string2.equals(BigQuery.JDBCTimestampInterval.SQL_TSI_QUARTER.name()) || string2.equals(BigQuery.JDBCTimestampInterval.SQL_TSI_YEAR.name())) {
                        this.wrapDateExpression(arrayList.get(3));
                        return stringBuilder.append("CAST(DATE_ADD(" + arrayList.get(3) + ",INTERVAL " + arrayList.get(2) + " " + (String)jdbcToBigQueryIntervalMap.get(string2) + ") AS TIMESTAMP)");
                    }
                    return this.originalExpression(arrayList, stringBuilder);
                }
                if (string.equals(BigQuery.JDBCScalarFunctions.WEEK.name()) && 2 == arrayList.size()) {
                    this.wrapDateExpression(arrayList.get(1));
                    return stringBuilder.append("CAST(FORMAT_DATE(\"%U\"," + arrayList.get(1) + ") AS INT64)");
                }
                if (string.equals(BigQuery.JDBCScalarFunctions.YEAR.name()) && 2 == arrayList.size()) {
                    this.wrapDateExpression(arrayList.get(1));
                    return stringBuilder.append("EXTRACT(YEAR FROM " + arrayList.get(1) + ")");
                }
                if (string.equals(BigQuery.JDBCScalarFunctions.ATAN2.name()) && 3 == arrayList.size()) {
                    return stringBuilder.append("ATAN2(" + arrayList.get(2) + "," + arrayList.get(1) + ")");
                }
                if (string.equals(BigQuery.JDBCScalarFunctions.COT.name()) && 2 == arrayList.size()) {
                    return stringBuilder.append("1/TAN(" + arrayList.get(1) + ")");
                }
                if (string.equals(BigQuery.JDBCScalarFunctions.DEGREES.name()) && 2 == arrayList.size()) {
                    return stringBuilder.append(arrayList.get(1) + "*180/ACOS(-1)");
                }
                if (string.equals(BigQuery.JDBCScalarFunctions.PI.name())) {
                    return stringBuilder.append("ACOS(-1)");
                }
                if (string.equals(BigQuery.JDBCScalarFunctions.RADIANS.name()) && 2 == arrayList.size()) {
                    return stringBuilder.append(arrayList.get(1) + "*ACOS(-1)/180");
                }
                if (string.equals(BigQuery.JDBCScalarFunctions.RAND.name())) {
                    return stringBuilder.append("RAND()");
                }
                if (string.equals(BigQuery.JDBCScalarFunctions.CONVERT.name()) && 3 == arrayList.size()) {
                    try {
                        return stringBuilder.append(this.getCastClause(string2, arrayList.get(2).toString()));
                    }
                    catch (Exception exception) {
                        return this.originalExpression(arrayList, stringBuilder);
                    }
                }
                return this.originalExpression(arrayList, stringBuilder);
            }
        }
        return stringBuilder.append("NOT IMPLEMENTED: ").append(escapeTypes.toString());
    }
}

