/*
 * Decompiled with CFR 0.152.
 */
package com.simba.googlebigquery.googlebigquery.dataengine;

import com.google.api.services.bigquery.model.Job;
import com.google.api.services.bigquery.model.TableFieldSchema;
import com.google.api.services.bigquery.model.TableSchema;
import com.simba.googlebigquery.dsi.dataengine.impl.DSISimpleResultSet;
import com.simba.googlebigquery.dsi.dataengine.utilities.ColumnMetadata;
import com.simba.googlebigquery.dsi.dataengine.utilities.DataWrapper;
import com.simba.googlebigquery.googlebigquery.client.IBQResponse;
import com.simba.googlebigquery.googlebigquery.core.BQConnection;
import com.simba.googlebigquery.googlebigquery.core.BQConnectionOptions;
import com.simba.googlebigquery.googlebigquery.core.BQDriver;
import com.simba.googlebigquery.googlebigquery.dataengine.BQBufferManager;
import com.simba.googlebigquery.googlebigquery.dataengine.BQHTDataHandler;
import com.simba.googlebigquery.googlebigquery.dataengine.BQRestDataHandler;
import com.simba.googlebigquery.googlebigquery.dataengine.IBQDataHandler;
import com.simba.googlebigquery.googlebigquery.dataengine.metadata.BQColumnMetadata;
import com.simba.googlebigquery.googlebigquery.exceptions.BQMessageKey;
import com.simba.googlebigquery.support.ILogger;
import com.simba.googlebigquery.support.LogUtilities;
import com.simba.googlebigquery.support.exceptions.ErrorException;
import java.util.ArrayList;
import java.util.List;

public class BQResultSet
extends DSISimpleResultSet {
    private BQBufferManager m_bufferManager;
    private final ArrayList<ColumnMetadata> m_columns = new ArrayList();
    private final BQConnectionOptions m_connectionOptions;
    private long m_currOverallRowNum = 0L;
    private IBQDataHandler m_dataHandler;
    private final ILogger m_logger;
    private long m_totalRowCount;

    public BQResultSet(ILogger iLogger, BQConnection bQConnection, IBQResponse iBQResponse, boolean bl) throws ErrorException {
        LogUtilities.logFunctionEntrance(iLogger, bQConnection, iBQResponse, bl);
        this.m_logger = iLogger;
        this.m_connectionOptions = bQConnection.getSettings();
        this.m_totalRowCount = null != iBQResponse.getTotalRows() ? iBQResponse.getTotalRows().longValue() : 0L;
        TableSchema tableSchema = iBQResponse.getSchema();
        if (null == tableSchema || null == tableSchema.getFields()) {
            return;
        }
        this.initializeColumns(tableSchema.getFields());
        if (!bl) {
            String string = iBQResponse.getJobReference().getJobId();
            if (null == string) {
                throw BQDriver.s_BQMessages.createGeneralException(BQMessageKey.EXEC_JOB_GET_ERR.name());
            }
            this.m_bufferManager = new BQBufferManager(this.m_logger, bQConnection, string, iBQResponse.getJobReference().getLocation(), iBQResponse);
        }
        this.initializeDataHandler(iBQResponse);
    }

    public BQResultSet(ILogger iLogger, BQConnection bQConnection, Job job) throws ErrorException {
        LogUtilities.logFunctionEntrance(iLogger, bQConnection, job);
        this.m_logger = iLogger;
        this.m_connectionOptions = bQConnection.getSettings();
        if (null == job.getConfiguration()) {
            throw BQDriver.s_BQMessages.createGeneralException(BQMessageKey.RESULT_JOB_TABLE_SCHEMA.name());
        }
        if (null != job.getConfiguration().getDryRun() && job.getConfiguration().getDryRun().booleanValue()) {
            if (null == job.getStatistics() || null == job.getStatistics().getQuery() || null == job.getStatistics().getQuery().getSchema() || null == job.getStatistics().getQuery().getSchema().getFields()) {
                throw BQDriver.s_BQMessages.createGeneralException(BQMessageKey.RESULT_JOB_TABLE_SCHEMA.name());
            }
            this.initializeColumns(job.getStatistics().getQuery().getSchema().getFields());
        }
        this.initializeDataHandler(null);
    }

    @Override
    public void close() {
        try {
            this.closeCursor();
        }
        catch (ErrorException errorException) {
            // empty catch block
        }
    }

    @Override
    public boolean getData(int n, long l, long l2, DataWrapper dataWrapper) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, n, l, l2, dataWrapper);
        return this.m_dataHandler.retrieveData(n, l, l2, dataWrapper);
    }

    @Override
    public long getRowCount() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        return this.m_totalRowCount;
    }

    @Override
    public ArrayList<ColumnMetadata> getSelectColumns() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        return this.m_columns;
    }

    @Override
    public boolean hasMoreRows() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        return this.m_currOverallRowNum < this.m_totalRowCount;
    }

    @Override
    public boolean hasRowCount() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        return true;
    }

    @Override
    protected void doCloseCursor() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.m_currOverallRowNum = 0L;
        if (null != this.m_bufferManager) {
            this.m_bufferManager.stop();
            this.m_bufferManager.cleanUp();
            this.m_bufferManager = null;
        }
    }

    @Override
    protected boolean doMoveToNextRow() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (this.m_currOverallRowNum >= this.m_totalRowCount) {
            if (null != this.m_bufferManager) {
                this.m_bufferManager.stop();
            }
            LogUtilities.logInfo("No more rows.", this.m_logger);
            return false;
        }
        if (this.m_dataHandler.moveToNextRow()) {
            ++this.m_currOverallRowNum;
        } else if (this.m_bufferManager.isHTAPIReading()) {
            throw BQDriver.s_BQMessages.createGeneralException(BQMessageKey.RESULT_STREAM_GET_ERR.name(), "Expecting " + this.m_totalRowCount + " rows but retrieved only " + this.m_currOverallRowNum);
        }
        return true;
    }

    private void initializeColumns(List<TableFieldSchema> list) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, list);
        this.m_columns.clear();
        int n = 0;
        for (TableFieldSchema tableFieldSchema : list) {
            BQColumnMetadata bQColumnMetadata = new BQColumnMetadata(this.m_logger, this.m_connectionOptions.m_projectId, null, null, tableFieldSchema, this.m_connectionOptions);
            bQColumnMetadata.setPosition(++n);
            this.m_columns.add(bQColumnMetadata);
        }
    }

    private void initializeDataHandler(IBQResponse iBQResponse) {
        if ((this.m_connectionOptions.m_forceHTAPI || this.m_connectionOptions.m_enableHighThroughPutAPI) && null != this.m_bufferManager && this.m_bufferManager.isHTAPIReading()) {
            this.m_dataHandler = new BQHTDataHandler(this.m_bufferManager, this.m_columns, this.m_logger);
        } else {
            this.logFirstPageRowCount(iBQResponse);
            this.m_dataHandler = new BQRestDataHandler(this.m_bufferManager, iBQResponse, this.m_columns, this.m_logger, this.getWarningListener());
        }
    }

    private void logFirstPageRowCount(IBQResponse iBQResponse) {
        if (null != iBQResponse) {
            if (null != iBQResponse.getRows()) {
                LogUtilities.logInfo(iBQResponse.getRows().size() + " rows retrieved.", this.m_logger);
            } else if (null != iBQResponse.getTotalRows() && 0L == iBQResponse.getTotalRows().longValue()) {
                LogUtilities.logInfo("No rows retrieved.", this.m_logger);
            }
        }
    }
}

