/*
 * Decompiled with CFR 0.152.
 */
package com.simba.googlebigquery.googlebigquery.dataengine;

import com.google.api.client.util.Base64;
import com.google.api.services.bigquery.model.TableCell;
import com.google.api.services.bigquery.model.TableFieldSchema;
import com.simba.googlebigquery.dsi.dataengine.utilities.DSITypeUtilities;
import com.simba.googlebigquery.dsi.dataengine.utilities.DataWrapper;
import com.simba.googlebigquery.dsi.dataengine.utilities.TimestampTz;
import com.simba.googlebigquery.googlebigquery.core.BQDriver;
import com.simba.googlebigquery.googlebigquery.dataengine.metadata.BQColumnMetadata;
import com.simba.googlebigquery.googlebigquery.exceptions.BQMessageKey;
import com.simba.googlebigquery.googlebigquery.utils.BQCoreUtils;
import com.simba.googlebigquery.support.ILogger;
import com.simba.googlebigquery.support.IWarningListener;
import com.simba.googlebigquery.support.LogUtilities;
import com.simba.googlebigquery.support.Warning;
import com.simba.googlebigquery.support.WarningCode;
import com.simba.googlebigquery.support.conv.CharConverter;
import com.simba.googlebigquery.support.conv.ConversionResult;
import com.simba.googlebigquery.support.exceptions.ErrorException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class BQRestParser {
    private BQRestParser() {
    }

    public static boolean getDataOldAPI(short s, String string, long l, long l2, DataWrapper dataWrapper, String string2, ILogger iLogger, IWarningListener iWarningListener) throws ErrorException {
        LogUtilities.logFunctionEntrance(iLogger, new Object[0]);
        switch (s) {
            case 12: {
                return DSITypeUtilities.outputVarCharStringData(string2, dataWrapper, l, l2);
            }
            case -5: {
                dataWrapper.setBigInt(new BigInteger(string2));
                return false;
            }
            case 8: {
                dataWrapper.setDouble(Double.parseDouble(string2));
                return false;
            }
            case 16: {
                dataWrapper.setBoolean(Boolean.parseBoolean(string2));
                return false;
            }
            case 91: {
                try {
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
                    java.util.Date date = simpleDateFormat.parse(string2);
                    dataWrapper.setDate(new Date(date.getTime()));
                    return false;
                }
                catch (ParseException parseException) {
                    throw BQDriver.s_BQMessages.createGeneralException(BQMessageKey.RESULT_DATE_PARSE_ERR.name(), parseException.getMessage());
                }
            }
            case 92: {
                BQRestParser.timeToString(dataWrapper, string2, iWarningListener);
                return false;
            }
            case 93: {
                if (string.equals("TIMESTAMP")) {
                    dataWrapper.setTimestamp(BQCoreUtils.convertUnixToTimestamp(Double.parseDouble(string2)));
                } else {
                    string2 = string2.replace('T', ' ');
                    dataWrapper.setTimestamp(Timestamp.valueOf(string2));
                }
                return false;
            }
            case -3: {
                byte[] byArray = Base64.decodeBase64((String)string2);
                return DSITypeUtilities.outputVarBinary(byArray, dataWrapper, l, l2);
            }
            case 2: 
            case 3: {
                BQRestParser.numDecimalToString(dataWrapper, string2, iWarningListener, string);
                return false;
            }
        }
        return false;
    }

    public static void arrayToString(int n, BQColumnMetadata bQColumnMetadata, StringBuilder stringBuilder, List<TableCell> list) throws ErrorException {
        TableCell tableCell = list.get(n);
        Collection collection = tableCell.values();
        Object[] objectArray = collection.toArray();
        if (0 == objectArray.length) {
            stringBuilder.append(list.get(n).toString());
        } else if (objectArray[0] instanceof ArrayList) {
            ArrayList arrayList = (ArrayList)objectArray[0];
            BQRestParser.parseRestAPIArray(stringBuilder, bQColumnMetadata.getNestedTypes(), arrayList, bQColumnMetadata.getName().toLowerCase());
        }
    }

    public static void structToString(int n, BQColumnMetadata bQColumnMetadata, StringBuilder stringBuilder, List<TableCell> list) throws ErrorException {
        TableCell tableCell = list.get(n);
        Collection collection = tableCell.values();
        Object[] objectArray = collection.toArray();
        if (0 == objectArray.length) {
            stringBuilder.append(list.get(n).toString());
        } else {
            Object object = objectArray[0];
            if (object instanceof Map) {
                ArrayList<Object> arrayList = BQRestParser.getList((AbstractMap)object);
                if (null != arrayList) {
                    stringBuilder.append("{\"v\":");
                    BQRestParser.parseRestAPIStruct(bQColumnMetadata.getNestedTypes(), stringBuilder, arrayList);
                    stringBuilder.append("}");
                } else {
                    stringBuilder.append(list.get(n).toString());
                }
            }
        }
    }

    private static void parseDataToStringRestAPI(StringBuilder stringBuilder, String string, String string2) throws ErrorException {
        switch (string2.toUpperCase()) {
            case "BOOLEAN": {
                if (Boolean.parseBoolean(string)) {
                    stringBuilder.append("1");
                    break;
                }
                stringBuilder.append("0");
                break;
            }
            case "DATE": {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
                try {
                    java.util.Date date = simpleDateFormat.parse(string);
                    Date date2 = new Date(date.getTime());
                    stringBuilder.append(date2.toString());
                    break;
                }
                catch (ParseException parseException) {
                    throw BQDriver.s_BQMessages.createGeneralException(BQMessageKey.RESULT_DATE_PARSE_ERR.name(), parseException.getMessage());
                }
            }
            case "DATETIME": {
                stringBuilder.append(string.replace('T', ' '));
                break;
            }
            case "DECIMAL": 
            case "NUMERIC": 
            case "BIGNUMERIC": {
                ConversionResult conversionResult = new ConversionResult();
                short s = BQCoreUtils.getNumericScale(string2);
                BigDecimal bigDecimal = CharConverter.toExactNum(string, conversionResult, BQCoreUtils.getNumericPrecision(string2), s);
                bigDecimal = bigDecimal.setScale(s);
                stringBuilder.append(bigDecimal.toPlainString());
                break;
            }
            case "FLOAT": {
                stringBuilder.append(Double.toString(Double.parseDouble(string)));
                break;
            }
            case "TIME": {
                ConversionResult conversionResult = new ConversionResult();
                Time time = CharConverter.toTime(string, conversionResult, (short)6, null);
                stringBuilder.append(time.toString());
                break;
            }
            case "TIMESTAMP": {
                TimestampTz timestampTz = BQCoreUtils.convertUnixToTimestamp(Double.parseDouble(string));
                stringBuilder.append(timestampTz.toString());
                break;
            }
            default: {
                stringBuilder.append(string);
            }
        }
    }

    private static void parseRestAPIArray(StringBuilder stringBuilder, List<TableFieldSchema> list, ArrayList<Object> arrayList, String string) throws ErrorException {
        stringBuilder.append("{");
        stringBuilder.append("\"v\":");
        stringBuilder.append("[");
        int n = 0;
        for (Object object : arrayList) {
            Object object2;
            if (!(object instanceof Map)) continue;
            AbstractMap abstractMap = (AbstractMap)object;
            stringBuilder.append("{");
            stringBuilder.append("\"v\":\"");
            if (list != null) {
                stringBuilder.deleteCharAt(stringBuilder.length() - 1);
                object2 = BQRestParser.getList((AbstractMap)abstractMap.get("v"));
                BQRestParser.parseRestAPIStruct(list, stringBuilder, (ArrayList<Object>)object2);
                stringBuilder.append("},");
                ++n;
                continue;
            }
            string = BQRestParser.getType(string);
            try {
                object2 = (String)abstractMap.get("v");
                BQRestParser.parseDataToStringRestAPI(stringBuilder, (String)object2, string);
            }
            catch (ClassCastException classCastException) {
                stringBuilder.append("null");
            }
            stringBuilder.append("\"},");
        }
        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        stringBuilder.append("]}");
    }

    private static void parseRestAPIStruct(List<TableFieldSchema> list, StringBuilder stringBuilder, ArrayList<Object> arrayList) throws ErrorException {
        stringBuilder.append("{");
        stringBuilder.append("\"f\":[");
        int n = 0;
        for (int i = 0; i < arrayList.size() && n != list.size(); ++i) {
            ArrayList<Object> arrayList2;
            if (!(arrayList.get(i) instanceof Map)) continue;
            AbstractMap abstractMap = (AbstractMap)arrayList.get(i);
            if (abstractMap.get("v") instanceof Map) {
                arrayList2 = BQRestParser.getList(abstractMap);
                if (null == arrayList2) break;
                stringBuilder.append("{");
                stringBuilder.append("\"v\":");
                BQRestParser.parseRestAPIStruct(list.get(n).getFields(), stringBuilder, arrayList2);
                stringBuilder.append("}");
                if (n < arrayList.size() - 1) {
                    stringBuilder.append(",");
                }
                ++n;
                continue;
            }
            if (abstractMap.get("v") instanceof ArrayList) {
                BQRestParser.parseRestAPIArray(stringBuilder, list.get(n).getFields(), (ArrayList)abstractMap.get("v"), list.get(n).getType().toLowerCase());
                if (n < arrayList.size() - 1) {
                    stringBuilder.append(",");
                }
                ++n;
                continue;
            }
            stringBuilder.append("{");
            stringBuilder.append("\"v\":\"");
            arrayList2 = list.get(n).getType();
            try {
                String string = (String)abstractMap.get("v");
                BQRestParser.parseDataToStringRestAPI(stringBuilder, string, (String)((Object)arrayList2));
                stringBuilder.append("\"}");
            }
            catch (ClassCastException classCastException) {
                stringBuilder.deleteCharAt(stringBuilder.length() - 1);
                stringBuilder.append("null");
                stringBuilder.append("}");
            }
            if (n < arrayList.size() - 1) {
                stringBuilder.append(",");
            }
            ++n;
        }
        stringBuilder.append("]}");
    }

    private static void numDecimalToString(DataWrapper dataWrapper, String string, IWarningListener iWarningListener, String string2) {
        ConversionResult conversionResult = new ConversionResult();
        short s = BQCoreUtils.getNumericScale(string2);
        BigDecimal bigDecimal = CharConverter.toExactNum(string, conversionResult, BQCoreUtils.getNumericPrecision(string2), s);
        bigDecimal = bigDecimal.setScale(s);
        dataWrapper.setNumeric(bigDecimal);
        if (ConversionResult.TypeConversionState.INVALID_CHAR_VAL_FOR_CAST.equals((Object)conversionResult.getState()) && null != iWarningListener) {
            iWarningListener.postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, BQMessageKey.RESULT_NUMERIC_INVALID_CHAR_VAL.name()));
        }
    }

    private static void timeToString(DataWrapper dataWrapper, String string, IWarningListener iWarningListener) {
        ConversionResult conversionResult = new ConversionResult();
        Time time = CharConverter.toTime(string, conversionResult, (short)6, null);
        dataWrapper.setTime(time);
        if (ConversionResult.TypeConversionState.INVALID_CHAR_VAL_FOR_CAST.equals((Object)conversionResult.getState())) {
            if (null != iWarningListener) {
                iWarningListener.postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, BQMessageKey.RESULT_TIME_INVALID_CHAR_VAL.name()));
            }
        } else if (ConversionResult.TypeConversionState.DATETIME_OVERFLOW.equals((Object)conversionResult.getState())) {
            if (null != iWarningListener) {
                iWarningListener.postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, BQMessageKey.RESULT_TIME_DATETIME_OVERFLOW.name()));
            }
        } else if (ConversionResult.TypeConversionState.FRAC_TRUNCATION_ROUNDED_DOWN.equals((Object)conversionResult.getState()) && null != iWarningListener) {
            iWarningListener.postWarning(new Warning(WarningCode.FRACTIONAL_TRUNCATION, 101, BQMessageKey.RESULT_TIME_FRAC_TRUNCATION_ROUNDED_DOWN.name()));
        }
    }

    private static ArrayList<Object> getList(Map map) {
        if (null == map) {
            return null;
        }
        Collection collection = map.values();
        Object[] objectArray = collection.toArray();
        if (0 == objectArray.length) {
            return null;
        }
        if (objectArray[0] instanceof Map) {
            return BQRestParser.getList((AbstractMap)objectArray[0]);
        }
        if (objectArray[0] instanceof ArrayList) {
            return (ArrayList)objectArray[0];
        }
        return null;
    }

    private static String getType(String string) {
        if ((string = string.toUpperCase()).contains("BOOLEAN")) {
            string = "BOOLEAN";
        } else if (string.contains("DATETIME")) {
            string = "DATETIME";
        } else if (string.contains("DATE")) {
            string = "DATE";
        } else if (string.contains("DOUBLE")) {
            string = "FLOAT";
        } else if (string.contains("BIGNUMERIC")) {
            string = "BIGNUMERIC";
        } else if (string.contains("NUMERIC") || string.contains("DECIMAL")) {
            string = "NUMERIC";
        } else if (string.contains("TIMESTAMP")) {
            string = "TIMESTAMP";
        } else if (string.contains("TIME")) {
            string = "TIME";
        }
        return string;
    }
}

