/*
 * Decompiled with CFR 0.152.
 */
package com.simba.googlebigquery.googlebigquery.dataengine;

import com.simba.googlebigquery.dsi.dataengine.filters.IFilter;
import com.simba.googlebigquery.dsi.dataengine.impl.DSIDataEngine;
import com.simba.googlebigquery.dsi.dataengine.impl.DSIEmptyMetadataSource;
import com.simba.googlebigquery.dsi.dataengine.impl.DSITableTypeOnlyMetadataSource;
import com.simba.googlebigquery.dsi.dataengine.interfaces.IMetadataSource;
import com.simba.googlebigquery.dsi.dataengine.interfaces.IQueryExecutor;
import com.simba.googlebigquery.dsi.dataengine.interfaces.IResultSet;
import com.simba.googlebigquery.dsi.dataengine.utilities.MetadataSourceColumnTag;
import com.simba.googlebigquery.dsi.dataengine.utilities.MetadataSourceID;
import com.simba.googlebigquery.dsi.dataengine.utilities.OrderType;
import com.simba.googlebigquery.dsi.exceptions.ParsingException;
import com.simba.googlebigquery.dsi.utilities.DSIMessageKey;
import com.simba.googlebigquery.googlebigquery.core.BQConnection;
import com.simba.googlebigquery.googlebigquery.core.BQConnectionOptions;
import com.simba.googlebigquery.googlebigquery.core.BQDriver;
import com.simba.googlebigquery.googlebigquery.core.BQStatement;
import com.simba.googlebigquery.googlebigquery.dataengine.BQLegacyReplacer;
import com.simba.googlebigquery.googlebigquery.dataengine.BQLegacySQLExecutor;
import com.simba.googlebigquery.googlebigquery.dataengine.BQSQLExecutor;
import com.simba.googlebigquery.googlebigquery.dataengine.BQStandardReplacer;
import com.simba.googlebigquery.googlebigquery.dataengine.metadata.BQCatalogOnlyMetadataSource;
import com.simba.googlebigquery.googlebigquery.dataengine.metadata.BQCatalogSchemaOnlyMetadataSource;
import com.simba.googlebigquery.googlebigquery.dataengine.metadata.BQColumnsMetadataSource;
import com.simba.googlebigquery.googlebigquery.dataengine.metadata.BQFunctionColumnMetadataSource;
import com.simba.googlebigquery.googlebigquery.dataengine.metadata.BQFunctionsMetadataSource;
import com.simba.googlebigquery.googlebigquery.dataengine.metadata.BQTablesMetadataSource;
import com.simba.googlebigquery.googlebigquery.dataengine.metadata.BQTypeInfoMetadataSource;
import com.simba.googlebigquery.googlebigquery.dataengine.metadata.IFilterableMetadataSource;
import com.simba.googlebigquery.googlebigquery.exceptions.BQMessageKey;
import com.simba.googlebigquery.support.ILogger;
import com.simba.googlebigquery.support.JDBCEscaper;
import com.simba.googlebigquery.support.LogUtilities;
import com.simba.googlebigquery.support.exceptions.ErrorException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

public class BQDataEngine
extends DSIDataEngine {
    private final BQConnection m_connection;
    private boolean m_isDirectExecute;
    private boolean m_isMetadataNeeded;
    private final ILogger m_logger;
    private JDBCEscaper m_jdbcEscaper = new JDBCEscaper();

    public BQDataEngine(BQStatement bQStatement) {
        super(bQStatement);
        LogUtilities.logFunctionEntrance(bQStatement.getLog(), bQStatement);
        this.m_connection = (BQConnection)this.getParentStatement().getParentConnection();
        this.m_isDirectExecute = false;
        this.m_isMetadataNeeded = false;
        this.m_logger = this.m_connection.getConnectionLog();
    }

    @Override
    protected IResultSet getMetadataResultImplementation(MetadataSourceID metadataSourceID, Map<MetadataSourceColumnTag, String> map, IMetadataSource iMetadataSource, List<IFilter> list, OrderType orderType) throws ErrorException {
        if (iMetadataSource instanceof IFilterableMetadataSource) {
            ((IFilterableMetadataSource)iMetadataSource).passdownFilters(list);
        }
        return super.getMetadataResultImplementation(metadataSourceID, map, iMetadataSource, list, orderType);
    }

    @Override
    protected IMetadataSource makeNewMetadataSource(MetadataSourceID metadataSourceID, Map<MetadataSourceColumnTag, String> map, String string, String string2, boolean bl) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[]{metadataSourceID, map, string, string2, bl});
        Object object = map.entrySet().iterator();
        while (object.hasNext()) {
            Map.Entry<MetadataSourceColumnTag, String> entry = object.next();
            entry.setValue(entry.getValue().replace("\\", ""));
        }
        switch (metadataSourceID) {
            case TYPE_INFO: {
                return new BQTypeInfoMetadataSource(this.m_logger, this.m_connection.getSettings());
            }
            case CATALOG_SCHEMA_ONLY: {
                return new BQCatalogSchemaOnlyMetadataSource(this.m_logger, this.m_connection, map);
            }
            case CATALOG_ONLY: {
                return new BQCatalogOnlyMetadataSource(this.m_logger, this.m_connection, map);
            }
            case COLUMNS: {
                return new BQColumnsMetadataSource(this.m_logger, this.m_connection, map);
            }
            case TABLES: {
                return new BQTablesMetadataSource(this.m_logger, this.m_connection, map);
            }
            case TABLETYPE_ONLY: {
                object = new ArrayList();
                object.add("TABLE");
                object.add("VIEW");
                object.add("EXTERNAL");
                object.add("MATERIALIZED_VIEW");
                object.add("SNAPSHOT");
                return new DSITableTypeOnlyMetadataSource(this.m_logger, (List<String>)object);
            }
            case PROCEDURES: {
                if (map.containsKey((Object)MetadataSourceColumnTag.CATALOG_NAME) && 1 == ((String)(object = map.get((Object)MetadataSourceColumnTag.CATALOG_NAME))).length() && ((String)object).equals("%")) {
                    map.put(MetadataSourceColumnTag.CATALOG_NAME, "");
                }
                return new BQFunctionsMetadataSource(this.m_logger, this.m_connection, map, false);
            }
            case FUNCTIONS_JDBC4: {
                if (map.containsKey((Object)MetadataSourceColumnTag.CATALOG_NAME) && 1 == ((String)(object = map.get((Object)MetadataSourceColumnTag.CATALOG_NAME))).length() && ((String)object).equals("%")) {
                    map.put(MetadataSourceColumnTag.CATALOG_NAME, "");
                }
                return new BQFunctionsMetadataSource(this.m_logger, this.m_connection, map);
            }
            case PROCEDURE_COLUMNS: {
                if (map.containsKey((Object)MetadataSourceColumnTag.CATALOG_NAME) && 1 == ((String)(object = map.get((Object)MetadataSourceColumnTag.CATALOG_NAME))).length() && ((String)object).equals("%")) {
                    map.remove((Object)MetadataSourceColumnTag.CATALOG_NAME);
                }
                return new BQFunctionColumnMetadataSource(this.m_logger, this.m_connection, map, false);
            }
            case FUNCTION_COLUMNS_JDBC4: {
                if (map.containsKey((Object)MetadataSourceColumnTag.CATALOG_NAME) && 1 == ((String)(object = map.get((Object)MetadataSourceColumnTag.CATALOG_NAME))).length() && ((String)object).equals("%")) {
                    map.remove((Object)MetadataSourceColumnTag.CATALOG_NAME);
                }
                return new BQFunctionColumnMetadataSource(this.m_logger, this.m_connection, map);
            }
        }
        return new DSIEmptyMetadataSource(this.m_logger);
    }

    @Override
    public IQueryExecutor prepare(String string) throws ParsingException, ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, string);
        ArrayList<String> arrayList = new ArrayList<String>();
        if (BQConnectionOptions.QueryDialect.SQL == this.m_connection.getSettings().m_queryDialect) {
            arrayList.add(this.m_jdbcEscaper.Apply(new BQStandardReplacer(), string));
            return new BQSQLExecutor(this.m_logger, this.m_connection, arrayList, this.m_isDirectExecute, this.m_isMetadataNeeded);
        }
        if (BQConnectionOptions.QueryDialect.BIG_QUERY == this.m_connection.getSettings().m_queryDialect) {
            arrayList.add(this.m_jdbcEscaper.Apply(new BQLegacyReplacer(), string));
            return new BQLegacySQLExecutor(this.m_logger, this.m_connection, arrayList, this.m_isDirectExecute, this.m_isMetadataNeeded);
        }
        throw BQDriver.s_BQMessages.createGeneralException(BQMessageKey.CONN_OPTION_GET_ERR, new String[]{"QueryDialect"});
    }

    @Override
    public IQueryExecutor prepareBatch(List<String> list) throws ParsingException, ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (BQConnectionOptions.QueryDialect.SQL == this.m_connection.getSettings().m_queryDialect) {
            final ArrayList<String> arrayList = new ArrayList<String>();
            list.forEach(new Consumer<String>(){

                @Override
                public void accept(String string) {
                    arrayList.add(BQDataEngine.this.m_jdbcEscaper.Apply(new BQStandardReplacer(), string));
                }
            });
            return new BQSQLExecutor(this.m_logger, this.m_connection, arrayList, this.m_isDirectExecute, this.m_isMetadataNeeded);
        }
        if (BQConnectionOptions.QueryDialect.BIG_QUERY == this.m_connection.getSettings().m_queryDialect) {
            throw BQDriver.s_BQMessages.createGeneralException(DSIMessageKey.NOT_IMPLEMENTED.name());
        }
        throw BQDriver.s_BQMessages.createGeneralException(BQMessageKey.CONN_OPTION_GET_ERR, new String[]{"QueryDialect"});
    }

    @Override
    public void setDirectExecute() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.m_isDirectExecute = true;
    }

    @Override
    public void setMetadataNeeded(boolean bl) {
        LogUtilities.logFunctionEntrance(this.m_logger, bl);
        this.m_isMetadataNeeded = bl;
    }
}

