/*
 * Decompiled with CFR 0.152.
 */
package com.simba.googlebigquery.googlebigquery.core.propertyutils;

import com.simba.googlebigquery.googlebigquery.core.BQDriver;
import com.simba.googlebigquery.googlebigquery.exceptions.BQMessageKey;
import com.simba.googlebigquery.support.ILogger;
import com.simba.googlebigquery.support.LogUtilities;
import com.simba.googlebigquery.support.exceptions.ErrorException;
import com.simba.googlebigquery.support.exceptions.GeneralException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PrivateServiceConnectUris {
    private static final String DEFAULT_OAUTH2_URI = "https://oauth2.googleapis.com";
    private static final String DEFAULT_STS_URI = "https://sts.googleapis.com";
    private static final String DEFAULT_ACCOUNTS_URI = "https://accounts.google.com";
    private static final Map<String, GoogleUriEnum> s_nameToUri = PrivateServiceConnectUris.initialiseNameToUriMap();
    private static final List<String> s_validUrlNames = PrivateServiceConnectUris.initialiseValidUrlNames();
    private static final Pattern REGEX_URLS_PATTERN = Pattern.compile("^https://.+", 2);
    private static final Pattern REGEX_READ_API_URLS_PATTERN = Pattern.compile("^(?!http).+:\\d{2,}", 2);
    private final ILogger logger;
    private final Map<GoogleUriEnum, String> baseUrls;

    private static Map<GoogleUriEnum, String> initializeDefaultUris() {
        HashMap<GoogleUriEnum, String> hashMap = new HashMap<GoogleUriEnum, String>();
        hashMap.put(GoogleUriEnum.OAUTH2, DEFAULT_OAUTH2_URI);
        hashMap.put(GoogleUriEnum.STS, DEFAULT_STS_URI);
        hashMap.put(GoogleUriEnum.ACCOUNTS, DEFAULT_ACCOUNTS_URI);
        hashMap.put(GoogleUriEnum.BIGQUERY, "https://bigquery.googleapis.com/");
        hashMap.put(GoogleUriEnum.READ_API, "");
        return hashMap;
    }

    private static Map<String, GoogleUriEnum> initialiseNameToUriMap() {
        TreeMap<String, GoogleUriEnum> treeMap = new TreeMap<String, GoogleUriEnum>(String.CASE_INSENSITIVE_ORDER);
        treeMap.put(GoogleUriEnum.SERVER_NAME.name(), GoogleUriEnum.SERVER_NAME);
        treeMap.put(GoogleUriEnum.OAUTH2.name(), GoogleUriEnum.OAUTH2);
        treeMap.put(GoogleUriEnum.STS.name(), GoogleUriEnum.STS);
        treeMap.put(GoogleUriEnum.BIGQUERY.name(), GoogleUriEnum.BIGQUERY);
        treeMap.put(GoogleUriEnum.READ_API.name(), GoogleUriEnum.READ_API);
        treeMap.put(GoogleUriEnum.ACCOUNTS.name(), GoogleUriEnum.ACCOUNTS);
        return treeMap;
    }

    private static List<String> initialiseValidUrlNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (GoogleUriEnum googleUriEnum : GoogleUriEnum.values()) {
            arrayList.add(googleUriEnum.name());
        }
        return arrayList;
    }

    private static GoogleUriEnum getUriFromName(String string) throws InvalidUriNameException {
        if (!s_validUrlNames.contains(string)) {
            throw new InvalidUriNameException(string);
        }
        return s_nameToUri.get(string);
    }

    public PrivateServiceConnectUris(ILogger iLogger) {
        this.logger = iLogger;
        this.baseUrls = PrivateServiceConnectUris.initializeDefaultUris();
    }

    public void parseUris(String string) throws UriListMalformedException, ErrorException {
        String[] stringArray;
        LogUtilities.logFunctionEntrance(this.logger, string);
        if (string.isEmpty()) {
            return;
        }
        for (String string2 : stringArray = string.split(",")) {
            String[] stringArray2 = string2.split("=");
            if (stringArray2.length != 2) {
                throw new UriListMalformedException();
            }
            try {
                this.setUri(PrivateServiceConnectUris.getUriFromName(stringArray2[0]), stringArray2[1]);
            }
            catch (InvalidUriNameException invalidUriNameException) {
                LogUtilities.logWarning("Unsupported URL identifier " + invalidUriNameException.getUriName() + " (case-insensitive). Ignoring.", this.logger);
            }
        }
    }

    protected PrivateServiceConnectUris setUri(GoogleUriEnum googleUriEnum, String string) throws ErrorException {
        if (googleUriEnum == GoogleUriEnum.READ_API) {
            Matcher matcher = REGEX_READ_API_URLS_PATTERN.matcher(string);
            if (!matcher.find()) {
                throw BQDriver.s_BQMessages.createGeneralException(BQMessageKey.CONN_OPTION_GET_ERR.name(), "Read API PSC end point does not have correct value.");
            }
        } else {
            Matcher matcher = REGEX_URLS_PATTERN.matcher(string);
            if (!matcher.find()) {
                throw BQDriver.s_BQMessages.createGeneralException(BQMessageKey.CONN_OPTION_GET_ERR.name(), "PSC end point does not have correct value.");
            }
        }
        this.baseUrls.put(googleUriEnum, string);
        return this;
    }

    public String getServerNameUri() {
        return this.baseUrls.get((Object)GoogleUriEnum.SERVER_NAME);
    }

    public PrivateServiceConnectUris setServerNameUri(String string) throws ErrorException {
        return this.setUri(GoogleUriEnum.SERVER_NAME, string);
    }

    public String getOAuth2Uri() {
        return this.baseUrls.get((Object)GoogleUriEnum.OAUTH2);
    }

    public PrivateServiceConnectUris setOAuth2Uri(String string) throws ErrorException {
        return this.setUri(GoogleUriEnum.OAUTH2, string);
    }

    public String getStsUri() {
        return this.baseUrls.get((Object)GoogleUriEnum.STS);
    }

    public PrivateServiceConnectUris setStsUri(String string) throws ErrorException {
        return this.setUri(GoogleUriEnum.STS, string);
    }

    public String getBigQueryUri() {
        return this.baseUrls.get((Object)GoogleUriEnum.BIGQUERY);
    }

    public PrivateServiceConnectUris setBigQueryUri(String string) throws ErrorException {
        return this.setUri(GoogleUriEnum.BIGQUERY, string);
    }

    public String getReadApiUri() {
        return this.baseUrls.get((Object)GoogleUriEnum.READ_API);
    }

    public PrivateServiceConnectUris setReadApiUri(String string) throws ErrorException {
        return this.setUri(GoogleUriEnum.READ_API, string);
    }

    public String getAccountsUri() {
        return this.baseUrls.get((Object)GoogleUriEnum.ACCOUNTS);
    }

    public PrivateServiceConnectUris setAccountsUri(String string) throws ErrorException {
        return this.setUri(GoogleUriEnum.ACCOUNTS, string);
    }

    private static class InvalidUriNameException
    extends Exception {
        private final String uriName;

        public InvalidUriNameException(String string) {
            this.uriName = string;
        }

        public String getUriName() {
            return this.uriName;
        }
    }

    public static class UriListMalformedException
    extends GeneralException {
        private static final String ERR_KEY = "BQ_PSC_URI_LIST_MALFORMED";
        private static final String ERR_MSG = "Each property must be of the form key=value, and properties must be separated by commas (,).";

        public UriListMalformedException() {
            super(101, ERR_KEY, new String[]{ERR_MSG});
        }
    }

    static enum GoogleUriEnum {
        SERVER_NAME,
        OAUTH2,
        STS,
        BIGQUERY,
        READ_API,
        ACCOUNTS;

    }
}

