/*
 * Decompiled with CFR 0.152.
 */
package com.simba.googlebigquery.googlebigquery.core;

import com.google.api.services.bigquery.model.ConnectionProperty;
import com.simba.googlebigquery.dsi.core.impl.DSILogger;
import com.simba.googlebigquery.dsi.core.interfaces.IStatement;
import com.simba.googlebigquery.dsi.core.utilities.ConnSettingRequestMap;
import com.simba.googlebigquery.dsi.core.utilities.ConnSettingResponseMap;
import com.simba.googlebigquery.dsi.core.utilities.Variant;
import com.simba.googlebigquery.dsi.exceptions.BadAttrValException;
import com.simba.googlebigquery.dsi.exceptions.BadAuthException;
import com.simba.googlebigquery.dsi.exceptions.IncorrectTypeException;
import com.simba.googlebigquery.dsi.exceptions.NumericOverflowException;
import com.simba.googlebigquery.dsi.exceptions.UtilsException;
import com.simba.googlebigquery.googlebigquery.client.BQClient;
import com.simba.googlebigquery.googlebigquery.client.authentication.AbstractAuthentication;
import com.simba.googlebigquery.googlebigquery.client.authentication.ApplicationDefaultCredentialsAuth;
import com.simba.googlebigquery.googlebigquery.client.authentication.ExternalAccountAuth;
import com.simba.googlebigquery.googlebigquery.client.authentication.ServiceAccountAuth;
import com.simba.googlebigquery.googlebigquery.client.authentication.UserAccountInteractiveAuth;
import com.simba.googlebigquery.googlebigquery.client.authentication.UserAccountTokenAuth;
import com.simba.googlebigquery.googlebigquery.core.BQConnectionOptions;
import com.simba.googlebigquery.googlebigquery.core.BQDriver;
import com.simba.googlebigquery.googlebigquery.core.BQEnvironment;
import com.simba.googlebigquery.googlebigquery.core.BQStatement;
import com.simba.googlebigquery.googlebigquery.core.propertyutils.PrivateServiceConnectUris;
import com.simba.googlebigquery.googlebigquery.exceptions.BQMessageKey;
import com.simba.googlebigquery.googlebigquery.utils.BQCoreUtils;
import com.simba.googlebigquery.jdbc.common.ProductInfoHandler;
import com.simba.googlebigquery.jdbc.core.DSCommonConnection;
import com.simba.googlebigquery.support.ILogger;
import com.simba.googlebigquery.support.LogUtilities;
import com.simba.googlebigquery.support.Warning;
import com.simba.googlebigquery.support.WarningCode;
import com.simba.googlebigquery.support.exceptions.ErrorException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicInteger;

public class BQConnection
extends DSCommonConnection {
    private static final String LOG_PREFIX_NAME = "BigQuery_connection_";
    private static AtomicInteger s_connectionID = new AtomicInteger(0);
    private static final long DEFAULT_MAX_RESULTS = 10000L;
    private static final long DEFAULT_TIMEOUT_MILLISECONDS = 300000L;
    private static final long MINIMUM_TIMEOUT = 1L;
    private static final int DEFAULT_METADATA_FETCH_THREAD_COUNT = 32;
    private static final String GOOGLE_DRIVE_SCOPE = "https://www.googleapis.com/auth/drive";
    private BQClient m_client;
    private ILogger m_conn_logger = this.getConnectionLog();
    private BQConnectionOptions m_settings;
    private AbstractAuthentication m_authentication;

    protected BQConnection(BQEnvironment bQEnvironment) throws IncorrectTypeException, NumericOverflowException, ErrorException {
        super(bQEnvironment);
        LogUtilities.logFunctionEntrance(this.m_conn_logger, bQEnvironment);
        this.m_settings = new BQConnectionOptions();
        this.setDefaultProperties();
    }

    @Override
    protected void doReset() {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), new Object[0]);
    }

    @Override
    public void close() {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), new Object[0]);
        if ((this.m_settings.m_forceHTAPI || this.m_settings.m_enableHighThroughPutAPI) && !this.m_client.getBigQueryStorageClient().isTerminated()) {
            this.m_client.getBigQueryStorageClient().shutdown();
        }
    }

    @Override
    public void connect(ConnSettingRequestMap connSettingRequestMap) throws ErrorException, BadAuthException {
        LogUtilities.logFunctionEntrance(this.m_conn_logger, connSettingRequestMap);
        new ProductInfoHandler("SimbaJDBCDriverforGoogleBigQuery.lic", "Simba JDBC Driver for Google BigQuery", "1.3", BQDriver.class).validateLicense();
        this.m_client = new BQClient(this.m_conn_logger, this.m_settings);
        try {
            this.m_settings = this.getConnectionOptions(connSettingRequestMap);
        }
        catch (UtilsException utilsException) {
            throw BQDriver.s_BQMessages.createGeneralException(BQMessageKey.CONN_OPTION_GET_ERR.name(), utilsException.getMessage());
        }
        String string = this.m_settings.m_largeResultDataset;
        String string2 = this.m_settings.m_largeResultTable;
        BQConnectionOptions.QueryDialect queryDialect = this.m_settings.m_queryDialect;
        boolean bl = this.m_settings.m_largeResultsEnabled = this.m_settings.m_allowLargeResults && BQConnectionOptions.QueryDialect.BIG_QUERY == queryDialect || BQConnectionOptions.QueryDialect.SQL == queryDialect && (null != string || null != string2);
        if (!this.m_settings.m_largeResultsEnabled) {
            this.m_settings.m_enableHighThroughPutAPI = true;
        }
        if (!BQCoreUtils.isTimestampFallbackSet()) {
            BQCoreUtils.setTimestampFallbackValue(this.m_settings.m_timestampFallback);
            if (this.m_settings.m_timestampFallback) {
                TimeZone.setDefault(TimeZone.getTimeZone("UTC"));
            }
        } else if (BQCoreUtils.getTimestampFallbackValue() != this.m_settings.m_timestampFallback) {
            throw BQDriver.s_BQMessages.createGeneralException(BQMessageKey.CONN_TIMESTAMP_FALLBACK_MISMATCH.name());
        }
        this.m_client.authenticateAndTest(this.m_authentication, this.m_settings.m_trustStoreSettings, this.m_settings.m_proxySettings);
    }

    @Override
    public IStatement createStatement() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), new Object[0]);
        return new BQStatement(this);
    }

    @Override
    public void disconnect() {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), new Object[0]);
    }

    public BQClient getClient() {
        return this.m_client;
    }

    @Override
    public ILogger getConnectionLog() {
        if (null == this.m_conn_logger) {
            this.m_conn_logger = new DSILogger(LOG_PREFIX_NAME + s_connectionID.getAndIncrement());
            this.m_conn_logger.setLocale(this.getLocale());
        }
        return this.m_conn_logger;
    }

    public BQConnectionOptions getSettings() {
        return this.m_settings;
    }

    @Override
    public ConnSettingResponseMap updateConnectionSettings(ConnSettingRequestMap connSettingRequestMap) throws ErrorException {
        connSettingRequestMap.setHiddenKey("OAuthAccessToken", "OAuthRefreshToken", "OAuthClientId", "OAuthClientSecret", "OAuthPvtKeyPath");
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), connSettingRequestMap);
        ConnSettingResponseMap connSettingResponseMap = new ConnSettingResponseMap();
        this.verifyRequiredSetting("ProjectId", connSettingRequestMap, connSettingResponseMap);
        try {
            this.verifyOptionalSetting("OAuthType", connSettingRequestMap, connSettingResponseMap);
            if (connSettingRequestMap.containsKey("OAuthType") && BQConnectionOptions.OAuthMechanism.SERVICE_ACCOUNT.ordinal() == connSettingRequestMap.getProperty("OAuthType").getInt()) {
                this.verifyRequiredSetting("OAuthServiceAcctEmail", connSettingRequestMap, connSettingResponseMap);
                Variant variant = connSettingRequestMap.getProperty("OAuthPvtKey");
                if (null == variant || variant.getString().isEmpty()) {
                    this.verifyRequiredSetting("OAuthPvtKeyPath", connSettingRequestMap, connSettingResponseMap);
                } else {
                    this.verifyOptionalSetting("OAuthPvtKeyPath", connSettingRequestMap, connSettingResponseMap);
                }
            } else {
                this.verifyOptionalSetting("OAuthServiceAcctEmail", connSettingRequestMap, connSettingResponseMap);
                this.verifyOptionalSetting("OAuthPvtKey", connSettingRequestMap, connSettingResponseMap);
                this.verifyOptionalSetting("OAuthPvtKeyPath", connSettingRequestMap, connSettingResponseMap);
            }
            this.verifyOptionalSetting("AllowLargeResults", connSettingRequestMap, connSettingResponseMap);
            this.verifyOptionalSetting("LargeResultDataset", connSettingRequestMap, connSettingResponseMap);
            this.verifyOptionalSetting("LargeResultTable", connSettingRequestMap, connSettingResponseMap);
            this.verifyOptionalSetting("AdditionalProjects", connSettingRequestMap, connSettingResponseMap);
            this.verifyOptionalSetting("FetchThreadsPerResultSet", connSettingRequestMap, connSettingResponseMap);
            this.verifyOptionalSetting("Language", connSettingRequestMap, connSettingResponseMap);
            this.verifyOptionalSetting("MaxResults", connSettingRequestMap, connSettingResponseMap);
            this.verifyOptionalSetting("StringColumnLength", connSettingRequestMap, connSettingResponseMap);
            this.verifyOptionalSetting("Timeout", connSettingRequestMap, connSettingResponseMap);
            this.verifyOptionalSetting("OAuthAccessToken", connSettingRequestMap, connSettingResponseMap);
            this.verifyOptionalSetting("OAuthRefreshToken", connSettingRequestMap, connSettingResponseMap);
            this.verifyOptionalSetting("OAuthClientId", connSettingRequestMap, connSettingResponseMap);
            this.verifyOptionalSetting("OAuthClientSecret", connSettingRequestMap, connSettingResponseMap);
            this.verifyOptionalSetting("TimestampFallback", connSettingRequestMap, connSettingResponseMap);
            this.verifyOptionalSetting("useQueryCache", connSettingRequestMap, connSettingResponseMap);
            this.verifyOptionalSetting("ProxyHost", connSettingRequestMap, connSettingResponseMap);
            if (connSettingRequestMap.containsKey("ProxyHost")) {
                this.verifyRequiredSetting("ProxyPort", connSettingRequestMap, connSettingResponseMap);
                this.verifyOptionalSetting("ProxyUid", connSettingRequestMap, connSettingResponseMap);
                if (connSettingRequestMap.containsKey("ProxyUid")) {
                    this.verifyOptionalSetting("ProxyPwd", connSettingRequestMap, connSettingResponseMap);
                }
            }
            this.verifyOptionalSetting("KMSKeyName", connSettingRequestMap, connSettingResponseMap);
            this.verifyOptionalSetting("DefaultDataset", connSettingRequestMap, connSettingResponseMap);
            if (connSettingRequestMap.containsKey("DefaultDataset")) {
                this.verifyOptionalSetting("FilterTablesOnDefaultDataset", connSettingRequestMap, connSettingResponseMap);
            }
            this.verifyOptionalSetting("RequestGoogleDriveScope", connSettingRequestMap, connSettingResponseMap);
            this.verifyOptionalSetting("EnableHighThroughPutAPI", connSettingRequestMap, connSettingResponseMap);
            this.verifyOptionalSetting("HighThroughPutMinTableSize", connSettingRequestMap, connSettingResponseMap);
            this.verifyOptionalSetting("ForceHTAPI", connSettingRequestMap, connSettingResponseMap);
            this.verifyOptionalSetting("IgnoreTransactions", connSettingRequestMap, connSettingResponseMap);
            this.verifyOptionalSetting("LargeResultsDatasetExpirationTime", connSettingRequestMap, connSettingResponseMap);
        }
        catch (Exception exception) {
            throw BQDriver.s_BQMessages.createGeneralException(BQMessageKey.CONN_OPTION_GET_ERR, exception.getMessage());
        }
        return connSettingResponseMap;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private BQConnectionOptions getConnectionOptions(ConnSettingRequestMap connSettingRequestMap) throws UtilsException, ErrorException {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), connSettingRequestMap);
        this.m_settings.m_allowLargeResults = false;
        this.m_settings.m_enableHighThroughPutAPI = false;
        this.m_settings.m_enableSession = false;
        this.m_settings.m_fetchThreadCount = 4;
        this.m_settings.m_forceHTAPI = false;
        this.m_settings.m_highThroughPutMinTableSize = 100;
        this.m_settings.m_highThroughPutTotalRowsToFirstPageRowsRatio = 3;
        this.m_settings.m_largeResultsDatasetExpirationTime = 3600000L;
        this.m_settings.m_metadataFetchThreadCount = 32;
        this.m_settings.m_OAuthType = BQConnectionOptions.OAuthMechanism.SERVICE_ACCOUNT;
        this.m_settings.m_port = "443";
        this.m_settings.m_queryDialect = BQConnectionOptions.QueryDialect.SQL;
        this.m_settings.m_requestGoogleDriveScope = false;
        this.m_settings.m_timeout = 300000L;
        this.m_settings.m_timestampFallback = false;
        this.m_settings.m_stringColumnLength = 65535L;
        this.m_settings.m_useQueryCache = true;
        this.m_settings.m_unsupportedHTAPIFallback = true;
        this.m_settings.m_baseUrls = new PrivateServiceConnectUris(this.getConnectionLog());
        this.m_settings.m_projectId = this.getRequiredSetting("ProjectId", connSettingRequestMap).getString();
        try {
            Variant variant;
            int n;
            Object object;
            Object object2;
            String[] stringArray;
            Variant variant2;
            Variant variant3;
            Variant variant4;
            Variant variant5;
            Variant variant6;
            Variant variant7;
            Variant variant8;
            Variant variant9;
            Variant variant10;
            Variant variant11;
            Variant variant12;
            Variant variant13;
            Variant variant14;
            Object object3;
            int n2;
            Variant variant15;
            Variant variant16;
            Object object4;
            Object object5;
            Variant variant17;
            Variant variant18;
            Variant variant19 = this.getOptionalSetting("StringColumnLength", connSettingRequestMap);
            if (variant19 != null) {
                this.m_settings.m_stringColumnLength = variant19.getLong();
            }
            if ((variant18 = this.getOptionalSetting("Timeout", connSettingRequestMap)) != null) {
                try {
                    long l = variant18.getLong();
                    if (l < 1L) {
                        throw new Exception("Invalid timeout value.");
                    }
                    this.m_settings.m_timeout = l * 1000L;
                }
                catch (Exception exception) {
                    this.postOptionalValueChangedWarning("Timeout", String.valueOf(300000L));
                }
            }
            if ((variant17 = this.getOptionalSetting("MaxResults", connSettingRequestMap)) != null && variant17.getLong() > 0L) {
                this.m_settings.m_maxResults = variant17.getLong();
            } else {
                this.m_settings.m_maxResults = 10000L;
                this.postOptionalValueChangedWarning("MaxResults", String.valueOf(10000L));
            }
            Variant variant20 = this.getOptionalSetting("SSLTrustStore", connSettingRequestMap);
            if (variant20 != null) {
                object5 = new BQConnectionOptions.TrustStoreSettings();
                ((BQConnectionOptions.TrustStoreSettings)object5).m_trustStore = variant20.getString();
                object4 = this.getRequiredSetting("SSLTrustStorePwd", connSettingRequestMap);
                ((BQConnectionOptions.TrustStoreSettings)object5).m_trustStorePwd = null != object4 ? ((Variant)object4).getString() : "";
                this.m_settings.m_trustStoreSettings = object5;
            }
            if ((object5 = this.getOptionalSetting("ProxyHost", connSettingRequestMap)) != null) {
                object4 = new BQConnectionOptions.ProxySettings();
                ((BQConnectionOptions.ProxySettings)object4).m_host = ((Variant)object5).getString();
                variant16 = this.getRequiredSetting("ProxyPort", connSettingRequestMap);
                if (variant16 != null) {
                    ((BQConnectionOptions.ProxySettings)object4).m_port = variant16.getInt();
                }
                if ((variant15 = this.getOptionalSetting("ProxyUid", connSettingRequestMap)) != null) {
                    ((BQConnectionOptions.ProxySettings)object4).m_uid = variant15.getString();
                    Variant variant21 = this.getOptionalSetting("ProxyPwd", connSettingRequestMap);
                    if (variant21 != null) {
                        ((BQConnectionOptions.ProxySettings)object4).m_pwd = variant21.getString();
                    }
                }
                this.m_settings.m_proxySettings = object4;
            }
            if ((object4 = this.getOptionalSetting("RootURL", connSettingRequestMap)) != null) {
                this.m_settings.m_baseUrls.setBigQueryUri(((Variant)object4).getString());
            }
            if ((variant16 = this.getOptionalSetting("HighThroughputRootURL", connSettingRequestMap)) != null) {
                this.m_settings.m_baseUrls.setReadApiUri(variant16.getString());
            }
            if ((variant15 = this.getOptionalSetting("PrivateServiceConnectUris", connSettingRequestMap)) != null) {
                this.m_settings.m_baseUrls.parseUris(variant15.getString());
            }
            if ((n2 = this.getRequiredSetting("OAuthType", connSettingRequestMap).getInt()) < 0 || n2 >= BQConnectionOptions.OAuthMechanism.values().length) {
                throw new IllegalArgumentException("OAuthType");
            }
            this.m_settings.m_OAuthType = BQConnectionOptions.OAuthMechanism.values()[n2];
            Variant variant22 = this.getOptionalSetting("RequestGoogleDriveScope", connSettingRequestMap);
            if (variant22 != null) {
                int n3 = variant22.getInt();
                if (n3 == 0) {
                    this.m_settings.m_requestGoogleDriveScope = false;
                } else {
                    if (n3 != 1) throw new IllegalArgumentException("RequestGoogleDriveScope");
                    this.m_settings.m_requestGoogleDriveScope = true;
                }
            }
            switch (this.m_settings.m_OAuthType) {
                case SERVICE_ACCOUNT: {
                    ServiceAccountAuth serviceAccountAuth = new ServiceAccountAuth(this.m_settings.m_proxySettings, this.m_settings.m_trustStoreSettings);
                    if (this.m_settings.m_requestGoogleDriveScope) {
                        serviceAccountAuth.addScope(GOOGLE_DRIVE_SCOPE);
                    }
                    serviceAccountAuth.setEmail(this.getRequiredSetting("OAuthServiceAcctEmail", connSettingRequestMap).getString());
                    object3 = null;
                    Variant variant23 = this.getOptionalSetting("OAuthPvtKey", connSettingRequestMap);
                    if (variant23 != null) {
                        object3 = variant23.getString();
                        variant14 = this.getOptionalSetting("OAuthPvtKeyPath", connSettingRequestMap);
                        if (variant14 != null) {
                            this.getWarningListener().postWarning(new Warning(WarningCode.UNUSED, 101, BQMessageKey.CONN_PROP_VALUE_UNUSED.name(), new String[]{"OAuthPvtKeyPath"}));
                        }
                    }
                    if (null == object3 || ((String)object3).isEmpty()) {
                        variant14 = this.getRequiredSetting("OAuthPvtKeyPath", connSettingRequestMap);
                        object3 = variant14.getString();
                    }
                    serviceAccountAuth.readKeyFile((String)object3);
                    this.m_authentication = serviceAccountAuth;
                    break;
                }
                case USER_ACCOUNT: {
                    UserAccountInteractiveAuth userAccountInteractiveAuth = new UserAccountInteractiveAuth(this.m_settings.m_baseUrls, this.m_settings.m_trustStoreSettings, this.m_settings.m_proxySettings);
                    if (this.m_settings.m_requestGoogleDriveScope) {
                        userAccountInteractiveAuth.addScope(GOOGLE_DRIVE_SCOPE);
                    }
                    if ((object3 = this.getOptionalSetting("OAuthClientId", connSettingRequestMap)) != null) {
                        userAccountInteractiveAuth.setClientId(((Variant)object3).getString());
                    } else {
                        userAccountInteractiveAuth.setClientId("977385342095.apps.googleusercontent.com");
                    }
                    Variant variant23 = this.getOptionalSetting("OAuthClientSecret", connSettingRequestMap);
                    if (variant23 != null) {
                        userAccountInteractiveAuth.setClientSecret(variant23.getString());
                    } else {
                        userAccountInteractiveAuth.setClientSecret("wbER7576mc_1YOII0dGk7jEE");
                    }
                    this.m_authentication = userAccountInteractiveAuth;
                    break;
                }
                case TOKEN: {
                    Variant variant23;
                    UserAccountTokenAuth userAccountTokenAuth = new UserAccountTokenAuth(this.m_settings.m_baseUrls, this.m_settings.m_trustStoreSettings, this.m_settings.m_proxySettings);
                    object3 = this.getOptionalSetting("OAuthAccessToken", connSettingRequestMap);
                    if (object3 != null) {
                        userAccountTokenAuth.setAccessToken(((Variant)object3).getString());
                    }
                    if ((variant23 = this.getOptionalSetting("OAuthRefreshToken", connSettingRequestMap)) != null) {
                        userAccountTokenAuth.setRefreshToken(variant23.getString());
                    }
                    if ((variant14 = this.getOptionalSetting("OAuthClientId", connSettingRequestMap)) != null) {
                        userAccountTokenAuth.setClientId(variant14.getString());
                    } else {
                        userAccountTokenAuth.setClientId("977385342095.apps.googleusercontent.com");
                    }
                    variant13 = this.getOptionalSetting("OAuthClientSecret", connSettingRequestMap);
                    if (variant13 != null) {
                        userAccountTokenAuth.setClientSecret(variant13.getString());
                    } else {
                        userAccountTokenAuth.setClientSecret("wbER7576mc_1YOII0dGk7jEE");
                    }
                    this.m_authentication = userAccountTokenAuth;
                    break;
                }
                case APPLICATION_DEFAULT_CREDENTIALS: {
                    ApplicationDefaultCredentialsAuth applicationDefaultCredentialsAuth = new ApplicationDefaultCredentialsAuth(this.m_settings.m_proxySettings, this.m_settings.m_trustStoreSettings);
                    if (this.m_settings.m_requestGoogleDriveScope) {
                        applicationDefaultCredentialsAuth.addScope(GOOGLE_DRIVE_SCOPE);
                    }
                    this.m_authentication = applicationDefaultCredentialsAuth;
                    break;
                }
                case EXTERNAL_ACCOUNT: {
                    ExternalAccountAuth externalAccountAuth = new ExternalAccountAuth(this.m_settings.m_proxySettings, this.m_settings.m_trustStoreSettings);
                    if (this.m_settings.m_requestGoogleDriveScope) {
                        externalAccountAuth.addScope(GOOGLE_DRIVE_SCOPE);
                    }
                    object3 = null;
                    Variant variant23 = this.getOptionalSetting("OAuthPvtKey", connSettingRequestMap);
                    if (null != variant23) {
                        object3 = variant23.getString();
                        variant14 = this.getOptionalSetting("OAuthPvtKeyPath", connSettingRequestMap);
                        if (variant14 != null) {
                            this.getWarningListener().postWarning(new Warning(WarningCode.UNUSED, 101, BQMessageKey.CONN_PROP_VALUE_UNUSED.name(), new String[]{"OAuthPvtKeyPath"}));
                        }
                    }
                    if ((null == object3 || ((String)object3).isEmpty()) && null != (variant14 = this.getOptionalSetting("OAuthPvtKeyPath", connSettingRequestMap))) {
                        object3 = variant14.getString();
                    }
                    if (null != object3 && !((String)object3).isEmpty()) {
                        externalAccountAuth.parseConfiguration((String)object3);
                    } else {
                        variant14 = this.getRequiredSetting("BYOID_AudienceUri", connSettingRequestMap);
                        variant13 = this.getRequiredSetting("BYOID_CredentialSource", connSettingRequestMap);
                        variant12 = this.getOptionalSetting("BYOID_PoolUserProject", connSettingRequestMap);
                        variant11 = this.getOptionalSetting("BYOID_SubjectTokenType", connSettingRequestMap);
                        variant10 = this.getOptionalSetting("BYOID_TokenUri", connSettingRequestMap);
                        variant9 = this.getOptionalSetting("BYOID_SA_Impersonation_Uri", connSettingRequestMap);
                        if (null == variant14 || null == variant13) throw new IllegalArgumentException("External Account Information(key file or BYOID details)");
                        externalAccountAuth.setAudience(variant14.getString()).setCredentialSource(variant13.getString());
                        if (null != variant12) {
                            externalAccountAuth.setPoolProject(variant12.getString());
                        }
                        if (null != variant9) {
                            externalAccountAuth.setImpersonationUri(variant9.getString());
                        }
                        if (null != variant11) {
                            externalAccountAuth.setTokenType(variant11.getString());
                        }
                        if (null != variant10) {
                            externalAccountAuth.setTokenUri(variant10.getString());
                        }
                    }
                    if (null == externalAccountAuth.getTokenUri() || externalAccountAuth.getTokenUri().isEmpty()) {
                        externalAccountAuth.setTokenUri(this.m_settings.m_baseUrls.getStsUri());
                    }
                    this.m_authentication = externalAccountAuth;
                    break;
                }
            }
            Variant variant24 = this.getOptionalSetting("QueryDialect", connSettingRequestMap);
            if (variant24 != null) {
                object3 = variant24.getString();
                if (BQConnectionOptions.QueryDialect.BIG_QUERY.toString().equals(object3)) {
                    this.m_settings.m_queryDialect = BQConnectionOptions.QueryDialect.BIG_QUERY;
                } else {
                    if (!BQConnectionOptions.QueryDialect.SQL.toString().equals(object3)) throw new IllegalArgumentException("QueryDialect");
                    this.m_settings.m_queryDialect = BQConnectionOptions.QueryDialect.SQL;
                }
            }
            if ((object3 = this.getOptionalSetting("AllowLargeResults", connSettingRequestMap)) != null) {
                int n4 = ((Variant)object3).getInt();
                if (n4 == 0) {
                    this.m_settings.m_allowLargeResults = false;
                } else {
                    if (n4 != 1) throw new IllegalArgumentException("AllowLargeResults");
                    this.m_settings.m_allowLargeResults = true;
                }
            }
            if ((variant8 = this.getOptionalSetting("LargeResultDataset", connSettingRequestMap)) != null) {
                this.m_settings.m_largeResultDataset = variant8.getString();
            }
            if ((variant14 = this.getOptionalSetting("LargeResultTable", connSettingRequestMap)) != null) {
                this.m_settings.m_largeResultTable = variant14.getString();
            }
            if ((variant13 = this.getOptionalSetting("AdditionalProjects", connSettingRequestMap)) != null) {
                this.m_settings.m_additionalProjects = variant13.getString();
            }
            if ((variant12 = this.getOptionalSetting("FetchThreadsPerResultSet", connSettingRequestMap)) != null) {
                this.m_settings.m_fetchThreadCount = variant12.getInt();
            }
            if (null != (variant11 = this.getOptionalSetting("TimestampFallback", connSettingRequestMap))) {
                int n5 = variant11.getInt();
                if (0 == n5) {
                    this.m_settings.m_timestampFallback = false;
                } else {
                    if (1 != n5) throw new IllegalArgumentException("TimestampFallback");
                    this.m_settings.m_timestampFallback = true;
                }
            }
            if ((variant10 = this.getOptionalSetting("useQueryCache", connSettingRequestMap)) != null) {
                int n6 = variant10.getInt();
                if (n6 == 0) {
                    this.m_settings.m_useQueryCache = false;
                } else {
                    if (n6 != 1) throw new IllegalArgumentException("useQueryCache");
                    this.m_settings.m_useQueryCache = true;
                }
            }
            this.setProperty(22, new Variant(0, this.m_settings.m_projectId));
            if (BQConnectionOptions.QueryDialect.BIG_QUERY == this.m_settings.m_queryDialect) {
                this.setProperty(58, new Variant(""));
            }
            if ((variant9 = this.getOptionalSetting("DefaultDataset", connSettingRequestMap)) != null) {
                this.m_settings.m_defaultDataSet = variant9.getString();
            }
            if (null != this.m_settings.m_defaultDataSet) {
                variant7 = this.getOptionalSetting("FilterTablesOnDefaultDataset", connSettingRequestMap);
                if (variant7 != null) {
                    int n7 = variant7.getInt();
                    if (n7 == 0) {
                        this.m_settings.m_filterTablesOnDefaultDataset = false;
                    } else {
                        if (n7 != 1) throw new IllegalArgumentException("FilterTablesOnDefaultDataset");
                        this.m_settings.m_filterTablesOnDefaultDataset = true;
                    }
                }
            } else {
                this.m_settings.m_filterTablesOnDefaultDataset = false;
            }
            if ((variant7 = this.getOptionalSetting("KMSKeyName", connSettingRequestMap)) != null) {
                this.m_settings.m_KMSKeyName = variant7.getString();
            }
            if (null != (variant6 = this.getOptionalSetting("EnableHighThroughPutAPI", connSettingRequestMap))) {
                int n8 = variant6.getInt();
                if (n8 == 0) {
                    this.m_settings.m_enableHighThroughPutAPI = false;
                } else if (n8 == 1) {
                    this.m_settings.m_enableHighThroughPutAPI = true;
                }
            }
            if (null != (variant5 = this.getOptionalSetting("HighThroughPutMinTableSize", connSettingRequestMap))) {
                this.m_settings.m_highThroughPutMinTableSize = variant5.getInt();
            }
            if (null != (variant4 = this.getOptionalSetting("ForceHTAPI", connSettingRequestMap))) {
                int n9 = variant4.getInt();
                if (n9 == 0) {
                    this.m_settings.m_forceHTAPI = false;
                } else if (n9 == 1) {
                    this.m_settings.m_forceHTAPI = true;
                    this.m_settings.m_enableHighThroughPutAPI = true;
                }
            }
            if (null != (variant3 = this.getOptionalSetting("HighThroughPutActivationRatio", connSettingRequestMap))) {
                this.m_settings.m_highThroughPutTotalRowsToFirstPageRowsRatio = variant3.getInt();
            }
            if (null != (variant2 = this.getOptionalSetting("LargeResultsDatasetExpirationTime", connSettingRequestMap))) {
                this.m_settings.m_largeResultsDatasetExpirationTime = variant2.getLong();
            }
            this.m_settings.m_queryProperties = new ArrayList<ConnectionProperty>();
            Variant variant25 = this.getOptionalSetting("QueryProperties", connSettingRequestMap);
            if (null != variant25) {
                stringArray = variant25.getString().replaceAll("^\"|\"$", "").split(",");
                object2 = new HashSet();
                object = stringArray;
                int n10 = ((String[])object).length;
                for (n = 0; n < n10; ++n) {
                    String string = object[n];
                    String[] stringArray2 = string.split("=");
                    if (stringArray2.length != 2) {
                        throw BQDriver.s_BQMessages.createGeneralException(BQMessageKey.BQ_QUERYPROPERTIES_MALFORMED.name(), "Each property must be of the form key=value, and properties must be separated by commas (,).");
                    }
                    if (object2.contains(stringArray2[0])) {
                        throw BQDriver.s_BQMessages.createGeneralException(BQMessageKey.BQ_QUERYPROPERTIES_DUPLICATEPROPERTY.name(), stringArray2[0]);
                    }
                    ConnectionProperty connectionProperty = new ConnectionProperty();
                    connectionProperty.setKey(stringArray2[0]);
                    connectionProperty.setValue(stringArray2[1]);
                    object2.add(stringArray2[0]);
                    this.m_settings.m_queryProperties.add(connectionProperty);
                }
            }
            this.m_settings.m_location = null != (stringArray = this.getOptionalSetting("Location", connSettingRequestMap)) ? stringArray.getString() : "";
            object2 = this.getOptionalSetting("IgnoreTransactions", connSettingRequestMap);
            if (null != object2 && 1 == ((Variant)object2).getInt()) {
                this.fakeTransactionSupport('\u0002');
            }
            if ((object = this.getOptionalSetting("MetaDataFetchThreadCount", connSettingRequestMap)) != null && 0 < ((Variant)object).getInt()) {
                this.m_settings.m_metadataFetchThreadCount = ((Variant)object).getInt();
            } else {
                this.m_settings.m_metadataFetchThreadCount = 32;
                this.postOptionalValueChangedWarning("MetaDataFetchThreadCount", String.valueOf(32));
            }
            Variant variant26 = this.getOptionalSetting("EnableSession", connSettingRequestMap);
            if (null != variant26) {
                n = variant26.getInt();
                if (n == 0) {
                    this.m_settings.m_enableSession = false;
                } else {
                    if (n != 1) throw new IllegalArgumentException("EnableSession");
                    this.m_settings.m_enableSession = true;
                }
            }
            if (null == (variant = this.getOptionalSetting("UnsupportedHTAPIFallback", connSettingRequestMap))) return this.m_settings;
            this.m_settings.m_unsupportedHTAPIFallback = variant.getInt() > 0;
            return this.m_settings;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw BQDriver.s_BQMessages.createGeneralException(BQMessageKey.CONN_OPTION_GET_ERR, illegalArgumentException.getMessage());
        }
    }

    private void setDefaultProperties() throws BadAttrValException, IncorrectTypeException, NumericOverflowException, ErrorException {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), new Object[0]);
        this.setProperty(22, new Variant(0, this.m_settings.m_projectId));
        this.setProperty(1, new Variant(0, "N"));
        this.setProperty(40, new Variant(0, "N"));
        this.setProperty(16, new Variant(3, 0L));
        this.setProperty(11, new Variant(0, "Project"));
        this.setProperty(28, new Variant(2, Character.valueOf('\u0002')));
        this.setProperty(43, new Variant(3, 4L));
        this.setProperty(41, new Variant(0, "Google BigQuery"));
        this.setProperty(42, new Variant(0, "2.0"));
        this.setProperty(66, new Variant(2, Character.valueOf('\u0080')));
        this.setProperty(68, new Variant(2, Character.valueOf('\u0080')));
        this.setProperty(81, new Variant(2, Character.valueOf('\u0400')));
        this.setProperty(73, new Variant(2, Character.valueOf('\u2710')));
        this.setProperty(83, new Variant(2, Character.valueOf('\u0400')));
        this.setProperty(84, new Variant(2, Character.valueOf('\u03e8')));
        this.setProperty(58, new Variant(0, "`"));
        this.setProperty(99, new Variant(0, "Dataset"));
        this.setProperty(101, new Variant(0, "Google BigQuery"));
        this.setProperty(97, new Variant(0, "Y"));
        this.setProperty(27, new Variant(3, 2L));
        this.setProperty(92, new Variant(3, 39L));
        this.setProperty(106, new Variant(3, 20864L));
        this.setProperty(108, new Variant(3, 20736L));
        this.setProperty(127, new Variant(3, 153984L));
        this.setProperty(113, new Variant(3, 16768L));
        this.setProperty(124, new Variant(3, 33024L));
        this.setProperty(126, new Variant(3, 2304L));
        this.setProperty(111, new Variant(3, 0L));
        this.setProperty(123, new Variant(3, 0L));
        this.setProperty(107, new Variant(3, 0L));
        this.setProperty(109, new Variant(3, 0L));
        this.setProperty(110, new Variant(3, 0L));
        this.setProperty(112, new Variant(3, 0L));
        this.setProperty(114, new Variant(3, 0L));
        this.setProperty(115, new Variant(3, 0L));
        this.setProperty(116, new Variant(3, 0L));
        this.setProperty(117, new Variant(3, 0L));
        this.setProperty(118, new Variant(3, 0L));
        this.setProperty(119, new Variant(3, 0L));
        this.setProperty(120, new Variant(3, 0L));
        this.setProperty(121, new Variant(3, 0L));
        this.setProperty(122, new Variant(3, 0L));
        this.setProperty(125, new Variant(3, 0L));
        this.setProperty(128, new Variant(3, 0L));
        this.setProperty(129, new Variant(3, 0L));
        this.setProperty(130, new Variant(3, 0L));
        this.setProperty(104, new Variant(3, 0x7C7FFFL));
        this.setProperty(90, new Variant(3, 0x7FFFFFL));
        this.setProperty(135, new Variant(3, 0x1FFFFFL));
        this.setProperty(131, new Variant(3, 0L));
        this.setProperty(134, new Variant(3, 0L));
        this.setProperty(133, new Variant(3, 0L));
        this.setProperty(1012, new Variant(2, Character.valueOf('\u0001')));
        this.setProperty(86, new Variant(0, "Y"));
        this.setProperty(136, new Variant(2, Character.valueOf('\u0001')));
        this.setProperty(1000, new Variant(5, (short)0));
        this.setProperty(137, new Variant(7, 8L));
        this.setProperty(45, new Variant(7, 8L));
        this.setProperty(26, new Variant(7, 8L));
    }

    private void postOptionalValueChangedWarning(String string, String string2) {
        this.getWarningListener().postWarning(new Warning(WarningCode.OPTIONAL_VALUE_CHANGED, 101, BQMessageKey.CONN_PROP_OPTIONAL_VALUE_CHANGED.name(), new String[]{string, string2}));
        String string3 = "Invalid value provided for " + string + ", defaulting to " + string2 + ".";
        LogUtilities.logTrace(string3, this.getConnectionLog());
    }

    @Override
    public void beginTransaction() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), new Object[0]);
        if (!this.m_ignoreTransactions) {
            this.m_client.beginTransaction(this.getSettings());
        }
    }

    @Override
    public void commit() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), new Object[0]);
        if (!this.m_ignoreTransactions) {
            this.m_client.commitTransaction(this.getSettings());
        }
    }

    @Override
    public void rollback() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), new Object[0]);
        if (!this.m_ignoreTransactions) {
            this.m_client.rollbackTransaction(this.getSettings());
        }
    }
}

