/*
 * Decompiled with CFR 0.152.
 */
package com.simba.googlebigquery.googlebigquery.client.requests.tables;

import com.google.api.services.bigquery.Bigquery;
import com.google.api.services.bigquery.model.TableList;
import com.simba.googlebigquery.googlebigquery.client.exceptions.TableOperationsErrorException;
import com.simba.googlebigquery.googlebigquery.client.requests.AbstractRequestWithRetry;
import com.simba.googlebigquery.support.ILogger;
import com.simba.googlebigquery.support.LogUtilities;
import com.simba.googlebigquery.support.exceptions.ErrorException;

public class TablesListRequest
extends AbstractRequestWithRetry<TableList> {
    private String projectId;
    private String datasetId;
    private String pageToken;

    public TablesListRequest(ILogger iLogger, long l, Bigquery bigquery) {
        super(iLogger, l, bigquery);
    }

    @Override
    public TableList execute() throws Exception {
        TableList tableList = (TableList)this.getBigQueryClient().tables().list(this.getProjectId(), this.getDatasetId()).setPageToken(this.getPageToken()).execute();
        LogUtilities.logDebug(String.format("executed request tables.list for project %s and dataset %s. total tables:%d, next page token:%s", this.getProjectId(), this.getDatasetId(), tableList.getTables() == null ? 0 : tableList.getTables().size(), tableList.getNextPageToken()), this.getLogger());
        return tableList;
    }

    @Override
    public void throwException(Exception exception) throws ErrorException {
        throw new TableOperationsErrorException(exception);
    }

    public String getProjectId() {
        return this.projectId;
    }

    public TablesListRequest setProjectId(String string) {
        this.projectId = string;
        return this;
    }

    public String getDatasetId() {
        return this.datasetId;
    }

    public TablesListRequest setDatasetId(String string) {
        this.datasetId = string;
        return this;
    }

    public String getPageToken() {
        return this.pageToken;
    }

    public TablesListRequest setPageToken(String string) {
        this.pageToken = string;
        return this;
    }
}

