/*
 * Decompiled with CFR 0.152.
 */
package com.simba.googlebigquery.googlebigquery.client.requests.routines;

import com.google.api.services.bigquery.Bigquery;
import com.google.api.services.bigquery.model.ListRoutinesResponse;
import com.simba.googlebigquery.googlebigquery.client.exceptions.FunctionOperationsErrorException;
import com.simba.googlebigquery.googlebigquery.client.requests.AbstractRequestWithRetry;
import com.simba.googlebigquery.support.ILogger;
import com.simba.googlebigquery.support.LogUtilities;
import com.simba.googlebigquery.support.exceptions.ErrorException;

public class RoutinesListRequest
extends AbstractRequestWithRetry<ListRoutinesResponse> {
    private static final long ROUTINESLIST_MAXRESULTS = 1000L;
    private static final String ROUTINESLIST_READMASK_MASKS_DEFAULT = "routineReference,arguments,returnType";
    private String projectId;
    private String datasetId;
    private String pageToken;
    private String typeFilter;
    private long maxResults = 1000L;

    public RoutinesListRequest(ILogger iLogger, long l, Bigquery bigquery) {
        super(iLogger, l, bigquery);
    }

    @Override
    public ListRoutinesResponse execute() throws Exception {
        Bigquery.Routines.List list = this.getBigQueryClient().routines().list(this.getProjectId(), this.getDatasetId()).setMaxResults(Long.valueOf(this.getMaxResults())).setPageToken(this.getPageToken()).setReadMask(this.getReadMask());
        if (null != this.getTypeFilter() && !this.getTypeFilter().isEmpty()) {
            list.setFilter(this.getTypeFilter());
        }
        ListRoutinesResponse listRoutinesResponse = (ListRoutinesResponse)list.execute();
        LogUtilities.logDebug(String.format("executed request routines.list for project %s and dataset %s. total routines:%d, next page token:%s", this.getProjectId(), this.getDatasetId(), listRoutinesResponse.getRoutines() == null ? 0 : listRoutinesResponse.getRoutines().size(), listRoutinesResponse.getNextPageToken()), this.getLogger());
        return listRoutinesResponse;
    }

    @Override
    public void throwException(Exception exception) throws ErrorException {
        throw new FunctionOperationsErrorException(exception);
    }

    public String getProjectId() {
        return this.projectId;
    }

    public RoutinesListRequest setProjectId(String string) {
        this.projectId = string;
        return this;
    }

    public String getDatasetId() {
        return this.datasetId;
    }

    public RoutinesListRequest setDatasetId(String string) {
        this.datasetId = string;
        return this;
    }

    public String getPageToken() {
        return this.pageToken;
    }

    public RoutinesListRequest setPageToken(String string) {
        this.pageToken = string;
        return this;
    }

    public String getReadMask() {
        return ROUTINESLIST_READMASK_MASKS_DEFAULT;
    }

    public String getTypeFilter() {
        return this.typeFilter;
    }

    public RoutinesListRequest setTypeFilter(String string) {
        this.typeFilter = string;
        return this;
    }

    public long getMaxResults() {
        return this.maxResults;
    }

    public RoutinesListRequest setMaxResults(long l) {
        this.maxResults = Math.min(l, 1000L);
        return this;
    }
}

