/*
 * Decompiled with CFR 0.152.
 */
package com.simba.googlebigquery.googlebigquery.client.requests.projects;

import com.google.api.services.bigquery.Bigquery;
import com.google.api.services.bigquery.model.ProjectList;
import com.simba.googlebigquery.googlebigquery.client.exceptions.ProjectOperationsErrorException;
import com.simba.googlebigquery.googlebigquery.client.requests.AbstractRequestWithRetry;
import com.simba.googlebigquery.support.ILogger;
import com.simba.googlebigquery.support.LogUtilities;
import com.simba.googlebigquery.support.exceptions.ErrorException;

public class ProjectsListRequest
extends AbstractRequestWithRetry<ProjectList> {
    private String pageToken;
    private long maxResults;

    public ProjectsListRequest(ILogger iLogger, long l, Bigquery bigquery) {
        super(iLogger, l, bigquery);
    }

    @Override
    public ProjectList execute() throws Exception {
        ProjectList projectList;
        LogUtilities.logFunctionEntrance(this.getLogger(), String.format("listing projects. maxResult:%d, Page token:%s", this.maxResults == 0L ? null : Long.valueOf(this.maxResults), this.getPageToken()));
        Bigquery.Projects.List list = this.getBigQueryClient().projects().list().setPageToken(this.getPageToken());
        if (this.maxResults != 0L) {
            list.setMaxResults(Long.valueOf(this.maxResults));
        }
        if (null == (projectList = (ProjectList)list.execute()) || projectList.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("projects.list returned 0 projects.");
            if (null != projectList && (null == projectList.getNextPageToken() || projectList.getNextPageToken().isEmpty())) {
                stringBuilder.append("\t").append("The nextPageToken for sent request: ").append(projectList.getNextPageToken()).append(". ").append("The previous call returned an invalid page token.");
            }
            if (null != projectList && null != projectList.getNextPageToken() && !projectList.getNextPageToken().isEmpty()) {
                stringBuilder.append("\t").append("The nextPageToken from received response: ").append(projectList.getNextPageToken()).append(". ").append("Projects are still expected, but none were returned.");
            }
            LogUtilities.logTrace(stringBuilder.toString(), this.getLogger());
        }
        LogUtilities.logDebug(String.format("executed request projects.list. total projects:%d, next page token:%s", projectList.getProjects() == null ? 0 : projectList.getProjects().size(), projectList.getNextPageToken()), this.getLogger());
        return projectList;
    }

    @Override
    public void throwException(Exception exception) throws ErrorException {
        throw new ProjectOperationsErrorException(exception.getMessage());
    }

    public String getPageToken() {
        return this.pageToken;
    }

    public ProjectsListRequest setPageToken(String string) {
        this.pageToken = string;
        return this;
    }

    public long getMaxResults() {
        return this.maxResults;
    }

    public ProjectsListRequest setMaxResults(long l) {
        this.maxResults = l;
        return this;
    }
}

