/*
 * Decompiled with CFR 0.152.
 */
package com.simba.googlebigquery.googlebigquery.client.requests.jobs;

import com.google.api.client.googleapis.json.GoogleJsonResponseException;
import com.google.api.services.bigquery.Bigquery;
import com.google.api.services.bigquery.model.QueryRequest;
import com.google.api.services.bigquery.model.QueryResponse;
import com.simba.googlebigquery.googlebigquery.client.exceptions.JobExecutionErrorException;
import com.simba.googlebigquery.googlebigquery.client.requests.AbstractRequestWithRetry;
import com.simba.googlebigquery.support.ILogger;
import com.simba.googlebigquery.support.LogUtilities;
import com.simba.googlebigquery.support.exceptions.ErrorException;
import java.net.SocketTimeoutException;

public class JobsQueryRequest
extends AbstractRequestWithRetry<QueryResponse> {
    private String projectId;
    private QueryRequest job;

    public JobsQueryRequest(ILogger iLogger, long l, Bigquery bigquery) {
        super(iLogger, l, bigquery);
    }

    @Override
    public QueryResponse execute() throws Exception {
        QueryResponse queryResponse = (QueryResponse)this.getBigQueryClient().jobs().query(this.getProjectId(), this.getJob()).execute();
        LogUtilities.logInfo(String.format("executed request jobs.query. id:%s .", queryResponse.getJobReference().getJobId()), this.getLogger());
        return queryResponse;
    }

    @Override
    public void throwException(Exception exception) throws ErrorException {
        throw new JobExecutionErrorException(this.parseErrorMessage(exception.getMessage()), exception);
    }

    @Override
    protected boolean shouldRetry(int n) {
        GoogleJsonResponseException googleJsonResponseException;
        if (null != this.getLastError() && this.getLastError() instanceof SocketTimeoutException) {
            return false;
        }
        if (null != this.getLastError() && this.getLastError() instanceof GoogleJsonResponseException && null != (googleJsonResponseException = (GoogleJsonResponseException)((Object)this.getLastError())).getDetails() && 400 == googleJsonResponseException.getDetails().getCode()) {
            return false;
        }
        return super.shouldRetry(n);
    }

    public String getProjectId() {
        return this.projectId;
    }

    public JobsQueryRequest setProjectId(String string) {
        this.projectId = string;
        return this;
    }

    public QueryRequest getJob() {
        return this.job;
    }

    public JobsQueryRequest setJob(QueryRequest queryRequest) {
        this.job = queryRequest;
        return this;
    }
}

