/*
 * Decompiled with CFR 0.152.
 */
package com.simba.googlebigquery.googlebigquery.client.requests.jobs;

import com.google.api.services.bigquery.Bigquery;
import com.google.api.services.bigquery.model.JobList;
import com.simba.googlebigquery.googlebigquery.client.exceptions.JobExecutionErrorException;
import com.simba.googlebigquery.googlebigquery.client.requests.AbstractRequestWithRetry;
import com.simba.googlebigquery.support.ILogger;
import com.simba.googlebigquery.support.LogUtilities;
import com.simba.googlebigquery.support.exceptions.ErrorException;

public class JobsListRequest
extends AbstractRequestWithRetry<JobList> {
    private String projectId;
    private String parentJobId;
    private String pageToken;
    private long maxResults;

    public JobsListRequest(ILogger iLogger, long l, Bigquery bigquery) {
        super(iLogger, l, bigquery);
    }

    @Override
    public JobList execute() throws Exception {
        Bigquery.Jobs.List list = this.getBigQueryClient().jobs().list(this.getProjectId()).setPageToken(this.getPageToken()).setMaxResults(Long.valueOf(this.getMaxResults()));
        if (null != this.getParentJobId() && !this.getParentJobId().isEmpty()) {
            list.setParentJobId(this.getParentJobId());
        }
        JobList jobList = (JobList)list.execute();
        LogUtilities.logInfo(String.format("executed request jobs.list. parent job Id:%s .", this.getParentJobId()), this.getLogger());
        return jobList;
    }

    @Override
    public void throwException(Exception exception) throws ErrorException {
        throw new JobExecutionErrorException(exception);
    }

    public String getProjectId() {
        return this.projectId;
    }

    public JobsListRequest setProjectId(String string) {
        this.projectId = string;
        return this;
    }

    public String getParentJobId() {
        return this.parentJobId;
    }

    public JobsListRequest setParentJobId(String string) {
        this.parentJobId = string;
        return this;
    }

    public String getPageToken() {
        return this.pageToken;
    }

    public JobsListRequest setPageToken(String string) {
        this.pageToken = string;
        return this;
    }

    public long getMaxResults() {
        return this.maxResults;
    }

    public JobsListRequest setMaxResults(long l) {
        this.maxResults = l;
        return this;
    }
}

