/*
 * Decompiled with CFR 0.152.
 */
package com.simba.googlebigquery.googlebigquery.client.requests.jobs;

import com.google.api.client.googleapis.json.GoogleJsonError;
import com.google.api.client.googleapis.json.GoogleJsonResponseException;
import com.google.api.services.bigquery.Bigquery;
import com.google.api.services.bigquery.model.ErrorProto;
import com.google.api.services.bigquery.model.Job;
import com.simba.googlebigquery.googlebigquery.client.exceptions.JobExecutionErrorException;
import com.simba.googlebigquery.googlebigquery.client.requests.AbstractRequestWithRetry;
import com.simba.googlebigquery.googlebigquery.client.requests.jobs.JobsGetRequest;
import com.simba.googlebigquery.support.ILogger;
import com.simba.googlebigquery.support.LogUtilities;
import com.simba.googlebigquery.support.exceptions.ErrorException;
import java.net.SocketTimeoutException;
import java.util.UUID;

public class JobsInsertRequest
extends AbstractRequestWithRetry<Job> {
    private static final String ERROR_REASON_RATE_LIMIT_EXCEEDED = "rateLimitExceeded";
    private static final String ERROR_REASON_TABLE_UNAVAILABLE = "tableUnavailable";
    private static final String SIMBA_JOB_PREFIX = "SimbaJDBC_Job_";
    private String projectId;
    private Job jobToInsert;
    private Job insertedJob;
    private ErrorProto lastJobError = null;

    public JobsInsertRequest(ILogger iLogger, long l, Bigquery bigquery) {
        super(iLogger, l, bigquery);
    }

    @Override
    public Job execute() throws Exception {
        if (null != this.insertedJob) {
            return this.insertedJob;
        }
        this.getJobToInsert().getJobReference().setJobId(SIMBA_JOB_PREFIX + UUID.randomUUID());
        this.insertedJob = (Job)this.getBigQueryClient().jobs().insert(this.getProjectId(), this.getJobToInsert()).setProjectId(this.projectId).execute();
        LogUtilities.logInfo(String.format("executed request jobs.insert. id:%s, query:%s, dryRun:%s, status:%s ", this.insertedJob.getJobReference().getJobId(), this.insertedJob.getConfiguration().getQuery().getQuery(), this.getJobToInsert().getConfiguration().getDryRun() != null ? this.getJobToInsert().getConfiguration().getDryRun() : false, this.insertedJob.getStatus().getState()), this.getLogger());
        if (null != this.insertedJob.getStatus().getErrorResult()) {
            this.lastJobError = this.insertedJob.getStatus().getErrorResult();
            this.insertedJob = null;
            throw new JobExecutionErrorException(this.lastJobError.getMessage());
        }
        return this.insertedJob;
    }

    @Override
    protected boolean shouldRetry(int n) {
        Boolean bl;
        block22: {
            if (null != this.getLastError() && this.getLastError() instanceof SocketTimeoutException) {
                return false;
            }
            bl = null;
            if (this.getMaxRetries() == 0L || (long)n < this.getMaxRetries()) {
                bl = true;
            }
            if (null != this.lastJobError && null != this.lastJobError.getReason() && (this.lastJobError.getReason().equalsIgnoreCase(ERROR_REASON_RATE_LIMIT_EXCEEDED) || this.lastJobError.getReason().equalsIgnoreCase(ERROR_REASON_TABLE_UNAVAILABLE))) {
                bl = true;
            } else if (null != this.getLastError() && this.getLastError() instanceof GoogleJsonResponseException) {
                GoogleJsonResponseException googleJsonResponseException = (GoogleJsonResponseException)((Object)this.getLastError());
                if (null == googleJsonResponseException.getDetails()) {
                    bl = false;
                } else {
                    int n2 = googleJsonResponseException.getDetails().getCode();
                    if (409 == n2) {
                        try {
                            this.insertedJob = new JobsGetRequest(this.getLogger(), this.getBackoffTimeout(), this.getBigQueryClient()).setProjectId(this.getProjectId()).setJobId(this.getJobToInsert().getJobReference().getJobId()).execute();
                            bl = false;
                        }
                        catch (Exception exception) {
                            if (exception.getCause() instanceof GoogleJsonResponseException) {
                                GoogleJsonResponseException googleJsonResponseException2 = (GoogleJsonResponseException)exception.getCause();
                                if (null == googleJsonResponseException2.getDetails()) {
                                    this.setLastError(exception);
                                    bl = false;
                                } else if (404 == googleJsonResponseException2.getDetails().getCode()) {
                                    bl = false;
                                }
                                break block22;
                            }
                            bl = false;
                        }
                    } else if (417 == n2 || 500 <= n2 && 599 >= n2) {
                        bl = true;
                    } else if (400 == n2) {
                        bl = this.containsErrorReasonOnly(googleJsonResponseException, ERROR_REASON_TABLE_UNAVAILABLE);
                    } else if (403 == n2) {
                        bl = this.containsErrorReasonOnly(googleJsonResponseException, ERROR_REASON_RATE_LIMIT_EXCEEDED);
                    } else if (404 == n2) {
                        bl = false;
                    }
                }
            }
        }
        return null == bl || bl != false ? super.shouldRetry(n) : bl.booleanValue();
    }

    @Override
    public void throwException(Exception exception) throws ErrorException {
        throw new JobExecutionErrorException(exception);
    }

    private boolean containsErrorReasonOnly(GoogleJsonResponseException googleJsonResponseException, String string) {
        LogUtilities.logFunctionEntrance(this.getLogger(), new Object[]{googleJsonResponseException, string});
        if (null == googleJsonResponseException.getDetails() || null == googleJsonResponseException.getDetails().getErrors()) {
            return false;
        }
        for (GoogleJsonError.ErrorInfo errorInfo : googleJsonResponseException.getDetails().getErrors()) {
            if (null == errorInfo.getReason() || !errorInfo.getReason().equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public JobsInsertRequest setProjectId(String string) {
        this.projectId = string;
        return this;
    }

    public Job getJobToInsert() {
        return this.jobToInsert;
    }

    public JobsInsertRequest setJobToInsert(Job job) {
        this.jobToInsert = job;
        return this;
    }
}

