/*
 * Decompiled with CFR 0.152.
 */
package com.simba.googlebigquery.googlebigquery.client.requests.jobs;

import com.google.api.services.bigquery.Bigquery;
import com.google.api.services.bigquery.model.Job;
import com.simba.googlebigquery.googlebigquery.client.exceptions.GetJobErrorException;
import com.simba.googlebigquery.googlebigquery.client.requests.AbstractRequestWithRetry;
import com.simba.googlebigquery.support.ILogger;
import com.simba.googlebigquery.support.LogUtilities;
import com.simba.googlebigquery.support.exceptions.ErrorException;

public class JobsGetRequest
extends AbstractRequestWithRetry<Job> {
    private String projectId;
    private String jobId;
    private String location;

    public JobsGetRequest(ILogger iLogger, long l, Bigquery bigquery) {
        super(iLogger, l, bigquery);
    }

    @Override
    public Job execute() throws Exception {
        Job job = (Job)this.getBigQueryClient().jobs().get(this.getProjectId(), this.getJobId()).setLocation(this.getLocation()).execute();
        LogUtilities.logInfo(String.format("executed request jobs.get. id:%s, query:%s, status:%s ", job.getId(), job.getConfiguration().getQuery().getQuery(), job.getStatus().getState()), this.getLogger());
        return job;
    }

    @Override
    public void throwException(Exception exception) throws ErrorException {
        if (exception instanceof ErrorException) {
            throw (ErrorException)exception;
        }
        throw new GetJobErrorException(exception);
    }

    public String getProjectId() {
        return this.projectId;
    }

    public JobsGetRequest setProjectId(String string) {
        this.projectId = string;
        return this;
    }

    public String getJobId() {
        return this.jobId;
    }

    public JobsGetRequest setJobId(String string) {
        this.jobId = string;
        return this;
    }

    public String getLocation() {
        return this.location;
    }

    public JobsGetRequest setLocation(String string) {
        this.location = string;
        return this;
    }
}

