/*
 * Decompiled with CFR 0.152.
 */
package com.simba.googlebigquery.googlebigquery.client.requests.jobs;

import com.google.api.services.bigquery.Bigquery;
import com.google.api.services.bigquery.model.GetQueryResultsResponse;
import com.simba.googlebigquery.googlebigquery.client.exceptions.QueryResultErrorException;
import com.simba.googlebigquery.googlebigquery.client.requests.AbstractRequestWithRetry;
import com.simba.googlebigquery.support.ILogger;
import com.simba.googlebigquery.support.LogUtilities;
import com.simba.googlebigquery.support.exceptions.ErrorException;

public class JobsGetQueryResultsRequest
extends AbstractRequestWithRetry<GetQueryResultsResponse> {
    protected static final long REQUEST_TIMEOUT_MS_MAX = 10000L;
    private String projectId;
    private String jobId;
    private String location;
    private String pageToken;
    private long maxResults;

    public JobsGetQueryResultsRequest(ILogger iLogger, long l, Bigquery bigquery) {
        super(iLogger, l, bigquery);
    }

    @Override
    public GetQueryResultsResponse execute() throws Exception {
        GetQueryResultsResponse getQueryResultsResponse = (GetQueryResultsResponse)this.getBigQueryClient().jobs().getQueryResults(this.getProjectId(), this.getJobId()).setLocation(this.getLocation()).setMaxResults(Long.valueOf(this.getMaxResults())).setTimeoutMs(Long.valueOf(Math.min(this.getBackoffTimeout(), 10000L))).setPageToken(this.getPageToken()).execute();
        LogUtilities.logInfo(String.format("executed request jobs.getQueryResult. id:%s, job Complete:%s ", getQueryResultsResponse.getJobReference().getJobId(), getQueryResultsResponse.getJobComplete()), this.getLogger());
        return getQueryResultsResponse;
    }

    @Override
    public void throwException(Exception exception) throws ErrorException {
        throw new QueryResultErrorException(this.parseErrorMessage(exception.getMessage()), exception);
    }

    public String getProjectId() {
        return this.projectId;
    }

    public JobsGetQueryResultsRequest setProjectId(String string) {
        this.projectId = string;
        return this;
    }

    public String getJobId() {
        return this.jobId;
    }

    public JobsGetQueryResultsRequest setJobId(String string) {
        this.jobId = string;
        return this;
    }

    public String getLocation() {
        return this.location;
    }

    public JobsGetQueryResultsRequest setLocation(String string) {
        this.location = string;
        return this;
    }

    public long getMaxResults() {
        return this.maxResults;
    }

    public String getPageToken() {
        return this.pageToken;
    }

    public JobsGetQueryResultsRequest setPageToken(String string) {
        this.pageToken = string;
        return this;
    }

    public JobsGetQueryResultsRequest setMaxResults(long l) {
        this.maxResults = l;
        return this;
    }
}

