/*
 * Decompiled with CFR 0.152.
 */
package com.simba.googlebigquery.googlebigquery.client.requests.jobs;

import com.google.api.services.bigquery.Bigquery;
import com.google.api.services.bigquery.model.JobCancelResponse;
import com.simba.googlebigquery.googlebigquery.client.exceptions.CancelFailureException;
import com.simba.googlebigquery.googlebigquery.client.requests.AbstractRequestWithRetry;
import com.simba.googlebigquery.support.ILogger;
import com.simba.googlebigquery.support.LogUtilities;
import com.simba.googlebigquery.support.exceptions.ErrorException;

public class JobsCancelRequest
extends AbstractRequestWithRetry<JobCancelResponse> {
    private String projectId;
    private String jobId;
    private String location;

    public JobsCancelRequest(ILogger iLogger, long l, Bigquery bigquery) {
        super(iLogger, l, bigquery);
    }

    @Override
    public JobCancelResponse execute() throws Exception {
        JobCancelResponse jobCancelResponse = (JobCancelResponse)this.getBigQueryClient().jobs().cancel(this.getProjectId(), this.getJobId()).setLocation(this.getLocation()).execute();
        LogUtilities.logInfo(String.format("executed request jobs.cancel. id:%s, status:%s ", jobCancelResponse.getJob().getId(), jobCancelResponse.getJob().getStatus().getState()), this.getLogger());
        return jobCancelResponse;
    }

    @Override
    public void throwException(Exception exception) throws ErrorException {
        throw new CancelFailureException(exception);
    }

    public String getProjectId() {
        return this.projectId;
    }

    public JobsCancelRequest setProjectId(String string) {
        this.projectId = string;
        return this;
    }

    public String getJobId() {
        return this.jobId;
    }

    public JobsCancelRequest setJobId(String string) {
        this.jobId = string;
        return this;
    }

    public String getLocation() {
        return this.location;
    }

    public JobsCancelRequest setLocation(String string) {
        this.location = string;
        return this;
    }
}

