/*
 * Decompiled with CFR 0.152.
 */
package com.simba.googlebigquery.googlebigquery.client.requests.datasets;

import com.google.api.services.bigquery.Bigquery;
import com.google.api.services.bigquery.model.DatasetList;
import com.simba.googlebigquery.googlebigquery.client.exceptions.DatasetOperationsErrorException;
import com.simba.googlebigquery.googlebigquery.client.requests.AbstractRequestWithRetry;
import com.simba.googlebigquery.support.ILogger;
import com.simba.googlebigquery.support.LogUtilities;
import com.simba.googlebigquery.support.exceptions.ErrorException;

public class DatasetsListRequest
extends AbstractRequestWithRetry<DatasetList> {
    private static final long DATASETSLIST_MAXRESULTS = 1000L;
    private String pageToken;
    private String projectId;
    private long maxResults = 1000L;

    public DatasetsListRequest(ILogger iLogger, long l, Bigquery bigquery) {
        super(iLogger, l, bigquery);
    }

    @Override
    public DatasetList execute() throws Exception {
        DatasetList datasetList = (DatasetList)this.getBigQueryClient().datasets().list(this.getProjectId()).setMaxResults(Long.valueOf(this.getMaxResults())).setPageToken(this.getPageToken()).execute();
        LogUtilities.logDebug(String.format("executed request datasets.list for project %s. total datasets:%d, next page token:%s", this.getProjectId(), datasetList.getDatasets() == null ? 0 : datasetList.getDatasets().size(), datasetList.getNextPageToken()), this.getLogger());
        return datasetList;
    }

    @Override
    public void throwException(Exception exception) throws ErrorException {
        throw new DatasetOperationsErrorException(exception.getMessage());
    }

    public String getPageToken() {
        return this.pageToken;
    }

    public DatasetsListRequest setPageToken(String string) {
        this.pageToken = string;
        return this;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public DatasetsListRequest setProjectId(String string) {
        this.projectId = string;
        return this;
    }

    public long getMaxResults() {
        return this.maxResults;
    }

    public DatasetsListRequest setMaxResults(long l) {
        this.maxResults = Math.min(l, 1000L);
        return this;
    }
}

