/*
 * Decompiled with CFR 0.152.
 */
package com.simba.googlebigquery.googlebigquery.client.requests.datasets;

import com.google.api.services.bigquery.Bigquery;
import com.google.api.services.bigquery.model.Dataset;
import com.simba.googlebigquery.googlebigquery.client.exceptions.DatasetOperationsErrorException;
import com.simba.googlebigquery.googlebigquery.client.requests.AbstractRequestWithRetry;
import com.simba.googlebigquery.support.ILogger;
import com.simba.googlebigquery.support.exceptions.ErrorException;

public class DatasetsGetRequest
extends AbstractRequestWithRetry<Dataset> {
    private String projectId;
    private String datasetId;

    public DatasetsGetRequest(ILogger iLogger, long l, Bigquery bigquery) {
        super(iLogger, l, bigquery);
    }

    @Override
    public Dataset execute() throws Exception {
        return (Dataset)this.getBigQueryClient().datasets().get(this.getProjectId(), this.getDatasetId()).execute();
    }

    @Override
    public void throwException(Exception exception) throws ErrorException {
        throw new DatasetOperationsErrorException(exception.getMessage());
    }

    public String getProjectId() {
        return this.projectId;
    }

    public DatasetsGetRequest setProjectId(String string) {
        this.projectId = string;
        return this;
    }

    public String getDatasetId() {
        return this.datasetId;
    }

    public DatasetsGetRequest setDatasetId(String string) {
        this.datasetId = string;
        return this;
    }
}

