/*
 * Decompiled with CFR 0.152.
 */
package com.simba.googlebigquery.googlebigquery.client.requests;

import com.google.api.client.http.HttpResponse;
import com.google.api.client.json.CustomizeJsonParser;
import com.google.api.client.json.JsonParser;
import com.google.api.client.json.gson.GsonFactory;
import com.google.api.services.bigquery.Bigquery;
import com.google.api.services.bigquery.model.GetQueryResultsResponse;
import com.simba.googlebigquery.googlebigquery.client.exceptions.QueryResultErrorException;
import com.simba.googlebigquery.googlebigquery.client.requests.jobs.JobsGetQueryResultsRequest;
import com.simba.googlebigquery.googlebigquery.dataengine.BQBufferManager;
import com.simba.googlebigquery.googlebigquery.utils.BQCustomParser;
import com.simba.googlebigquery.support.ILogger;
import com.simba.googlebigquery.support.LogUtilities;
import com.simba.googlebigquery.support.exceptions.ErrorException;

public class FetchQueryResultsRequest
extends JobsGetQueryResultsRequest {
    private BQBufferManager bufferManager;

    public FetchQueryResultsRequest(ILogger iLogger, long l, Bigquery bigquery) {
        super(iLogger, l, bigquery);
    }

    @Override
    public GetQueryResultsResponse execute() throws Exception {
        LogUtilities.logFunctionEntrance(this.getLogger(), new Object[0]);
        HttpResponse httpResponse = this.getBigQueryClient().jobs().getQueryResults(this.getProjectId(), this.getJobId()).setLocation(this.getLocation()).setMaxResults(Long.valueOf(this.getMaxResults())).setPageToken(this.getPageToken()).setTimeoutMs(Long.valueOf(Math.min(this.getBackoffTimeout(), 10000L))).executeUnparsed();
        JsonParser jsonParser = GsonFactory.getDefaultInstance().createJsonParser(httpResponse.getContent(), httpResponse.getContentCharset());
        BQCustomParser bQCustomParser = new BQCustomParser(this.getBufferManager());
        GetQueryResultsResponse getQueryResultsResponse = (GetQueryResultsResponse)jsonParser.parse(GetQueryResultsResponse.class, true, (CustomizeJsonParser)bQCustomParser);
        if (null != bQCustomParser.getException()) {
            throw bQCustomParser.getException();
        }
        return getQueryResultsResponse;
    }

    @Override
    public void throwException(Exception exception) throws ErrorException {
        if (exception instanceof ErrorException) {
            throw (ErrorException)exception;
        }
        throw new QueryResultErrorException(exception);
    }

    public BQBufferManager getBufferManager() {
        return this.bufferManager;
    }

    public FetchQueryResultsRequest setBufferManager(BQBufferManager bQBufferManager) {
        this.bufferManager = bQBufferManager;
        return this;
    }
}

