/*
 * Decompiled with CFR 0.152.
 */
package com.simba.googlebigquery.googlebigquery.client.requests;

import com.google.api.client.googleapis.json.GoogleJsonError;
import com.google.api.client.googleapis.json.GoogleJsonResponseException;
import com.google.api.client.util.ExponentialBackOff;
import com.google.api.services.bigquery.Bigquery;
import com.simba.googlebigquery.googlebigquery.client.exceptions.RequestTimeoutException;
import com.simba.googlebigquery.googlebigquery.client.requests.IRequest;
import com.simba.googlebigquery.googlebigquery.core.BQDriver;
import com.simba.googlebigquery.googlebigquery.exceptions.BQMessageKey;
import com.simba.googlebigquery.support.ILogger;
import com.simba.googlebigquery.support.LogUtilities;
import com.simba.googlebigquery.support.exceptions.ErrorException;
import java.io.IOException;
import org.json.JSONObject;

public abstract class AbstractRequestWithRetry<ExecuteResultType>
implements IRequest<ExecuteResultType> {
    public static final int DEFAULT_RETRY_TIMEOUT_MS = 10000;
    public static final int DEFAULT_MAX_RETRIES = 5;
    private static final String ERROR_RESPONSE_MESSAGE_KEY = "message";
    private static final String BQ_ERRMSG_QUOTA_EXCEEDED = "quotaExceeded";
    private static final String BQ_ERRMSG_RATE_EXCEEDED = "rateLimitExceeded";
    protected ExponentialBackOff backoff;
    private final ExponentialBackOff.Builder backoffBuilder = new ExponentialBackOff.Builder();
    private final long backoffTimeout;
    private final Bigquery bqClient;
    private final ILogger logger;
    private Exception lastError = null;
    private long maxRetries = 5L;

    public AbstractRequestWithRetry(ILogger iLogger, long l, Bigquery bigquery) {
        this.backoffTimeout = l;
        this.bqClient = bigquery;
        this.logger = iLogger;
    }

    public ExecuteResultType executeWithRetry() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.logger, new Object[0]);
        this.initialiseBackoff();
        int n = 1;
        while (true) {
            try {
                return this.execute();
            }
            catch (Exception exception) {
                this.setLastError(exception);
                boolean bl = this.shouldRetry(n);
                if (bl) {
                    LogUtilities.logTrace(this.getLastError(), this.logger);
                    this.waitToRetryOrStop();
                    ++n;
                    continue;
                }
                this.throwException(this.getLastError());
                if (bl) continue;
                return null;
            }
            break;
        }
    }

    protected void initialiseBackoff() {
        try {
            this.backoffBuilder.setMaxElapsedTimeMillis((int)this.backoffTimeout);
        }
        catch (Exception exception) {
            LogUtilities.logDebug("Unable to set retry timeout value" + this.backoffTimeout + ". Defaulting to " + 10000 + ".", this.logger);
            this.backoffBuilder.setMaxElapsedTimeMillis(10000);
        }
        if (null == this.backoff) {
            this.backoff = this.backoffBuilder.build();
        }
    }

    protected String parseErrorMessage(String string) {
        try {
            String string2 = string.substring(string.indexOf("{"));
            JSONObject jSONObject = new JSONObject(string2);
            return jSONObject.getString(ERROR_RESPONSE_MESSAGE_KEY);
        }
        catch (Exception exception) {
            return string;
        }
    }

    protected boolean shouldRetry(int n) {
        boolean bl = false;
        if (this.getMaxRetries() == 0L || (long)n <= this.getMaxRetries()) {
            LogUtilities.logTrace(this.lastError, this.logger);
            bl = true;
        }
        if (null == this.lastError) {
            bl = false;
        } else if (this.lastError instanceof ErrorException) {
            bl = false;
        } else if (this.lastError instanceof GoogleJsonResponseException && null != ((GoogleJsonResponseException)((Object)this.lastError)).getDetails()) {
            GoogleJsonError googleJsonError = ((GoogleJsonResponseException)((Object)this.lastError)).getDetails();
            switch (googleJsonError.getCode()) {
                case 403: {
                    String string = ((GoogleJsonError.ErrorInfo)googleJsonError.getErrors().get(0)).getReason();
                    if (string.equalsIgnoreCase(BQ_ERRMSG_QUOTA_EXCEEDED) || string.equalsIgnoreCase(BQ_ERRMSG_RATE_EXCEEDED)) {
                        return true;
                    }
                    this.setLastError(BQDriver.s_BQMessages.createGeneralException(BQMessageKey.BIGQUERY_API_ERR.name(), string));
                    return false;
                }
                case 400: 
                case 401: 
                case 404: {
                    return false;
                }
            }
            String string = "{ Code: " + googleJsonError.getCode() + ", Reason: " + ((GoogleJsonError.ErrorInfo)googleJsonError.getErrors().get(0)).getReason() + ", Message: " + ((GoogleJsonError.ErrorInfo)googleJsonError.getErrors().get(0)).getMessage() + " }";
            this.setLastError(BQDriver.s_BQMessages.createGeneralException(BQMessageKey.BIGQUERY_API_ERR.name(), string));
            return false;
        }
        return bl;
    }

    protected void waitToRetryOrStop() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.logger, new Object[0]);
        try {
            long l = this.backoff.nextBackOffMillis();
            if (-1L == l) {
                throw new RequestTimeoutException();
            }
            Thread.sleep(l);
        }
        catch (IOException | InterruptedException exception) {
            this.throwException(exception);
        }
    }

    public Exception getLastError() {
        return this.lastError;
    }

    public final ILogger getLogger() {
        return this.logger;
    }

    public long getMaxRetries() {
        return this.maxRetries;
    }

    protected long getBackoffTimeout() {
        return this.backoffTimeout;
    }

    protected final Bigquery getBigQueryClient() {
        return this.bqClient;
    }

    protected void setMaxRetries(long l) {
        this.maxRetries = l;
    }

    protected void setLastError(Exception exception) {
        this.lastError = exception;
    }
}

