/*
 * Decompiled with CFR 0.152.
 */
package com.simba.googlebigquery.googlebigquery.client.queryclient;

import com.google.api.client.util.Preconditions;
import com.google.api.services.bigquery.model.ConnectionProperty;
import com.simba.googlebigquery.googlebigquery.core.BQConnectionOptions;
import java.util.concurrent.atomic.AtomicBoolean;

public class QueryContext {
    protected AtomicBoolean isCancelledFlag;
    protected final Object isCancelledFlagLock;
    private String jobId;
    private String location;
    private String sessionId;

    public QueryContext(AtomicBoolean atomicBoolean, Object object, BQConnectionOptions bQConnectionOptions) {
        Preconditions.checkArgument((null != atomicBoolean ? 1 : 0) != 0);
        Preconditions.checkArgument((null != object ? 1 : 0) != 0);
        this.isCancelledFlag = atomicBoolean;
        this.isCancelledFlagLock = object;
        this.jobId = "";
        this.location = null != bQConnectionOptions.m_location && !bQConnectionOptions.m_location.isEmpty() ? bQConnectionOptions.m_location : "";
        this.sessionId = "";
        if (bQConnectionOptions.m_enableSession && !bQConnectionOptions.m_queryProperties.isEmpty()) {
            for (ConnectionProperty connectionProperty : bQConnectionOptions.m_queryProperties) {
                if (!connectionProperty.getKey().equals("session_id")) continue;
                this.sessionId = connectionProperty.getValue();
                break;
            }
        }
    }

    public boolean isCancelled() {
        return this.isCancelledFlag.get();
    }

    public void setCancelled(boolean bl) {
        this.isCancelledFlag.set(bl);
    }

    public Object getCancelLock() {
        return this.isCancelledFlagLock;
    }

    public String getJobId() {
        return this.jobId;
    }

    public QueryContext setJobId(String string) {
        this.jobId = string;
        return this;
    }

    public String getLocation() {
        return this.location;
    }

    public QueryContext setLocation(String string) {
        this.location = string;
        return this;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String string) {
        this.sessionId = string;
    }
}

