/*
 * Decompiled with CFR 0.152.
 */
package com.simba.googlebigquery.googlebigquery.client.queryclient;

import com.google.api.client.util.ExponentialBackOff;
import com.google.api.client.util.Preconditions;
import com.google.api.services.bigquery.Bigquery;
import com.google.api.services.bigquery.model.ConnectionProperty;
import com.google.api.services.bigquery.model.DatasetReference;
import com.google.api.services.bigquery.model.GetQueryResultsResponse;
import com.google.api.services.bigquery.model.Job;
import com.google.api.services.bigquery.model.JobConfiguration;
import com.google.api.services.bigquery.model.JobConfigurationQuery;
import com.google.api.services.bigquery.model.JobReference;
import com.simba.googlebigquery.googlebigquery.BQExecutionContext;
import com.simba.googlebigquery.googlebigquery.client.IBQResponse;
import com.simba.googlebigquery.googlebigquery.client.exceptions.JobExecutionErrorException;
import com.simba.googlebigquery.googlebigquery.client.exceptions.QueryCancelledException;
import com.simba.googlebigquery.googlebigquery.client.exceptions.QueryResultErrorException;
import com.simba.googlebigquery.googlebigquery.client.exceptions.RequestTimeoutException;
import com.simba.googlebigquery.googlebigquery.client.queryclient.JobsInsertClient;
import com.simba.googlebigquery.googlebigquery.client.queryclient.JobsQueryClient;
import com.simba.googlebigquery.googlebigquery.client.queryclient.QueryContext;
import com.simba.googlebigquery.googlebigquery.client.requests.jobs.JobsCancelRequest;
import com.simba.googlebigquery.googlebigquery.client.requests.jobs.JobsGetQueryResultsRequest;
import com.simba.googlebigquery.googlebigquery.client.requests.jobs.JobsInsertRequest;
import com.simba.googlebigquery.googlebigquery.core.BQConnectionOptions;
import com.simba.googlebigquery.support.ILogger;
import com.simba.googlebigquery.support.LogUtilities;
import com.simba.googlebigquery.support.exceptions.ErrorException;

public abstract class QueryClient {
    protected static final String PARAMETERMODE_POSITIONAL = "POSITIONAL";
    private static final String SESSION_ID_KEY = "session_id";
    protected final Bigquery bqClient;
    protected final BQConnectionOptions connectionOptions;
    protected final BQExecutionContext executionContext;
    protected final ILogger logger;
    protected final QueryContext queryContext;
    protected final Object sessionLock = new Object();

    protected QueryClient(Builder builder) {
        Preconditions.checkArgument((null != builder.bqClient ? 1 : 0) != 0);
        Preconditions.checkArgument((null != builder.connectionOptions ? 1 : 0) != 0);
        Preconditions.checkArgument((null != builder.logger ? 1 : 0) != 0);
        this.bqClient = builder.bqClient;
        this.connectionOptions = builder.connectionOptions;
        this.logger = builder.logger;
        this.executionContext = builder.executionContext;
        this.queryContext = builder.queryContext;
    }

    public Job executeDryRun() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.logger, new Object[0]);
        Job job = new Job().setJobReference(this.createJobReferenceBase());
        JobConfiguration jobConfiguration = new JobConfiguration();
        JobConfigurationQuery jobConfigurationQuery = new JobConfigurationQuery().setQuery(this.executionContext.query).setUseLegacySql(Boolean.valueOf(this.executionContext.queryDialect == BQConnectionOptions.QueryDialect.BIG_QUERY));
        if (this.executionContext.queryDialect != BQConnectionOptions.QueryDialect.BIG_QUERY) {
            jobConfigurationQuery.setParameterMode(PARAMETERMODE_POSITIONAL);
        }
        if (null != this.executionContext.defaultDataset) {
            jobConfigurationQuery.setDefaultDataset(new DatasetReference().setDatasetId(this.executionContext.defaultDataset));
        }
        if (!this.connectionOptions.m_queryProperties.isEmpty()) {
            jobConfigurationQuery.setConnectionProperties(this.connectionOptions.m_queryProperties);
        }
        jobConfiguration.setQuery(jobConfigurationQuery).setDryRun(Boolean.valueOf(true));
        job.setConfiguration(jobConfiguration);
        return (Job)new JobsInsertRequest(this.logger, this.connectionOptions.m_timeout, this.bqClient).setProjectId(this.connectionOptions.m_projectId).setJobToInsert(job).executeWithRetry();
    }

    public abstract IBQResponse executeQuery() throws ErrorException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelQuery() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.logger, new Object[0]);
        if (this.queryContext.isCancelled() || null == this.queryContext.getJobId() || this.queryContext.getJobId().isEmpty()) {
            return;
        }
        Object object = this.queryContext.getCancelLock();
        synchronized (object) {
            this.queryContext.setCancelled(true);
        }
        new JobsCancelRequest(this.logger, this.connectionOptions.m_timeout, this.bqClient).setProjectId(this.executionContext.projectId).setJobId(this.queryContext.getJobId()).setLocation(this.connectionOptions.m_location).executeWithRetry();
    }

    protected JobReference createJobReferenceBase() {
        JobReference jobReference = new JobReference();
        if (!this.connectionOptions.m_location.isEmpty()) {
            jobReference.setLocation(this.connectionOptions.m_location);
        }
        return jobReference;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected GetQueryResultsResponse pollQueryJob() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.logger, new Object[0]);
        ExponentialBackOff.Builder builder = new ExponentialBackOff.Builder();
        builder.setMaxElapsedTimeMillis((int)(this.connectionOptions.m_timeout > 0L ? this.connectionOptions.m_timeout : 10000L));
        ExponentialBackOff exponentialBackOff = builder.build();
        String string = this.getQueryContext().getJobId();
        String string2 = this.getQueryContext().getLocation();
        JobsGetQueryResultsRequest jobsGetQueryResultsRequest = new PollRequest(this.logger, this.connectionOptions.m_timeout, this.bqClient).setProjectId(this.executionContext.projectId).setJobId(string).setLocation(string2).setMaxResults(this.connectionOptions.m_maxResults);
        Object object = this.queryContext.getCancelLock();
        synchronized (object) {
            GetQueryResultsResponse getQueryResultsResponse;
            do {
                if (this.queryContext.isCancelled()) {
                    this.cancelQuery();
                    throw new QueryCancelledException();
                }
                try {
                    getQueryResultsResponse = (GetQueryResultsResponse)jobsGetQueryResultsRequest.executeWithRetry();
                    long l = exponentialBackOff.nextBackOffMillis();
                    if (getQueryResultsResponse.getJobComplete().booleanValue()) continue;
                    if (-1L == l) {
                        throw new JobExecutionErrorException("Time out in polling job.Try increasing the timeout value.");
                    }
                    Thread.sleep(l);
                }
                catch (RequestTimeoutException requestTimeoutException) {
                    this.cancelQuery();
                    throw requestTimeoutException;
                }
                catch (JobExecutionErrorException jobExecutionErrorException) {
                    this.cancelQuery();
                    throw jobExecutionErrorException;
                }
                catch (QueryResultErrorException queryResultErrorException) {
                    throw new JobExecutionErrorException(jobsGetQueryResultsRequest.getLastError());
                }
                catch (Exception exception) {
                    this.cancelQuery();
                    throw new JobExecutionErrorException(exception.getMessage());
                }
            } while (!getQueryResultsResponse.getJobComplete().booleanValue());
            return getQueryResultsResponse;
        }
    }

    protected void saveSessionInfo(String string) {
        LogUtilities.logFunctionEntrance(this.logger, string);
        ConnectionProperty connectionProperty = new ConnectionProperty();
        connectionProperty.setKey(SESSION_ID_KEY);
        connectionProperty.setValue(string);
        this.connectionOptions.m_queryProperties.add(connectionProperty);
        this.queryContext.setSessionId(string);
    }

    public Bigquery getBigQueryClient() {
        return this.bqClient;
    }

    public QueryContext getQueryContext() {
        return this.queryContext;
    }

    private static class PollRequest
    extends JobsGetQueryResultsRequest {
        public PollRequest(ILogger iLogger, long l, Bigquery bigquery) {
            super(iLogger, l, bigquery);
        }

        @Override
        public void throwException(Exception exception) throws ErrorException {
            throw new JobExecutionErrorException(this.parseErrorMessage(exception.getMessage()), exception);
        }
    }

    public static class Builder {
        private Bigquery bqClient = null;
        private BQConnectionOptions connectionOptions = null;
        private BQExecutionContext executionContext = null;
        private ILogger logger = null;
        private QueryContext queryContext = null;

        public QueryClient build() {
            LogUtilities.logFunctionEntrance(this.logger, new Object[0]);
            QueryClient queryClient = this.executionContext.useJobsQuery ? new JobsQueryClient(this) : new JobsInsertClient(this);
            this.reset();
            return queryClient;
        }

        private void reset() {
            this.bqClient = null;
            this.connectionOptions = null;
            this.executionContext = null;
            this.logger = null;
            this.queryContext = null;
        }

        public Builder setBigQueryClient(Bigquery bigquery) {
            this.bqClient = bigquery;
            return this;
        }

        public Builder setConnectionOptions(BQConnectionOptions bQConnectionOptions) {
            this.connectionOptions = bQConnectionOptions;
            return this;
        }

        public Builder setExecutionContext(BQExecutionContext bQExecutionContext) {
            this.executionContext = bQExecutionContext;
            return this;
        }

        public Builder setLogger(ILogger iLogger) {
            this.logger = iLogger;
            return this;
        }

        public Builder setQueryContext(QueryContext queryContext) {
            this.queryContext = queryContext;
            return this;
        }
    }
}

