/*
 * Decompiled with CFR 0.152.
 */
package com.simba.googlebigquery.googlebigquery.client.queryclient;

import com.google.api.services.bigquery.model.DatasetReference;
import com.google.api.services.bigquery.model.QueryRequest;
import com.google.api.services.bigquery.model.QueryResponse;
import com.simba.googlebigquery.googlebigquery.client.BQGetQueryResultsResponse;
import com.simba.googlebigquery.googlebigquery.client.BQQueryResponse;
import com.simba.googlebigquery.googlebigquery.client.IBQResponse;
import com.simba.googlebigquery.googlebigquery.client.exceptions.SessionIdNotFoundException;
import com.simba.googlebigquery.googlebigquery.client.queryclient.QueryClient;
import com.simba.googlebigquery.googlebigquery.client.requests.jobs.JobsQueryRequest;
import com.simba.googlebigquery.googlebigquery.core.BQConnectionOptions;
import com.simba.googlebigquery.support.LogUtilities;
import com.simba.googlebigquery.support.exceptions.ErrorException;

public class JobsQueryClient
extends QueryClient {
    private static final long REQUEST_TIMEOUT_MS_MAX = 10000L;

    JobsQueryClient(QueryClient.Builder builder) {
        super(builder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IBQResponse executeQuery() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.logger, new Object[0]);
        QueryResponse queryResponse = (QueryResponse)new JobsQueryRequest(this.logger, this.connectionOptions.m_timeout, this.bqClient).setProjectId(this.executionContext.projectId).setJob(this.setupQueryRequest()).executeWithRetry();
        assert (null != queryResponse);
        this.queryContext.setJobId(queryResponse.getJobReference().getJobId());
        this.queryContext.setLocation(queryResponse.getJobReference().getLocation());
        if (this.connectionOptions.m_enableSession) {
            Object object = this.sessionLock;
            synchronized (object) {
                if (this.queryContext.getSessionId().isEmpty()) {
                    if (null == queryResponse.getSessionInfo() || queryResponse.getSessionInfo().getSessionId().isEmpty()) {
                        throw new SessionIdNotFoundException();
                    }
                    this.saveSessionInfo(queryResponse.getSessionInfo().getSessionId());
                }
            }
        }
        if (queryResponse.getJobComplete().booleanValue()) {
            return new BQQueryResponse(queryResponse);
        }
        return new BQGetQueryResultsResponse(this.pollQueryJob());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private QueryRequest setupQueryRequest() {
        LogUtilities.logFunctionEntrance(this.logger, new Object[0]);
        QueryRequest queryRequest = new QueryRequest().setDryRun(Boolean.valueOf(false)).setQuery(this.executionContext.query).setMaxResults(Long.valueOf(this.connectionOptions.m_maxResults)).setUseQueryCache(Boolean.valueOf(this.connectionOptions.m_useQueryCache)).setTimeoutMs(Long.valueOf(10000L)).setUseLegacySql(Boolean.valueOf(BQConnectionOptions.QueryDialect.BIG_QUERY == this.executionContext.queryDialect));
        if (!this.executionContext.bqParameters.isEmpty()) {
            queryRequest.setParameterMode("POSITIONAL").setQueryParameters(this.executionContext.bqParameters);
        }
        if (null != this.executionContext.defaultDataset) {
            queryRequest.setDefaultDataset(new DatasetReference().setDatasetId(this.executionContext.defaultDataset));
        }
        if (!this.connectionOptions.m_queryProperties.isEmpty()) {
            queryRequest.setConnectionProperties(this.connectionOptions.m_queryProperties);
        }
        if (this.connectionOptions.m_enableSession) {
            Object object = this.sessionLock;
            synchronized (object) {
                if (this.getQueryContext().getSessionId().isEmpty()) {
                    LogUtilities.logDebug("Enabling session.", this.logger);
                    queryRequest.setCreateSession(Boolean.valueOf(true));
                }
            }
        }
        if (null != this.queryContext.getLocation() && !this.queryContext.getLocation().isEmpty()) {
            queryRequest.setLocation(this.queryContext.getLocation());
        }
        return queryRequest;
    }
}

