/*
 * Decompiled with CFR 0.152.
 */
package com.simba.googlebigquery.googlebigquery.client.queryclient;

import com.google.api.services.bigquery.model.Dataset;
import com.google.api.services.bigquery.model.DatasetReference;
import com.google.api.services.bigquery.model.EncryptionConfiguration;
import com.google.api.services.bigquery.model.GetQueryResultsResponse;
import com.google.api.services.bigquery.model.Job;
import com.google.api.services.bigquery.model.JobConfiguration;
import com.google.api.services.bigquery.model.JobConfigurationQuery;
import com.google.api.services.bigquery.model.JobList;
import com.google.api.services.bigquery.model.TableReference;
import com.simba.googlebigquery.googlebigquery.client.BQGetQueryResultsResponse;
import com.simba.googlebigquery.googlebigquery.client.IBQResponse;
import com.simba.googlebigquery.googlebigquery.client.exceptions.QueryCancelledException;
import com.simba.googlebigquery.googlebigquery.client.exceptions.SessionIdNotFoundException;
import com.simba.googlebigquery.googlebigquery.client.queryclient.QueryClient;
import com.simba.googlebigquery.googlebigquery.client.requests.datasets.DatasetsGetRequest;
import com.simba.googlebigquery.googlebigquery.client.requests.datasets.DatasetsInsertRequest;
import com.simba.googlebigquery.googlebigquery.client.requests.jobs.JobsInsertRequest;
import com.simba.googlebigquery.googlebigquery.client.requests.jobs.JobsListRequest;
import com.simba.googlebigquery.googlebigquery.core.BQConnectionOptions;
import com.simba.googlebigquery.support.LogUtilities;
import com.simba.googlebigquery.support.exceptions.ErrorException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.UUID;

public class JobsInsertClient
extends QueryClient {
    private static final long EXPIRE_TIME = 86400000L;
    private static final String HIDDEN_DATASET = "_simba_jdbc";
    private static final String PREFIX_TABLE_NAME = "temp_table_";
    private static final String QUERY_TYPE_DROP_PREFIX = "DROP_";
    private static final String QUERY_TYPE_SCRIPT = "SCRIPT";
    private static final String SCRIPT_OPTION_KEY = "scriptOptions.keyResultStatement";
    private static final String SCRIPT_OPTION_VALUE = "FIRST_SELECT";
    private static final String WRITE_TRUNCATE = "WRITE_TRUNCATE";

    JobsInsertClient(QueryClient.Builder builder) {
        super(builder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IBQResponse executeQuery() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.logger, new Object[0]);
        Object object = this.getQueryContext().getCancelLock();
        synchronized (object) {
            String string;
            Object object2;
            if (this.getQueryContext().isCancelled()) {
                throw new QueryCancelledException();
            }
            Job job = (Job)new JobsInsertRequest(this.logger, this.connectionOptions.m_timeout, this.bqClient).setProjectId(this.executionContext.projectId).setJobToInsert(this.setupInsertJob()).executeWithRetry();
            this.queryContext.setJobId(job.getJobReference().getJobId());
            this.queryContext.setLocation(job.getJobReference().getLocation());
            if (this.connectionOptions.m_enableSession) {
                object2 = this.sessionLock;
                synchronized (object2) {
                    if (this.getQueryContext().getSessionId().isEmpty()) {
                        string = job.getStatistics().getSessionInfo();
                        if (null == string || string.getSessionId().isEmpty()) {
                            throw new SessionIdNotFoundException();
                        }
                        this.saveSessionInfo(string.getSessionId());
                    }
                }
            }
            object2 = this.pollQueryJob();
            string = job.getStatistics().getQuery().getStatementType();
            List<JobList.Jobs> list = null;
            if (string.equalsIgnoreCase(QUERY_TYPE_SCRIPT) || string.equalsIgnoreCase(QUERY_TYPE_DROP_PREFIX)) {
                list = this.getChildJobs();
            }
            return new BQGetQueryResultsResponse(job, (GetQueryResultsResponse)object2, list);
        }
    }

    private void createDataset(String string, String string2) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.logger, string, string2);
        Dataset dataset = new Dataset().setDatasetReference(new DatasetReference().setProjectId(string).setDatasetId(string2)).setDefaultTableExpirationMs(Long.valueOf(string2.equals(HIDDEN_DATASET) ? 86400000L : this.connectionOptions.m_largeResultsDatasetExpirationTime));
        if (!this.queryContext.getLocation().isEmpty()) {
            dataset.setLocation(this.queryContext.getLocation());
        }
        new DatasetsInsertRequest(this.logger, this.connectionOptions.m_timeout, this.bqClient).setProjectId(string).setDataset(dataset).executeWithRetry();
    }

    private void createTempTableForLargeResults(JobConfigurationQuery jobConfigurationQuery, String string) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.logger, jobConfigurationQuery, string);
        String string2 = null == this.connectionOptions.m_largeResultDataset ? HIDDEN_DATASET : this.connectionOptions.m_largeResultDataset;
        String string3 = null != this.connectionOptions.m_largeResultTable ? this.connectionOptions.m_largeResultTable : PREFIX_TABLE_NAME + new SimpleDateFormat("dd_MM_yyyy_HH_mm_ss_SSS").format(new Date()) + "_" + UUID.randomUUID();
        try {
            new DatasetsGetRequest(this.logger, this.connectionOptions.m_timeout, this.getBigQueryClient()).setProjectId(string).setDatasetId(string2).executeWithRetry();
        }
        catch (Exception exception) {
            this.createDataset(string, string2);
        }
        jobConfigurationQuery.setDestinationTable(new TableReference().setProjectId(string).setDatasetId(string2).setTableId(string3)).setAllowLargeResults(Boolean.valueOf(true)).setWriteDisposition(WRITE_TRUNCATE);
    }

    private List<JobList.Jobs> getChildJobs() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.logger, new Object[0]);
        String string = this.connectionOptions.m_projectId;
        String string2 = this.queryContext.getJobId();
        String string3 = "";
        ArrayList<JobList.Jobs> arrayList = new ArrayList<JobList.Jobs>();
        do {
            JobList jobList;
            if (null != (jobList = (JobList)new JobsListRequest(this.logger, this.connectionOptions.m_timeout, this.bqClient).setProjectId(string).setParentJobId(string2).setPageToken(string3).setMaxResults(this.connectionOptions.m_maxResults).executeWithRetry())) {
                string3 = jobList.getNextPageToken();
                if (null == jobList.getJobs()) continue;
                arrayList.addAll(jobList.getJobs());
                continue;
            }
            string3 = "";
        } while (null != string3 && !string3.isEmpty());
        if (!arrayList.isEmpty()) {
            Collections.reverse(arrayList);
        } else {
            arrayList = null;
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Job setupInsertJob() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.logger, new Object[0]);
        JobConfigurationQuery jobConfigurationQuery = new JobConfigurationQuery().setQuery(this.executionContext.query).setUseQueryCache(Boolean.valueOf(this.connectionOptions.m_useQueryCache)).setUseLegacySql(Boolean.valueOf(BQConnectionOptions.QueryDialect.BIG_QUERY == this.executionContext.queryDialect)).set(SCRIPT_OPTION_KEY, (Object)SCRIPT_OPTION_VALUE);
        if (this.executionContext.useDestinationTable) {
            this.createTempTableForLargeResults(jobConfigurationQuery, this.executionContext.projectId);
        }
        if (null != this.executionContext.defaultDataset) {
            jobConfigurationQuery.setDefaultDataset(new DatasetReference().setDatasetId(this.executionContext.defaultDataset));
        }
        if (this.connectionOptions.m_enableSession) {
            Object object = this.sessionLock;
            synchronized (object) {
                if (this.getQueryContext().getSessionId().isEmpty()) {
                    LogUtilities.logDebug("Enabling session.", this.logger);
                    jobConfigurationQuery.setCreateSession(Boolean.valueOf(true));
                }
            }
        }
        if (!this.executionContext.bqParameters.isEmpty()) {
            jobConfigurationQuery.setParameterMode("POSITIONAL").setQueryParameters(this.executionContext.bqParameters);
        }
        if (!this.connectionOptions.m_queryProperties.isEmpty()) {
            jobConfigurationQuery.setConnectionProperties(this.connectionOptions.m_queryProperties);
        }
        if (null != this.connectionOptions.m_KMSKeyName) {
            jobConfigurationQuery.setDestinationEncryptionConfiguration(new EncryptionConfiguration().setKmsKeyName(this.connectionOptions.m_KMSKeyName));
        }
        return new Job().setJobReference(this.createJobReferenceBase()).setConfiguration(new JobConfiguration().setQuery(jobConfigurationQuery));
    }
}

