/*
 * Decompiled with CFR 0.152.
 */
package com.simba.googlebigquery.googlebigquery.client.metadata;

import com.google.api.services.bigquery.model.DatasetReference;
import com.simba.googlebigquery.googlebigquery.dataengine.metadata.BQColumnMetadata;
import com.simba.googlebigquery.googlebigquery.dataengine.metadata.BQFunction;
import com.simba.googlebigquery.googlebigquery.dataengine.metadata.BQFunctionColumn;
import com.simba.googlebigquery.googlebigquery.dataengine.metadata.BQTable;
import java.util.ArrayList;
import java.util.List;

public class BQMetadataResult {
    private List<BQColumnMetadata> m_columns = new ArrayList<BQColumnMetadata>();
    private List<String> m_projects;
    private List<DatasetReference> m_datasets = new ArrayList<DatasetReference>();
    private List<BQTable> m_tables;
    private List<BQFunction> m_functions = new ArrayList<BQFunction>();
    private List<BQFunctionColumn> m_functionColumns = new ArrayList<BQFunctionColumn>();
    private boolean m_hasResults = false;

    public BQMetadataResult() {
        this.m_projects = new ArrayList<String>();
        this.m_tables = new ArrayList<BQTable>();
    }

    public void addColumns(List<BQColumnMetadata> list) {
        if (null == list) {
            return;
        }
        this.m_columns.addAll(list);
        this.m_hasResults = true;
    }

    public void addDatasets(List<DatasetReference> list) {
        if (null == list) {
            return;
        }
        this.m_datasets.addAll(list);
        this.m_hasResults = true;
    }

    public void addFunctions(List<BQFunction> list) {
        if (null == list) {
            return;
        }
        this.m_functions.addAll(list);
        this.m_hasResults = true;
    }

    public void addFunctionColumns(List<BQFunctionColumn> list) {
        if (null == list) {
            return;
        }
        this.m_functionColumns.addAll(list);
        this.m_hasResults = true;
    }

    public void addProjects(List<String> list) {
        if (null == list) {
            return;
        }
        this.m_projects.addAll(list);
        this.m_hasResults = true;
    }

    public void addTables(List<BQTable> list) {
        if (null == list) {
            return;
        }
        this.m_tables.addAll(list);
        this.m_hasResults = true;
    }

    public List<BQColumnMetadata> getColumns() {
        return this.m_columns;
    }

    public List<DatasetReference> getDatasets() {
        return this.m_datasets;
    }

    public List<BQFunction> getFunctions() {
        return this.m_functions;
    }

    public List<BQFunctionColumn> getFunctionColumns() {
        return this.m_functionColumns;
    }

    public List<String> getProjects() {
        return this.m_projects;
    }

    public List<BQTable> getTables() {
        return this.m_tables;
    }

    public boolean isEmpty() {
        return !this.m_hasResults;
    }

    public void merge(BQMetadataResult bQMetadataResult) {
        if (!bQMetadataResult.isEmpty()) {
            this.addColumns(bQMetadataResult.getColumns());
            this.addDatasets(bQMetadataResult.getDatasets());
            this.addFunctions(bQMetadataResult.getFunctions());
            this.addFunctionColumns(bQMetadataResult.getFunctionColumns());
            this.addProjects(bQMetadataResult.getProjects());
            this.addTables(bQMetadataResult.getTables());
        }
    }
}

