/*
 * Decompiled with CFR 0.152.
 */
package com.simba.googlebigquery.googlebigquery.client.metadata;

import com.simba.googlebigquery.dsi.dataengine.filters.IFilter;
import com.simba.googlebigquery.dsi.dataengine.utilities.MetadataSourceColumnTag;
import com.simba.googlebigquery.googlebigquery.client.BQClient;
import com.simba.googlebigquery.googlebigquery.client.metadata.BQFetchDatasetsTask;
import com.simba.googlebigquery.googlebigquery.client.metadata.BQMetadataResult;
import com.simba.googlebigquery.googlebigquery.client.metadata.BQThreadPoolExecutor;
import com.simba.googlebigquery.googlebigquery.core.BQDriver;
import com.simba.googlebigquery.googlebigquery.dataengine.metadata.BQMetadataSource;
import com.simba.googlebigquery.googlebigquery.dataengine.metadata.BQMetadataUtils;
import com.simba.googlebigquery.googlebigquery.exceptions.BQMessageKey;
import com.simba.googlebigquery.support.ILogger;
import com.simba.googlebigquery.support.exceptions.ErrorException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;

public class BQMetadataExecutor {
    private BQClient m_bqClient;
    private BQMetadataUtils m_bqMetadataUtils;
    private final ILogger m_connLogger;
    private IFilter[] m_filters;
    private Map<MetadataSourceColumnTag, String> m_restrictions;
    List<Callable<List<BQMetadataResult>>> m_tasks;
    BQThreadPoolExecutor m_threadpool;

    public BQMetadataExecutor(ILogger iLogger, BQClient bQClient, BQMetadataUtils bQMetadataUtils, IFilter[] iFilterArray, Map<MetadataSourceColumnTag, String> map, int n) {
        this.m_bqClient = bQClient;
        this.m_bqMetadataUtils = bQMetadataUtils;
        this.m_connLogger = iLogger;
        this.m_filters = iFilterArray;
        this.m_restrictions = map;
        this.m_tasks = new ArrayList<Callable<List<BQMetadataResult>>>();
        this.m_threadpool = new BQThreadPoolExecutor(n);
    }

    public void queue(Callable<List<BQMetadataResult>> callable) {
        this.m_tasks.add(callable);
    }

    public BQMetadataResult execute(FetchType fetchType) throws ErrorException {
        BQMetadataResult bQMetadataResult = new BQMetadataResult();
        try {
            Object object;
            Object object2;
            Object object3 = this.m_bqClient.getProjects();
            if (null != this.m_filters[0] && object3.size() > 0) {
                object2 = new ArrayList();
                object = object3.iterator();
                while (object.hasNext()) {
                    String string = (String)object.next();
                    if (null != this.m_restrictions.get((Object)MetadataSourceColumnTag.CATALOG_NAME) && string.equals(this.m_restrictions.get((Object)MetadataSourceColumnTag.CATALOG_NAME))) {
                        object2.add(string);
                        continue;
                    }
                    if (null == this.m_filters[0] || !BQMetadataSource.doesMetadataPassFilter(string, this.m_filters[0])) continue;
                    object2.add(string);
                }
                object3 = object2;
            }
            bQMetadataResult.addProjects((List<String>)object3);
            if (FetchType.PROJECT != fetchType) {
                object2 = object3.iterator();
                while (object2.hasNext()) {
                    object = (String)object2.next();
                    this.m_threadpool.submit(new BQFetchDatasetsTask(this.m_connLogger, this.m_threadpool, this.m_bqClient, this.m_bqMetadataUtils, (String)object, fetchType, this.m_filters, this.m_restrictions));
                }
                while (this.m_threadpool.getTaskCount() > 0) {
                    object2 = this.m_threadpool.take();
                    bQMetadataResult.merge((BQMetadataResult)object2);
                }
            }
        }
        catch (InterruptedException | ExecutionException exception) {
            this.m_threadpool.shutdownNow();
            Throwable throwable = exception.getCause();
            String string = null == throwable || null == throwable.getCause() ? exception.getMessage() : throwable.getCause().getMessage();
            throw BQDriver.s_BQMessages.createGeneralException(BQMessageKey.METADATA_FETCH_ERR.name(), string, (Throwable)exception);
        }
        this.m_threadpool.shutdownNow();
        return bQMetadataResult;
    }

    public static enum FetchType {
        COLUMN,
        DATASET,
        FUNCTION,
        FUNCTIONCOLUMN,
        PROCEDURECOLUMN,
        PROCEDURE,
        PROJECT,
        TABLE;

    }
}

