/*
 * Decompiled with CFR 0.152.
 */
package com.simba.googlebigquery.googlebigquery.client.metadata;

import com.google.api.services.bigquery.model.DatasetList;
import com.google.api.services.bigquery.model.DatasetReference;
import com.simba.googlebigquery.dsi.dataengine.filters.IFilter;
import com.simba.googlebigquery.dsi.dataengine.utilities.MetadataSourceColumnTag;
import com.simba.googlebigquery.googlebigquery.client.BQClient;
import com.simba.googlebigquery.googlebigquery.client.metadata.BQFetchFunctionsTask;
import com.simba.googlebigquery.googlebigquery.client.metadata.BQFetchTablesTask;
import com.simba.googlebigquery.googlebigquery.client.metadata.BQMetadataExecutor;
import com.simba.googlebigquery.googlebigquery.client.metadata.BQMetadataResult;
import com.simba.googlebigquery.googlebigquery.client.metadata.BQMetadataRetryRequest;
import com.simba.googlebigquery.googlebigquery.client.metadata.BQThreadPoolExecutor;
import com.simba.googlebigquery.googlebigquery.dataengine.metadata.BQMetadataSource;
import com.simba.googlebigquery.googlebigquery.dataengine.metadata.BQMetadataUtils;
import com.simba.googlebigquery.support.ILogger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;

public class BQFetchDatasetsTask
implements Callable<BQMetadataResult> {
    private BQMetadataUtils m_bqMetadataUtils;
    private BQClient m_client;
    private final ILogger m_connLogger;
    protected IFilter[] m_filters;
    private String m_project;
    private Map<MetadataSourceColumnTag, String> m_restrictions;
    private BQThreadPoolExecutor m_threadpool;
    private BQMetadataExecutor.FetchType m_type;

    public BQFetchDatasetsTask(ILogger iLogger, BQThreadPoolExecutor bQThreadPoolExecutor, BQClient bQClient, BQMetadataUtils bQMetadataUtils, String string, BQMetadataExecutor.FetchType fetchType, IFilter[] iFilterArray, Map<MetadataSourceColumnTag, String> map) {
        this.m_client = bQClient;
        this.m_connLogger = iLogger;
        this.m_project = string;
        this.m_type = fetchType;
        this.m_bqMetadataUtils = bQMetadataUtils;
        this.m_threadpool = bQThreadPoolExecutor;
        this.m_filters = iFilterArray;
        this.m_restrictions = map;
    }

    @Override
    public BQMetadataResult call() throws Exception {
        DatasetReference datasetReference;
        Object object;
        BQMetadataRetryRequest<List<DatasetReference>> bQMetadataRetryRequest = new BQMetadataRetryRequest<List<DatasetReference>>(this.m_connLogger){

            @Override
            public List<DatasetReference> execute() throws Exception {
                List<DatasetList> list = BQFetchDatasetsTask.this.m_client.getDatasetLists(BQFetchDatasetsTask.this.m_project);
                return BQMetadataUtils.convertDatasetListToDatasetReferences(list);
            }
        };
        Object object2 = (List)bQMetadataRetryRequest.executeWithRetry();
        if (null != this.m_filters[1] && object2.size() > 0) {
            object = new ArrayList();
            datasetReference = object2.iterator();
            while (datasetReference.hasNext()) {
                DatasetReference datasetReference2 = (DatasetReference)datasetReference.next();
                String string = datasetReference2.getDatasetId();
                if (null != this.m_restrictions.get((Object)MetadataSourceColumnTag.SCHEMA_NAME) && string.equals(this.m_restrictions.get((Object)MetadataSourceColumnTag.SCHEMA_NAME))) {
                    object.add(datasetReference2);
                    continue;
                }
                if (!BQMetadataSource.doesMetadataPassFilter(string, this.m_filters[1])) continue;
                object.add(datasetReference2);
            }
            object2 = object;
        }
        switch (this.m_type) {
            case COLUMN: 
            case TABLE: {
                object = object2.iterator();
                while (object.hasNext()) {
                    datasetReference = (DatasetReference)object.next();
                    this.m_threadpool.submit(new BQFetchTablesTask(this.m_connLogger, this.m_threadpool, this.m_bqMetadataUtils, datasetReference, this.m_type, this.m_filters, this.m_restrictions));
                }
                break;
            }
            case FUNCTION: 
            case FUNCTIONCOLUMN: 
            case PROCEDURE: 
            case PROCEDURECOLUMN: {
                object = object2.iterator();
                while (object.hasNext()) {
                    datasetReference = (DatasetReference)object.next();
                    this.m_threadpool.submit(new BQFetchFunctionsTask(this.m_connLogger, this.m_threadpool, this.m_bqMetadataUtils, datasetReference, this.m_type, this.m_filters, this.m_restrictions));
                }
                break;
            }
        }
        object = new BQMetadataResult();
        ((BQMetadataResult)object).addDatasets((List<DatasetReference>)object2);
        return object;
    }
}

