/*
 * Decompiled with CFR 0.152.
 */
package com.simba.googlebigquery.googlebigquery.client.authentication;

import com.google.auth.http.HttpTransportFactory;
import com.google.auth.oauth2.AccessToken;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.auth.oauth2.UserCredentials;
import com.simba.googlebigquery.googlebigquery.client.authentication.AbstractAuthentication;
import com.simba.googlebigquery.googlebigquery.core.BQConnectionOptions;
import com.simba.googlebigquery.googlebigquery.core.BQDriver;
import com.simba.googlebigquery.googlebigquery.core.propertyutils.PrivateServiceConnectUris;
import com.simba.googlebigquery.googlebigquery.exceptions.BQMessageKey;
import com.simba.googlebigquery.support.exceptions.ErrorException;
import java.net.URI;

public class UserAccountTokenAuth
extends AbstractAuthentication {
    private static final String OAUTH_TOKEN_SERVICE_ENDPOINT = "/token";
    private String m_accessToken;
    private String m_clientId;
    private String m_clientSecret;
    private String m_refreshToken;
    private final String m_tokenUri;

    public UserAccountTokenAuth(PrivateServiceConnectUris privateServiceConnectUris, BQConnectionOptions.TrustStoreSettings trustStoreSettings, BQConnectionOptions.ProxySettings proxySettings) throws ErrorException {
        super(BQConnectionOptions.OAuthMechanism.TOKEN, trustStoreSettings, proxySettings);
        this.m_tokenUri = privateServiceConnectUris.getOAuth2Uri();
    }

    @Override
    public GoogleCredentials buildCredentials() throws ErrorException {
        this.validateConfiguration();
        if (null != this.m_accessToken && null == this.m_refreshToken) {
            return GoogleCredentials.newBuilder().setAccessToken(new AccessToken(this.m_accessToken, null)).build();
        }
        if (null == this.m_clientId || this.m_clientId.isEmpty()) {
            throw BQDriver.s_BQMessages.createGeneralException(BQMessageKey.CONN_MISSING_CLIENT_ID.name());
        }
        if (null == this.m_clientSecret || this.m_clientSecret.isEmpty()) {
            throw BQDriver.s_BQMessages.createGeneralException(BQMessageKey.CONN_MISSING_CLIENT_SECRET.name());
        }
        UserCredentials.Builder builder = UserCredentials.newBuilder().setClientId(this.m_clientId).setClientSecret(this.m_clientSecret).setRefreshToken(this.m_refreshToken).setHttpTransportFactory((HttpTransportFactory)this.m_transportFactory).setTokenServerUri(URI.create(this.m_tokenUri + OAUTH_TOKEN_SERVICE_ENDPOINT));
        if (null != this.m_accessToken && !this.m_accessToken.isEmpty()) {
            builder.setAccessToken(new AccessToken(this.m_accessToken, null));
        }
        return builder.build();
    }

    public void setAccessToken(String string) {
        this.m_accessToken = string;
    }

    public void setClientId(String string) {
        this.m_clientId = string;
    }

    public void setClientSecret(String string) {
        this.m_clientSecret = string;
    }

    public void setRefreshToken(String string) {
        this.m_refreshToken = string;
    }

    private void validateConfiguration() throws ErrorException {
        if ((null == this.m_accessToken || this.m_accessToken.isEmpty()) && (null == this.m_refreshToken || this.m_refreshToken.isEmpty())) {
            throw BQDriver.s_BQMessages.createGeneralException(BQMessageKey.CONN_MISSING_TOKEN.name());
        }
    }
}

