/*
 * Decompiled with CFR 0.152.
 */
package com.simba.googlebigquery.googlebigquery.client.authentication;

import com.google.api.client.googleapis.auth.oauth2.GoogleAuthorizationCodeFlow;
import com.google.api.client.googleapis.auth.oauth2.GoogleAuthorizationCodeRequestUrl;
import com.google.api.client.googleapis.auth.oauth2.GoogleClientSecrets;
import com.google.api.client.googleapis.auth.oauth2.GoogleTokenResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.gson.GsonFactory;
import com.google.auth.http.HttpTransportFactory;
import com.google.auth.oauth2.AccessToken;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.auth.oauth2.UserCredentials;
import com.simba.googlebigquery.googlebigquery.client.authentication.AbstractAuthentication;
import com.simba.googlebigquery.googlebigquery.core.BQConnectionOptions;
import com.simba.googlebigquery.googlebigquery.core.BQDriver;
import com.simba.googlebigquery.googlebigquery.core.propertyutils.PrivateServiceConnectUris;
import com.simba.googlebigquery.googlebigquery.exceptions.BQMessageKey;
import com.simba.googlebigquery.support.exceptions.ErrorException;
import java.awt.Desktop;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URI;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

public class UserAccountInteractiveAuth
extends AbstractAuthentication {
    private static final String OAUTH_ACCESS_TYPE = "offline";
    private static final String OAUTH_APPROVAL_PROMPT = "force";
    private static final String OAUTH_REDIRECT_URI = "http://localhost";
    private static final String OAUTH_TOKEN_SERVICE_ENDPOINT = "/token";
    private static final String INVALID_TOKEN_REQUEST_RESPONSE = "HTTP/1.1 400 Bad Request\r\nContent-Length: 95\r\nConnection: close\r\nContent-Type: text/html; charset=utf-8\r\n\r\n<!DOCTYPE html><html><body>The request could not be understood by the server!</p></body></html>";
    private static final String VALID_TOKEN_REQUEST_RESPONSE = "HTTP/1.1 200 OK\r\nContent-Length: 300\r\nConnection: close\r\nContent-Type: text/html; charset=utf-8\r\n\r\n<!DOCTYPE html><html><body>\nThank you for using Simba's JDBC Driver for Google BigQuery!\nYou may now close the window.</body></html>";
    private final String m_authUri;
    private String m_clientId;
    private String m_clientSecret;
    private final String m_tokenUri;
    private GoogleCredentials m_userCredentials;
    private final Set<String> m_scopes;

    public UserAccountInteractiveAuth(PrivateServiceConnectUris privateServiceConnectUris, BQConnectionOptions.TrustStoreSettings trustStoreSettings, BQConnectionOptions.ProxySettings proxySettings) throws ErrorException {
        super(BQConnectionOptions.OAuthMechanism.USER_ACCOUNT, trustStoreSettings, proxySettings);
        this.m_authUri = privateServiceConnectUris.getAccountsUri();
        this.m_tokenUri = privateServiceConnectUris.getOAuth2Uri();
        this.m_scopes = new HashSet<String>();
        this.m_scopes.add("https://www.googleapis.com/auth/bigquery");
        this.m_userCredentials = null;
    }

    public void addScope(String string) {
        this.m_scopes.add(string);
    }

    @Override
    public GoogleCredentials buildCredentials() throws ErrorException {
        if (null != this.m_userCredentials) {
            return this.m_userCredentials;
        }
        if (!Desktop.isDesktopSupported()) {
            throw BQDriver.s_BQMessages.createGeneralException(BQMessageKey.CONN_GOOGLE_AUTH_ERR.name(), "Cannot use browser flow when desktop is not supported.");
        }
        this.validateConfiguration();
        GoogleClientSecrets.Details details = new GoogleClientSecrets.Details().setAuthUri(this.m_authUri).setTokenUri(this.m_tokenUri).setClientId(this.m_clientId).setClientSecret(this.m_clientSecret);
        GoogleClientSecrets googleClientSecrets = new GoogleClientSecrets().setInstalled(details);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(OAUTH_REDIRECT_URI).append(":");
        try (ServerSocket serverSocket = new ServerSocket(0);){
            stringBuilder.append(serverSocket.getLocalPort());
            String string = new GoogleAuthorizationCodeRequestUrl(googleClientSecrets, stringBuilder.toString(), this.m_scopes).build();
            Desktop.getDesktop().browse(new URI(string));
            Socket socket = serverSocket.accept();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            PrintWriter printWriter = new PrintWriter(socket.getOutputStream(), true);
            String string2 = this.parseAuthCode(bufferedReader.readLine());
            RuntimeException runtimeException = null;
            if (string2.isEmpty()) {
                printWriter.println(INVALID_TOKEN_REQUEST_RESPONSE);
                runtimeException = new RuntimeException("No authorization code obtained from the server.");
            } else {
                printWriter.println(VALID_TOKEN_REQUEST_RESPONSE);
            }
            socket.close();
            if (null != runtimeException) {
                throw runtimeException;
            }
            HttpTransport httpTransport = this.m_transportFactory.create();
            GsonFactory gsonFactory = new GsonFactory();
            GoogleAuthorizationCodeFlow googleAuthorizationCodeFlow = new GoogleAuthorizationCodeFlow.Builder(httpTransport, (JsonFactory)gsonFactory, googleClientSecrets, this.m_scopes).setAccessType(OAUTH_ACCESS_TYPE).setApprovalPrompt(OAUTH_APPROVAL_PROMPT).build();
            GoogleTokenResponse googleTokenResponse = googleAuthorizationCodeFlow.newTokenRequest(string2).setRedirectUri(stringBuilder.toString()).execute();
            long l = googleTokenResponse.getExpiresInSeconds() * 1000L;
            Date date = new Date(Calendar.getInstance().getTimeInMillis() + l);
            this.m_userCredentials = UserCredentials.newBuilder().setClientSecret(this.m_clientSecret).setClientId(this.m_clientId).setRefreshToken(googleTokenResponse.getRefreshToken()).setAccessToken(new AccessToken(googleTokenResponse.getAccessToken(), date)).setTokenServerUri(URI.create(this.m_tokenUri + OAUTH_TOKEN_SERVICE_ENDPOINT)).setHttpTransportFactory((HttpTransportFactory)this.m_transportFactory).build();
        }
        catch (Exception exception) {
            throw BQDriver.s_BQMessages.createGeneralException(BQMessageKey.CONN_GOOGLE_AUTH_ERR.name(), (Throwable)exception);
        }
        return this.m_userCredentials;
    }

    public void setClientId(String string) {
        this.m_clientId = string;
    }

    public void setClientSecret(String string) {
        this.m_clientSecret = string;
    }

    private String parseAuthCode(String string) {
        int n = string.indexOf("code=");
        String string2 = string.substring(n);
        int n2 = string2.indexOf(61);
        int n3 = string2.indexOf(38);
        if (-1 == n3) {
            n3 = string2.indexOf(32);
        }
        return string2.substring(n2 + 1, n3);
    }

    private void validateConfiguration() throws ErrorException {
        if (null == this.m_clientId || this.m_clientId.isEmpty()) {
            throw BQDriver.s_BQMessages.createGeneralException(BQMessageKey.CONN_MISSING_CLIENT_ID.name());
        }
        if (null == this.m_clientSecret || this.m_clientSecret.isEmpty()) {
            throw BQDriver.s_BQMessages.createGeneralException(BQMessageKey.CONN_MISSING_CLIENT_SECRET.name());
        }
    }
}

