/*
 * Decompiled with CFR 0.152.
 */
package com.simba.googlebigquery.googlebigquery.client.authentication;

import com.google.api.client.util.SecurityUtils;
import com.google.auth.http.HttpTransportFactory;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.auth.oauth2.ServiceAccountCredentials;
import com.simba.googlebigquery.googlebigquery.client.authentication.AbstractAuthentication;
import com.simba.googlebigquery.googlebigquery.core.BQConnectionOptions;
import com.simba.googlebigquery.googlebigquery.core.BQDriver;
import com.simba.googlebigquery.googlebigquery.exceptions.BQMessageKey;
import com.simba.googlebigquery.support.exceptions.ErrorException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.util.HashSet;
import java.util.Set;

public class ServiceAccountAuth
extends AbstractAuthentication {
    private static final String JSON_SUFFIX = ".json";
    private static final String P12_SUFFIX = ".p12";
    private String m_email;
    private KeyFileType m_keyFileType = KeyFileType.PLAINTEXT;
    private final Set<String> m_scopes = new HashSet<String>();
    private String m_serviceKey;

    public ServiceAccountAuth(BQConnectionOptions.ProxySettings proxySettings, BQConnectionOptions.TrustStoreSettings trustStoreSettings) throws ErrorException {
        super(BQConnectionOptions.OAuthMechanism.SERVICE_ACCOUNT, trustStoreSettings, proxySettings);
        this.m_scopes.add("https://www.googleapis.com/auth/bigquery");
    }

    public void addScope(String string) {
        this.m_scopes.add(string);
    }

    @Override
    public GoogleCredentials buildCredentials() throws ErrorException {
        try {
            switch (this.m_keyFileType) {
                case P12: {
                    PrivateKey privateKey = SecurityUtils.loadPrivateKeyFromKeyStore((KeyStore)SecurityUtils.getPkcs12KeyStore(), (InputStream)Files.newInputStream(Paths.get(this.m_serviceKey, new String[0]), new OpenOption[0]), (String)"notasecret", (String)"privatekey", (String)"notasecret");
                    return ServiceAccountCredentials.newBuilder().setClientEmail(this.m_email).setPrivateKey(privateKey).setScopes(this.m_scopes).setHttpTransportFactory((HttpTransportFactory)this.m_transportFactory).build();
                }
                case JSON: {
                    return ServiceAccountCredentials.fromStream((InputStream)Files.newInputStream(Paths.get(this.m_serviceKey, new String[0]), new OpenOption[0]), (HttpTransportFactory)this.m_transportFactory).createScoped(this.m_scopes);
                }
                case PLAINTEXT: {
                    return ServiceAccountCredentials.fromStream((InputStream)new ByteArrayInputStream(this.m_serviceKey.getBytes()), (HttpTransportFactory)this.m_transportFactory).createScoped(this.m_scopes);
                }
            }
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw BQDriver.s_BQMessages.createGeneralException(BQMessageKey.CONN_HTTP_SECURITY_ERR.name(), generalSecurityException.getMessage(), (Throwable)generalSecurityException);
        }
        catch (IOException iOException) {
            throw BQDriver.s_BQMessages.createGeneralException(BQMessageKey.CONN_HTTP_IO_ERR.name(), iOException.getMessage(), (Throwable)iOException);
        }
        return null;
    }

    public void readKeyFile(String string) {
        this.m_keyFileType = string.endsWith(JSON_SUFFIX) ? KeyFileType.JSON : (string.endsWith(P12_SUFFIX) ? KeyFileType.P12 : KeyFileType.PLAINTEXT);
        this.m_serviceKey = string;
    }

    public void setEmail(String string) {
        this.m_email = string;
    }

    private static enum KeyFileType {
        P12,
        JSON,
        PLAINTEXT;

    }
}

