/*
 * Decompiled with CFR 0.152.
 */
package com.simba.googlebigquery.googlebigquery.client.authentication;

import com.google.auth.http.HttpTransportFactory;
import com.google.auth.oauth2.ExternalAccountCredentials;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import com.simba.googlebigquery.googlebigquery.client.authentication.AbstractAuthentication;
import com.simba.googlebigquery.googlebigquery.core.BQConnectionOptions;
import com.simba.googlebigquery.googlebigquery.core.BQDriver;
import com.simba.googlebigquery.googlebigquery.exceptions.BQMessageKey;
import com.simba.googlebigquery.support.exceptions.ErrorException;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.InputStream;
import java.io.Reader;
import java.util.HashSet;
import java.util.Set;

public class ExternalAccountAuth
extends AbstractAuthentication {
    private static final String DEFAULT_SUBJECT_TOKEN_TYPE = "urn:ietf:params:oauth:token-type:id_token";
    private static final String JSON_SUFFIX = ".json";
    private static final String OAUTH_TOKEN_SERVICE_ENDPOINT = "/v1/token";
    private JsonObject m_configurationFile = new JsonObject();
    private final Set<String> m_scopes = new HashSet<String>();

    public ExternalAccountAuth(BQConnectionOptions.ProxySettings proxySettings, BQConnectionOptions.TrustStoreSettings trustStoreSettings) throws ErrorException {
        super(BQConnectionOptions.OAuthMechanism.EXTERNAL_ACCOUNT, trustStoreSettings, proxySettings);
        this.m_scopes.add("https://www.googleapis.com/auth/bigquery");
    }

    public void addScope(String string) {
        this.m_scopes.add(string);
    }

    @Override
    public GoogleCredentials buildCredentials() throws ErrorException {
        this.validateAndFillDefaults();
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String string = gson.toJson((JsonElement)this.m_configurationFile);
        try {
            return ExternalAccountCredentials.fromStream((InputStream)new ByteArrayInputStream(string.getBytes()), (HttpTransportFactory)this.m_transportFactory).createScoped(this.m_scopes);
        }
        catch (Exception exception) {
            throw BQDriver.s_BQMessages.createGeneralException(BQMessageKey.CONN_HTTP_IO_ERR.name(), exception.getMessage(), (Throwable)exception);
        }
    }

    public void parseConfiguration(String string) throws ErrorException {
        try {
            this.m_configurationFile = string.endsWith(JSON_SUFFIX) ? JsonParser.parseReader((Reader)new FileReader(string)).getAsJsonObject() : JsonParser.parseString((String)string).getAsJsonObject();
            JsonObject jsonObject = this.m_configurationFile.getAsJsonObject("credential_source");
            if (jsonObject != null && jsonObject.get("executable") != null) {
                throw BQDriver.s_BQMessages.createGeneralException(BQMessageKey.CONN_FAILED_ERR.name(), "External Account Authentication with executable as credential source is not supported");
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw BQDriver.s_BQMessages.createGeneralException(BQMessageKey.CONN_HTTP_IO_ERR.name(), fileNotFoundException.getMessage(), (Throwable)fileNotFoundException);
        }
    }

    public ExternalAccountAuth setAudience(String string) {
        this.m_configurationFile.add("audience", (JsonElement)new JsonPrimitive(string));
        return this;
    }

    public ExternalAccountAuth setCredentialSource(String string) throws ErrorException {
        try {
            JsonObject jsonObject = JsonParser.parseString((String)string).getAsJsonObject();
            if (jsonObject != null && jsonObject.get("executable") != null) {
                throw BQDriver.s_BQMessages.createGeneralException(BQMessageKey.CONN_FAILED_ERR.name(), "External Account Authentication with executable as credential source is not supported");
            }
            this.m_configurationFile.add("credential_source", JsonParser.parseString((String)string));
        }
        catch (JsonSyntaxException jsonSyntaxException) {
            throw BQDriver.s_BQMessages.createGeneralException(BQMessageKey.CONN_HTTP_IO_ERR.name(), jsonSyntaxException.getMessage(), (Throwable)jsonSyntaxException);
        }
        return this;
    }

    public ExternalAccountAuth setImpersonationUri(String string) {
        this.m_configurationFile.add("service_account_impersonation_url", (JsonElement)new JsonPrimitive(string));
        return this;
    }

    public ExternalAccountAuth setPoolProject(String string) {
        this.m_configurationFile.add("workforce_pool_user_project", (JsonElement)new JsonPrimitive(string));
        return this;
    }

    public ExternalAccountAuth setTokenType(String string) {
        this.m_configurationFile.add("subject_token_type", (JsonElement)new JsonPrimitive(string));
        return this;
    }

    public String getTokenUri() {
        if (null != this.m_configurationFile.get("token_url")) {
            return this.m_configurationFile.get("token_url").getAsString();
        }
        return null;
    }

    public ExternalAccountAuth setTokenUri(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string);
        if (!string.contains(OAUTH_TOKEN_SERVICE_ENDPOINT)) {
            stringBuilder.append(OAUTH_TOKEN_SERVICE_ENDPOINT);
        }
        this.m_configurationFile.add("token_url", (JsonElement)new JsonPrimitive(stringBuilder.toString()));
        return this;
    }

    private void validateAndFillDefaults() {
        if (!this.m_configurationFile.has("subject_token_type") || this.m_configurationFile.get("subject_token_type").getAsString().isEmpty()) {
            this.setTokenType(DEFAULT_SUBJECT_TOKEN_TYPE);
        }
    }

    private static class ConfigFileKeys {
        private static final String AUDIENCE = "audience";
        private static final String CREDENTIAL_SOURCE = "credential_source";
        private static final String POOL_USER_PROJECT = "workforce_pool_user_project";
        private static final String SERVICE_ACCOUNT_IMPERSONATION_URL = "service_account_impersonation_url";
        private static final String SUBJECT_TOKEN_TYPE = "subject_token_type";
        private static final String TOKEN_URL = "token_url";

        private ConfigFileKeys() {
        }
    }
}

